/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.impl;

import com.intellij.licensecommon.license.AbstractLicenseData;
import com.intellij.licensecommon.license.MaintenanceDueAware;
import java.util.Date;

public class ServerLicenseData
extends AbstractLicenseData
implements MaintenanceDueAware {
    private final String myTicketId;
    private final String myServerUrl;
    private final String myLicensedTo;
    private final int myLicenseType;
    private final long myProlongationPeriod;
    private boolean myIsPermanent;
    private final Date myMaintenanceDueDate;

    public ServerLicenseData(String ticketId, long prolongationPeriod, String serverUrl, String licensedTo, int licenseType, Date maintenanceDueDate) {
        super(true, false);
        this.myProlongationPeriod = prolongationPeriod;
        this.myTicketId = ticketId;
        this.myServerUrl = serverUrl;
        this.myLicensedTo = licensedTo;
        this.myLicenseType = licenseType;
        this.myMaintenanceDueDate = maintenanceDueDate;
    }

    public static ServerLicenseData restoreFromFile(String serverUrl) {
        return new ServerLicenseData("", 0L, serverUrl, "", 0, null);
    }

    @Override
    public Date getExpirationDate() {
        return null;
    }

    public boolean isPermanent() {
        return this.myIsPermanent;
    }

    public void setPermanent(boolean isPermanent) {
        this.myIsPermanent = isPermanent;
    }

    @Override
    public Date getGenerationDate() {
        return new Date();
    }

    @Override
    public String getKey() {
        return "";
    }

    @Override
    public int getMajorVersion() {
        return Integer.MAX_VALUE;
    }

    @Override
    public String getUserName() {
        return this.myLicensedTo;
    }

    @Override
    public boolean isExpired(Date currentDate) {
        return false;
    }

    public int getLicenseType() {
        return this.myLicenseType;
    }

    @Override
    public boolean isNonCommercial() {
        return this.myLicenseType == 1;
    }

    @Override
    public boolean isOpenSource() {
        return this.myLicenseType == 3;
    }

    @Override
    public boolean isPersonal() {
        return this.myLicenseType == 4;
    }

    @Override
    public boolean isHacked() {
        return false;
    }

    @Override
    public boolean isYearAcademic() {
        return this.myLicenseType == 5;
    }

    @Override
    public boolean shouldDetectDuplicates() {
        return false;
    }

    public long getProlongationPeriod() {
        return this.myProlongationPeriod;
    }

    public String getTicketId() {
        return this.myTicketId;
    }

    public String getServerUrl() {
        return this.myServerUrl;
    }

    @Override
    public Date getMaintenanceDueDate() {
        return this.myMaintenanceDueDate;
    }
}

