/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.impl;

import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.Prefs;
import com.intellij.ide.license.LicenseCreationException;
import com.intellij.ide.license.LicenseFactory;
import com.intellij.ide.license.LicenseManager;
import com.intellij.ide.license.ProductDescriptor;
import com.intellij.ide.license.impl.GeneralLicenseManager;
import com.intellij.ide.license.impl.GeneralLicenseSource;
import com.intellij.ide.license.impl.NoFreeTicketException;
import com.intellij.ide.license.impl.ServerConnectionException;
import com.intellij.ide.license.impl.ServerLicenseData;
import com.intellij.ide.license.impl.ServerProtocolHijacked;
import com.intellij.ide.license.impl.ValidationFailedException;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.SyncDateFormat;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ServerSource
extends GeneralLicenseSource {
    private static final Logger LOG = Logger.getInstance((String)"#ServerLicenseSource");
    private static final long SERVER_ABSENSE_TOLERANCE_TIMEOUT = 172800000L;
    private static final SyncDateFormat DATE_FORMAT = new SyncDateFormat((DateFormat)new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy"));
    private static final int MAX_DESCRIPTION_LENGTH = 150;
    private static final int DEFAULT_PROLONGATION_PERIOD = 600000;
    private static final String TICKET_ID = "ticket.id";
    private static final String SIGNATURE = "signature";
    private static final String MACHINE_ID = "machine.id";
    private static final String TIMESTAMP = "timestamp";
    private static final String PROLONGATION_PERIOD = "prolongation.period";
    private static final String SERVER_URL = "server.url";
    private final AtomicBoolean myReobtainScheduled = new AtomicBoolean(false);
    private final String myProductUUID;
    private final int myProductVersion;
    private final GeneralLicenseManager myManager;
    private String myServerUrl;
    private volatile long myLastTimeSeenServer = 0L;
    private volatile ProlongTaskFuture myProlongTaskFuture;
    private ApplicationAdapter myAppListener;

    public ServerSource(LicenseFactory factory2, int productVersion, GeneralLicenseManager manager) {
        super(factory2);
        this.myProductVersion = productVersion;
        this.myManager = manager;
        this.myProductUUID = factory2.getProductDescriptor().getProductFamily().toString();
    }

    private static String calcSignature(String serverUrl, String machineId, long now, long prolongationPeriod, String userName, String ticketId, String licenseType) {
        StringBuilder builder = new StringBuilder();
        builder.append(serverUrl);
        builder.append(prolongationPeriod);
        if (now != 0L) {
            builder.append(now);
        }
        builder.append(userName);
        builder.append(machineId);
        builder.append(ticketId);
        builder.append(licenseType);
        int signature = builder.toString().hashCode();
        return Integer.toHexString(signature);
    }

    protected static void showError(@NotNull String title, @NotNull String description) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/ide/license/impl/ServerSource", "showError"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/ide/license/impl/ServerSource", "showError"));
        }
        if (description.length() > 150) {
            description = description.substring(0, 150) + "...";
        }
        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), description, title, 0);
    }

    private static String stripTrailingSlash(String url) {
        if (url != null && url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    public final void setServerUrl(String serverUrl) {
        this.myServerUrl = serverUrl != null ? serverUrl.trim() : null;
    }

    public final String getServerUrl() {
        return this.myServerUrl;
    }

    @Override
    public void restore() {
        try {
            this.setLicense(this.restoreOrObtainFromServer(false, true));
        }
        catch (LicenseCreationException licenseCreationException) {
            // empty catch block
        }
    }

    @Override
    public void create() throws LicenseCreationException {
        this.setLicense(this.restoreOrObtainFromServer(true, false));
    }

    @Override
    public boolean hasCachedData() {
        return this.getLicense() != null || ServerSource.loadProperties(this.getLicenseServerTicketLocation()) != null || ServerSource.loadProperties(this.getPermanentLicenseKeyLocation()) != null;
    }

    @Nullable
    private ServerLicenseData restoreOrObtainFromServer(boolean fromUser, boolean accepted) throws LicenseCreationException {
        try {
            ServerLicenseData restoredPermanent = this.readStoredTicketInfo(this.myServerUrl, true);
            if (restoredPermanent != null) {
                return restoredPermanent;
            }
        }
        catch (CorruptedLicenseData e2) {
            throw new LicenseCreationException("License data corrupt", e2.getMessage());
        }
        catch (TicketRestoreException e2) {
            // empty catch block
        }
        if (this.myServerUrl != null) {
            try {
                ServerLicenseData created = this.obtainTicketFromServer(this.myServerUrl);
                this.updateLicenseStamp();
                created.setFromUser(fromUser);
                created.setAccepted(accepted);
                return created;
            }
            catch (ServerProtocolHijacked serverProtocolHijacked) {
                String reason = serverProtocolHijacked.getMessage();
                String message2 = IdeBundle.message((String)"message.server.protocol.hijacked", (Object[])new Object[]{StringUtil.isEmptyOrSpaces((String)reason) ? "Server hijacked?" : reason});
                LOG.info(message2);
                throw new LicenseCreationException("Server protocol error", message2);
            }
            catch (NoFreeTicketException e3) {
                LOG.info("No free ticket available");
                throw new LicenseCreationException("No free ticket available");
            }
            catch (ServerConnectionException e4) {
                String message3;
                String additionalErrorDescription = null;
                try {
                    ServerLicenseData license = this.readStoredTicketInfo(this.myServerUrl, false);
                    if (license != null) {
                        return license;
                    }
                }
                catch (TooLongServerAbsence ex) {
                    additionalErrorDescription = ex.getMessage();
                }
                catch (TicketRestoreException ex) {
                    additionalErrorDescription = ex.getMessage();
                }
                String logMessage = message3 = ServerSource.getConnectionErrorMessage(e4, additionalErrorDescription);
                if (e4.getDetails() != null) {
                    logMessage = logMessage + " (" + e4.getDetails() + ")";
                }
                LOG.info(logMessage);
                throw new LicenseCreationException(message3);
            }
        }
        return null;
    }

    private static void reportConnectionProblem(ServerConnectionException e2, @Nullable String additionalErrorDescription) {
        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), ServerSource.getConnectionErrorMessage(e2, additionalErrorDescription), "Unable to Contact Server", 0);
    }

    private static String getConnectionErrorMessage(ServerConnectionException e2, String additionalErrorDescription) {
        StringBuilder message2 = new StringBuilder();
        String reason = e2.getMessage();
        if (!StringUtil.isEmptyOrSpaces((String)reason)) {
            message2.append(reason);
        }
        if (additionalErrorDescription != null) {
            if (message2.length() > 0) {
                message2.append("; ");
            }
            message2.append(additionalErrorDescription);
        }
        if (message2.length() == 0) {
            message2.append("Unable to contact license server");
        }
        return message2.toString();
    }

    protected void updateLicenseStamp() {
        this.myLastTimeSeenServer = System.currentTimeMillis();
    }

    @Override
    public void validate() {
    }

    protected String getPermanentLicenseKeyLocation() {
        return ServerSource.getPermanentLicenseKeyLocation(this.getProductFamilyUUID());
    }

    @NotNull
    private static String getPermanentLicenseKeyLocation(String uuid) {
        String string2 = "JetBrains." + uuid + ".PermanentLicense";
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/ServerSource", "getPermanentLicenseKeyLocation"));
        }
        return string2;
    }

    protected String getLicenseServerTicketLocation() {
        return ServerSource.getLicenseServerTicketLocation(this.getProductFamilyUUID());
    }

    @NotNull
    private static String getLicenseServerTicketLocation(String uuid) {
        String string2 = "JetBrains." + uuid + ".LicenseServerTicket";
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/ServerSource", "getLicenseServerTicketLocation"));
        }
        return string2;
    }

    protected ServerLicenseData createLicenseData(String serverUrl, String ticketId, long prolongationPeriod, Map<String, String> properties) {
        Date maintenanceDueDate;
        String maintenanceDue = properties.get(this.getMaintenanceDuePropertyName());
        try {
            maintenanceDueDate = maintenanceDue == null ? null : DATE_FORMAT.parse(maintenanceDue);
        }
        catch (ParseException e2) {
            maintenanceDueDate = null;
        }
        int type = 0;
        try {
            type = Integer.parseInt(properties.get(this.getLicenseTypePropertyName()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String licensee = properties.get(this.getLicenseePropertyName());
        if (licensee == null) {
            licensee = "N/A";
        }
        return this.factory.createServerLicense(ticketId, prolongationPeriod, serverUrl, licensee, type, maintenanceDueDate);
    }

    protected abstract String getLicenseePropertyName();

    protected abstract String getMaintenanceDuePropertyName();

    protected abstract String getLicenseTypePropertyName();

    protected abstract String getMachineId();

    protected final String getProductFamilyUUID() {
        return this.myProductUUID;
    }

    protected final int getProductVersion() {
        return this.myProductVersion;
    }

    @NotNull
    protected abstract ServerLicenseData obtainTicketFromServer(String var1) throws NoFreeTicketException, ServerConnectionException, ServerProtocolHijacked;

    @NotNull
    protected abstract ProlongationCode prolongServerLicense(ServerLicenseData var1);

    protected abstract boolean releaseServerLicense(String var1, String var2);

    public static boolean isServerTicketObtained(ProductDescriptor descriptor2) {
        String uuid = descriptor2.getProductFamily().toString();
        Properties props = ServerSource.loadProperties(ServerSource.getLicenseServerTicketLocation(uuid));
        if (props == null) {
            props = ServerSource.loadProperties(ServerSource.getPermanentLicenseKeyLocation(uuid));
        }
        return props != null && props.getProperty(TICKET_ID, null) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void storeTicketInfo(ServerLicenseData license) {
        block12: {
            long now = license.isPermanent() ? 0L : this.myLastTimeSeenServer;
            String signatureAsString = ServerSource.calcSignature(license.getServerUrl(), this.getMachineId(), now, license.getProlongationPeriod(), license.getUserName(), license.getTicketId(), String.valueOf(license.getLicenseType()));
            Properties properties = new Properties();
            properties.setProperty(SERVER_URL, license.getServerUrl());
            properties.setProperty(PROLONGATION_PERIOD, String.valueOf(license.getProlongationPeriod()));
            properties.setProperty(MACHINE_ID, this.getMachineId());
            properties.setProperty(TICKET_ID, license.getTicketId());
            properties.setProperty(this.getLicenseePropertyName(), license.getUserName());
            properties.setProperty(SIGNATURE, signatureAsString);
            properties.setProperty(this.getLicenseTypePropertyName(), String.valueOf(license.getLicenseType()));
            Date maintenanceDate = license.getMaintenanceDueDate();
            if (maintenanceDate != null) {
                properties.setProperty(this.getMaintenanceDuePropertyName(), String.valueOf(maintenanceDate));
            }
            if (!license.isPermanent()) {
                properties.setProperty(TIMESTAMP, String.valueOf(now));
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            properties.store(stream, "License server ticket information. Please do not alter this data");
            try {
                stream.close();
                Prefs.putByteArray((String)(license.isPermanent() ? this.getPermanentLicenseKeyLocation() : this.getLicenseServerTicketLocation()), (byte[])stream.toByteArray());
            }
            catch (IOException e2) {
                LOG.error((Throwable)e2);
            }
            break block12;
            catch (IOException e3) {
                try {
                    LOG.error((Throwable)e3);
                }
                catch (Throwable throwable) {
                    try {
                        stream.close();
                        Prefs.putByteArray((String)(license.isPermanent() ? this.getPermanentLicenseKeyLocation() : this.getLicenseServerTicketLocation()), (byte[])stream.toByteArray());
                    }
                    catch (IOException e4) {
                        LOG.error((Throwable)e4);
                    }
                    throw throwable;
                }
                try {
                    stream.close();
                    Prefs.putByteArray((String)(license.isPermanent() ? this.getPermanentLicenseKeyLocation() : this.getLicenseServerTicketLocation()), (byte[])stream.toByteArray());
                }
                catch (IOException e5) {
                    LOG.error((Throwable)e5);
                }
            }
        }
    }

    @Nullable
    private ServerLicenseData readStoredTicketInfo(String serverUrl, boolean permanent) throws TicketRestoreException {
        long prolongation;
        if (serverUrl == null) {
            return null;
        }
        Properties properties = ServerSource.loadProperties(permanent ? this.getPermanentLicenseKeyLocation() : this.getLicenseServerTicketLocation());
        if (properties == null) {
            return null;
        }
        String url = properties.getProperty(SERVER_URL);
        if (!Comparing.equal((String)ServerSource.stripTrailingSlash(serverUrl), (String)ServerSource.stripTrailingSlash(url))) {
            return null;
        }
        String machineId = properties.getProperty(MACHINE_ID);
        String encodedSignature = properties.getProperty(SIGNATURE);
        String ticketId = properties.getProperty(TICKET_ID);
        String licensee = properties.getProperty(this.getLicenseePropertyName());
        String licenseType = properties.getProperty(this.getLicenseTypePropertyName());
        String maintenanceDueDate = properties.getProperty(this.getMaintenanceDuePropertyName());
        String generationStamp = properties.getProperty(TIMESTAMP);
        try {
            prolongation = Long.parseLong(properties.getProperty(PROLONGATION_PERIOD));
        }
        catch (NumberFormatException e2) {
            prolongation = 600000L;
        }
        long timestamp = 0L;
        if (generationStamp != null) {
            try {
                timestamp = Long.parseLong(generationStamp);
                this.myLastTimeSeenServer = Math.max(timestamp, this.myLastTimeSeenServer);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!permanent && System.currentTimeMillis() - timestamp > 172800000L) {
            this.deleteStoredTicketInfo(serverUrl, ticketId, false);
            throw new TooLongServerAbsence();
        }
        String signature = ServerSource.calcSignature(url, machineId, timestamp, prolongation, licensee, ticketId, licenseType);
        if (!signature.equals(encodedSignature) || !machineId.equals(this.getMachineId())) {
            this.deleteStoredTicketInfo(serverUrl, ticketId, permanent);
            throw new CorruptedLicenseData();
        }
        HashMap<String, String> licenseProperties = new HashMap<String, String>();
        licenseProperties.put(this.getLicenseePropertyName(), licensee);
        licenseProperties.put(this.getLicenseTypePropertyName(), licenseType);
        if (maintenanceDueDate != null) {
            licenseProperties.put(this.getMaintenanceDuePropertyName(), maintenanceDueDate);
        }
        ServerLicenseData result2 = this.createLicenseData(url, ticketId, prolongation, licenseProperties);
        result2.setPermanent(permanent);
        return result2;
    }

    @Nullable
    private static Properties loadProperties(String key) {
        byte[] props = Prefs.getByteArray((String)key, null);
        if (props != null) {
            Properties properties = new Properties();
            ByteArrayInputStream stream = new ByteArrayInputStream(props);
            try {
                properties.load(stream);
                stream.close();
                return properties;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    protected void deleteStoredTicketInfo(String serverUrl, String ticketId, boolean permanent) {
        this.releaseServerLicense(serverUrl, ticketId);
        Prefs.remove((String)(permanent ? this.getPermanentLicenseKeyLocation() : this.getLicenseServerTicketLocation()));
    }

    protected void startProlongTask(ServerLicenseData license) {
        this.storeTicketInfo(license);
        ProlongPeriodicTask task2 = new ProlongPeriodicTask(license);
        long period = license.getProlongationPeriod();
        if (period <= 0L) {
            period = 600000L;
        }
        ScheduledFuture<?> future2 = JobScheduler.getScheduler().scheduleWithFixedDelay(task2, period, period, TimeUnit.MILLISECONDS);
        this.myProlongTaskFuture = new ProlongTaskFuture(future2, task2);
    }

    @Override
    public ServerLicenseData getLicense() {
        return (ServerLicenseData)super.getLicense();
    }

    public void releaseLicense() {
        this.stopProlongTask();
        ServerLicenseData currentLicense = this.getLicense();
        if (currentLicense != null && !currentLicense.isPermanent()) {
            this.setLicense(null);
        }
    }

    protected void stopProlongTask() {
        ProlongTaskFuture future2 = this.myProlongTaskFuture;
        if (future2 != null) {
            this.myProlongTaskFuture = null;
            future2.cancel(false);
        }
    }

    void reobtainFloatingTicket(String serverUrl, boolean delayed) {
        if (this.myReobtainScheduled.getAndSet(true)) {
            return;
        }
        Runnable restart = () -> {
            Ref newLicenseRef = new Ref(null);
            Ref errorRef = new Ref(null);
            try {
                ServerLicenseData newLicense = this.obtainTicketFromServer(serverUrl);
                this.updateLicenseStamp();
                newLicenseRef.set((Object)newLicense);
            }
            catch (ServerConnectionException e2) {
                errorRef.set((Object)e2);
            }
            catch (ServerProtocolHijacked serverProtocolHijacked) {
                errorRef.set((Object)serverProtocolHijacked);
            }
            catch (NoFreeTicketException e3) {
                errorRef.set((Object)e3);
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                ServerLicenseData newLicense;
                this.myReobtainScheduled.set(false);
                ValidationFailedException error = (ValidationFailedException)errorRef.get();
                boolean errorReported = false;
                if (error instanceof ServerConnectionException) {
                    if (delayed) {
                        ServerLicenseData restored = null;
                        String errorReason = null;
                        try {
                            restored = this.readStoredTicketInfo(serverUrl, false);
                        }
                        catch (TooLongServerAbsence ex) {
                            errorReason = ex.getMessage();
                        }
                        catch (TicketRestoreException ticketRestoreException) {
                            // empty catch block
                        }
                        newLicenseRef.set((Object)restored);
                        if (restored == null) {
                            ServerSource.reportConnectionProblem((ServerConnectionException)error, errorReason);
                            errorReported = true;
                        }
                    }
                } else if (error instanceof ServerProtocolHijacked) {
                    String reason = error.getMessage();
                    this.getMessages().showServerProtocolHijacked(StringUtil.isEmptyOrSpaces((String)reason) ? "Server hijacked?" : reason);
                    errorReported = true;
                } else if (error instanceof NoFreeTicketException) {
                    this.getMessages().showNoLicenseOnServer();
                    errorReported = true;
                }
                if ((newLicense = (ServerLicenseData)newLicenseRef.get()) != null) {
                    this.setLicense(newLicense);
                    this.startProlongTask(newLicense);
                } else {
                    if (!errorReported) {
                        this.getMessages().unableToContactLicenseServer();
                    }
                    this.myManager.askUserForLicense(new LicenseManager.StartupAction(){

                        @Override
                        public void cancel() {
                            GeneralLicenseManager.shutdownApplication();
                        }

                        @Override
                        public boolean cancelMeansShutdown() {
                            return true;
                        }
                    }, null, null);
                }
            }, ModalityState.NON_MODAL);
        };
        JobScheduler.getScheduler().schedule(restart, delayed ? 900L : 0L, TimeUnit.SECONDS);
    }

    public void startPinger() {
        if (this.myAppListener == null) {
            ApplicationAdapter listener2;
            this.myAppListener = listener2 = new ApplicationAdapter(){

                public void applicationExiting() {
                    ServerSource.this.stopProlongTask();
                }
            };
            ApplicationManager.getApplication().addApplicationListener((ApplicationListener)listener2);
        }
        this.stopProlongTask();
        this.startProlongTask(this.getLicense());
    }

    @Override
    public final boolean needNetworkLicenseCheck() {
        return false;
    }

    private class ProlongTaskFuture
    implements Future {
        private final Future myScheduledFuture;
        private final ProlongPeriodicTask myTask;

        ProlongTaskFuture(Future scheduledFuture, ProlongPeriodicTask task2) {
            this.myScheduledFuture = scheduledFuture;
            this.myTask = task2;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            try {
                boolean bl = this.myScheduledFuture.cancel(mayInterruptIfRunning);
                return bl;
            }
            finally {
                this.myTask.cancel();
            }
        }

        @Override
        public boolean isCancelled() {
            return this.myScheduledFuture.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.myScheduledFuture.isDone();
        }

        public Object get() throws InterruptedException, ExecutionException {
            return this.myScheduledFuture.get();
        }

        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.myScheduledFuture.get(timeout, unit);
        }
    }

    private class ProlongPeriodicTask
    implements Runnable {
        @NotNull
        private final ServerLicenseData myLicense;
        private final AtomicBoolean myInProgress;
        private final AtomicBoolean myCanceled;

        ProlongPeriodicTask(ServerLicenseData license) {
            if (license == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "license", "com/intellij/ide/license/impl/ServerSource$ProlongPeriodicTask", "<init>"));
            }
            this.myInProgress = new AtomicBoolean(false);
            this.myCanceled = new AtomicBoolean(false);
            this.myLicense = license;
        }

        public void cancel() {
            if (!this.myCanceled.getAndSet(true) && !this.myLicense.isPermanent()) {
                ServerSource.this.releaseServerLicense(this.myLicense.getServerUrl(), this.myLicense.getTicketId());
            }
        }

        @Override
        public void run() {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (!this.myInProgress.getAndSet(true)) {
                    try {
                        if (!this.myCanceled.get()) {
                            ProlongationCode rc = ServerSource.this.prolongServerLicense(this.myLicense);
                            if (rc == ProlongationCode.OK) {
                                ServerSource.this.updateLicenseStamp();
                                ServerSource.this.storeTicketInfo(this.myLicense);
                            } else {
                                ServerSource.this.stopProlongTask();
                                if (this.myLicense.isPermanent()) {
                                    if (rc != ProlongationCode.DISCONNECTED) {
                                        SwingUtilities.invokeLater(() -> Messages.showErrorDialog((String)"License server refused to verify permanent license. Ticket is revoked.", (String)"Permanent Ticket Revoked"));
                                        ServerSource.this.deleteStoredTicketInfo(this.myLicense.getServerUrl(), this.myLicense.getTicketId(), true);
                                        ServerSource.this.reobtainFloatingTicket(this.myLicense.getServerUrl(), false);
                                    }
                                } else {
                                    ServerSource.this.reobtainFloatingTicket(this.myLicense.getServerUrl(), rc == ProlongationCode.DISCONNECTED);
                                }
                            }
                        }
                    }
                    finally {
                        this.myInProgress.set(false);
                    }
                }
            });
        }
    }

    private static class CorruptedLicenseData
    extends TicketRestoreException {
        private CorruptedLicenseData() {
        }

        @Override
        public String getMessage() {
            return "Stored license data is corrupt. License Revoked";
        }
    }

    private static class TooLongServerAbsence
    extends TicketRestoreException {
        private TooLongServerAbsence() {
        }

        @Override
        public String getMessage() {
            return "No response from license server for more than 48 hours";
        }
    }

    private static class TicketRestoreException
    extends Exception {
        private TicketRestoreException() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    protected static enum ProlongationCode {
        OK,
        REFUSED,
        DISCONNECTED;

    }
}

