/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.impl;

import com.intellij.ide.license.impl.GeneralLicenseValidator;
import com.intellij.ide.license.impl.LicenseNeedUpgradeException;
import com.intellij.ide.license.impl.ValidationFailedException;
import com.intellij.licensecommon.license.LicenseData;
import com.intellij.licensecommon.license.MaintenanceDueAware;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

public class SubscriptionLicenseValidator
extends GeneralLicenseValidator {
    @NotNull
    private final Date myBuildDate;
    static final long YEAR = 31536000000L;

    public SubscriptionLicenseValidator(@NotNull Date buildDate) {
        if (buildDate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildDate", "com/intellij/ide/license/impl/SubscriptionLicenseValidator", "<init>"));
        }
        this.myBuildDate = buildDate;
    }

    @Override
    protected void checkNeedUpgrade(LicenseData licenseData) throws ValidationFailedException {
        if (licenseData instanceof MaintenanceDueAware) {
            this.checkMaintenancePeriod(((MaintenanceDueAware)((Object)licenseData)).getMaintenanceDueDate());
        } else {
            this.checkDefaultMaintenanceDueDate(licenseData);
        }
    }

    private void checkDefaultMaintenanceDueDate(@NotNull LicenseData licenseData) throws ValidationFailedException {
        if (licenseData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "licenseData", "com/intellij/ide/license/impl/SubscriptionLicenseValidator", "checkDefaultMaintenanceDueDate"));
        }
        Date generation = licenseData.getGenerationDate();
        Date defaultMaintenancePeriod = new Date(generation.getTime() + 31536000000L);
        this.checkMaintenancePeriod(defaultMaintenancePeriod);
    }

    private void checkMaintenancePeriod(@NotNull Date maintenanceDueDate) throws ValidationFailedException {
        if (maintenanceDueDate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maintenanceDueDate", "com/intellij/ide/license/impl/SubscriptionLicenseValidator", "checkMaintenancePeriod"));
        }
        if (this.myBuildDate.getTime() > maintenanceDueDate.getTime()) {
            throw new LicenseNeedUpgradeException(maintenanceDueDate);
        }
    }
}

