/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.pycharm;

import com.intellij.ide.license.LicenseFactory;
import com.intellij.ide.license.LicenseManager;
import com.intellij.ide.license.LicenseMessages;
import com.intellij.ide.license.ProductDescriptor;
import com.intellij.ide.license.common.StandardLicenseUrls;
import com.intellij.ide.license.common.StandardSubscriptionLicenseFactory;
import com.intellij.ide.license.impl.GeneralLicenseManager;
import com.intellij.ide.license.ui.LicenseMessagesImpl;
import com.intellij.licensecommon.license.LicenseInfoDecoder;
import com.intellij.licensecommon.util.InvalidLicenseKeyException;
import com.intellij.licensecommon.util.PyCharmLicenseDecoder;
import com.intellij.licensecommon.util.SubscriptionLicenseInfo;

public class PyCharmLicenseManager
extends GeneralLicenseManager {
    private LicenseMessagesImpl myLicenseMessages;

    public PyCharmLicenseManager() {
        StandardLicenseUrls urls = new StandardLicenseUrls("pycharm");
        this.myLicenseMessages = new LicenseMessagesImpl(urls, this.getEvaluationPeriod()).withLicenseEntryLines(7);
    }

    @Override
    public LicenseFactory createLicenseFactory() {
        return PyCharmLicenseManager.createPyCharmLicenseFactory(this.getMessages(), this.getEvaluationPeriod(), this);
    }

    static StandardSubscriptionLicenseFactory createPyCharmLicenseFactory(LicenseMessages messages, int evaluationPeriod, LicenseManager licenseManager) {
        return new StandardSubscriptionLicenseFactory(messages, ProductDescriptor.PYCHARM, evaluationPeriod, licenseManager, new LicenseInfoDecoder<SubscriptionLicenseInfo>(){

            @Override
            public SubscriptionLicenseInfo decode(String key, String userName) throws InvalidLicenseKeyException {
                return PyCharmLicenseDecoder.decode(key, userName);
            }
        });
    }

    @Override
    protected LicenseMessages getMessages() {
        return this.myLicenseMessages;
    }
}

