/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.ui;

import com.intellij.ide.license.LicenseSource;
import com.intellij.ide.license.ui.LicenseDataEditControl;
import com.intellij.ide.license.ui.LicenseEntryUI;
import com.intellij.licensecommon.license.LicenseData;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BaseLicenseDataEdit<T extends LicenseSource>
implements LicenseDataEditControl {
    @NotNull
    protected final T licenseSource;
    @NotNull
    protected final LicenseEntryUI ui;

    protected BaseLicenseDataEdit(@NotNull T licenseSource, LicenseEntryUI ui) {
        if (licenseSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "licenseSource", "com/intellij/ide/license/ui/BaseLicenseDataEdit", "<init>"));
        }
        this.licenseSource = licenseSource;
        this.ui = ui;
    }

    @Override
    public boolean isSelected() {
        return this.getTypeSelector().isSelected();
    }

    @Override
    public void setSelected(boolean b2) {
        this.getTypeSelector().setSelected(b2);
    }

    public void init() {
        this.getTypeSelector().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (BaseLicenseDataEdit.this.getTypeSelector().isSelected()) {
                    BaseLicenseDataEdit.this.enableControls();
                } else {
                    BaseLicenseDataEdit.this.disableControls();
                }
            }
        });
        this.getTypeSelector().setSelected(false);
    }

    protected void disableControls() {
    }

    protected void enableControls() {
    }

    @Nullable
    protected LicenseData restoreLicenseData() {
        if (this.licenseSource.getLicense() == null) {
            this.licenseSource.restore();
        }
        return this.licenseSource.getLicense();
    }
}

