/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.license.LicenseCreationException;
import com.intellij.ide.license.impl.BuiltInEvaluationSource;
import com.intellij.ide.license.ui.BaseLicenseDataEdit;
import com.intellij.ide.license.ui.LicenseEntryUI;
import com.intellij.licensecommon.license.LicenseData;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuiltInEvalEditPanel
extends BaseLicenseDataEdit<BuiltInEvaluationSource> {
    private JLabel evalStatus;
    private JRadioButton dataType;
    private JPanel mainPanel;
    private boolean selectable;

    public BuiltInEvalEditPanel(@NotNull BuiltInEvaluationSource licenseSource, LicenseEntryUI ui) {
        if (licenseSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "licenseSource", "com/intellij/ide/license/ui/BuiltInEvalEditPanel", "<init>"));
        }
        super(licenseSource, ui);
        this.$$$setupUI$$$();
    }

    @Override
    public void init() {
        super.init();
        this.restoreLicenseData();
        this.dataType.setText(IdeBundle.message((String)"radio.evaluate", (Object[])new Object[]{((BuiltInEvaluationSource)this.licenseSource).getEvalPeriod()}));
        this.updateStatus();
    }

    private void updateStatus() {
        long days;
        LicenseData data = this.restoreLicenseData();
        long period = ((BuiltInEvaluationSource)this.licenseSource).getEvalPeriod();
        long l2 = days = data != null ? (long)BuiltInEvaluationSource.remainsDays(data.getExpirationDate(), new Date()) : period;
        if (days > period) {
            days = period;
        }
        this.evalStatus.setText(days > 1L ? IdeBundle.message((String)"license.panel.buildit.evaluation.expires.in.many", (Object[])new Object[]{days}) : IdeBundle.message((String)"license.panel.buildit.evaluation.expires.in.one", (Object[])new Object[0]));
        this.dataType.setVisible(days > 0L);
        this.evalStatus.setVisible(days > 0L);
        this.dataType.setEnabled(days > 0L);
        this.selectable = days > 0L;
    }

    @Override
    public JRadioButton getTypeSelector() {
        return this.dataType;
    }

    @Override
    public JPanel getPanel() {
        return this.mainPanel;
    }

    @Override
    protected void enableControls() {
        this.ui.setOKEnabled(true);
    }

    @Override
    @Nullable
    public BuiltInEvaluationSource getLicenseSourceToProceed() {
        LicenseData license = ((BuiltInEvaluationSource)this.licenseSource).getLicense();
        if (license == null) {
            try {
                ((BuiltInEvaluationSource)this.licenseSource).create();
            }
            catch (LicenseCreationException e2) {
                return null;
            }
            license = ((BuiltInEvaluationSource)this.licenseSource).getLicense();
            if (license != null) {
                license.setFromUser(true);
                license.setAccepted(false);
                return (BuiltInEvaluationSource)this.licenseSource;
            }
            return null;
        }
        return (BuiltInEvaluationSource)this.licenseSource;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JRadioButton jRadioButton;
        JPanel jPanel;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(10, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel2).setBackground(new Color(-986896));
        this.mainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(10, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.dataType = jRadioButton = new JRadioButton();
        jRadioButton.setText("RadioButton");
        jPanel.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.evalStatus = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }
}

