/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.ui;

import com.intellij.ide.BrowserUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.net.URL;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HtmlHelp {
    public static String makeUrl(String url) {
        return HtmlHelp.makeUrl(url, url);
    }

    public static String makeUrl(String url, String text2) {
        String style = "color: " + HtmlHelp.makeRgb(JBColor.blue.darker()) + "; text-decoration: none;";
        return "<a style='" + style + "' href='" + url + "'>" + text2 + "</a>";
    }

    private static String makeRgb(Color color) {
        return "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
    }

    public static JTextPane makeHtmlPane(String htmlText) {
        JTextPane textPane = new JTextPane();
        textPane.setContentType("text/html");
        textPane.setEditable(false);
        textPane.setBackground(null);
        String text2 = "<div style='" + HtmlHelp.makeFontRule() + "'>" + htmlText + "</div>";
        textPane.setText(text2);
        textPane.addHyperlinkListener(new MyHyperlinkListener(textPane));
        return textPane;
    }

    private static String makeFontRule() {
        Font font = UIUtil.getOptionPaneMessageFont();
        if (font == null && (font = UIUtil.getLabelFont()) == null) {
            font = new Font("Arial", 0, 10);
        }
        StringBuffer rule = new StringBuffer("font-family: ");
        rule.append(font.getFamily());
        rule.append("; font-size: ");
        rule.append(font.getSize());
        rule.append("pt");
        if (font.isBold()) {
            rule.append("; font-weight: 700");
        }
        if (font.isItalic()) {
            rule.append("; font-style: italic");
        }
        rule.append(";");
        return rule.toString();
    }

    private static class MyHyperlinkListener
    implements HyperlinkListener {
        private final JTextPane myTextPane;

        public MyHyperlinkListener(JTextPane textPane) {
            this.myTextPane = textPane;
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e2) {
            HyperlinkEvent.EventType type = e2.getEventType();
            if (type == HyperlinkEvent.EventType.ACTIVATED) {
                URL url = e2.getURL();
                BrowserUtil.browse((URL)url);
            } else if (type == HyperlinkEvent.EventType.ENTERED) {
                this.myTextPane.setCursor(Cursor.getPredefinedCursor(12));
            } else if (type == HyperlinkEvent.EventType.EXITED) {
                this.myTextPane.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }
}

