/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.ui;

import com.intellij.CommonBundle;
import com.intellij.ide.license.LicenseEntry;
import com.intellij.ide.license.LicenseSource;
import com.intellij.ide.license.ui.LicenseEditor;
import com.intellij.ide.license.ui.LicenseEntryUI;
import com.intellij.ide.license.ui.LicenseMessagesImpl;
import com.intellij.ide.license.ui.LicensePanel;
import com.intellij.ide.license.ui.LicenseUrls;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.ui.UIUtil;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LicenseDataEntryDialog
extends DialogWrapper
implements LicenseEntryUI {
    private final LicenseEditor myLicensePanel;
    private final LicenseEntry myLicenseEntry;

    public LicenseDataEntryDialog(LicenseEntry licenseEntry, LicenseUrls licenseUrls, int licenseKeyLines) {
        super(true);
        this.setTitle(ApplicationNamesInfo.getInstance().getFullProductName() + " License Activation");
        this.myLicenseEntry = licenseEntry;
        this.setOKActionEnabled(false);
        this.setCancelButtonText(licenseEntry.cancelMeansShutdown() ? "Exit" : CommonBundle.getCancelButtonText());
        this.myLicensePanel = new LicensePanel(licenseEntry, licenseUrls, licenseKeyLines, this);
        this.myLicensePanel.createUI();
        this.init();
        Container contentPane = this.getContentPane();
        contentPane.setMinimumSize(contentPane.getPreferredSize());
        this.getWindow().addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e2) {
                LicenseDataEntryDialog.this.myLicensePanel.doSmartDiscover();
            }
        });
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        for (LicenseSource source : this.myLicenseEntry.getAvailableLicenseSources()) {
            if (!source.hasCachedData()) continue;
            Action[] actionArray = new Action[]{new RemoveLicenseAction()};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/ui/LicenseDataEntryDialog", "createLeftSideActions"));
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/ui/LicenseDataEntryDialog", "createLeftSideActions"));
        }
        return actionArray;
    }

    public void setOKActionEnabled(boolean isEnabled) {
        boolean oldState = this.myOKAction.isEnabled();
        super.setOKActionEnabled(isEnabled);
        if (!oldState && isEnabled) {
            SwingUtilities.invokeLater(() -> {
                JButton cancelButton = this.getButton(this.myCancelAction);
                JButton okButton = this.getButton(this.myOKAction);
                if (cancelButton != null && okButton != null && cancelButton.hasFocus()) {
                    okButton.requestFocus();
                }
            });
        }
    }

    protected void doOKAction() {
        this.myLicensePanel.proceedSelectedLicenseSource();
    }

    public void doCancelAction() {
        super.doCancelAction();
        this.myLicenseEntry.cancel();
    }

    protected JComponent createCenterPanel() {
        return this.myLicensePanel.getPanel();
    }

    @Nullable
    protected JComponent createSouthPanel() {
        JComponent southPanel = super.createSouthPanel();
        if (southPanel != null) {
            southPanel.setBorder(ourDefaultBorder);
        }
        return southPanel;
    }

    @Nullable
    protected Border createContentPaneBorder() {
        return null;
    }

    protected void dispose() {
        super.dispose();
        LicenseMessagesImpl.ourReopenLock.set(false);
    }

    @Override
    public void showUI() {
        this.show();
    }

    @Override
    public void setProceedButtonText(@NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ide/license/ui/LicenseDataEntryDialog", "setProceedButtonText"));
        }
        super.setOKButtonText(text2);
    }

    @Override
    public void setOKEnabled(boolean enabled) {
        this.setOKActionEnabled(enabled);
    }

    @Override
    public void proceed(LicenseSource selected) {
        if (selected != null) {
            UIUtil.invokeLaterIfNeeded(() -> {
                this.processDoNotAskOnOk(0);
                this.close(0);
                this.myLicenseEntry.proceed(selected);
            });
        }
    }

    private class RemoveLicenseAction
    extends DialogWrapper.DialogWrapperAction {
        public RemoveLicenseAction() {
            super((DialogWrapper)LicenseDataEntryDialog.this, "Remove License");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doAction(ActionEvent e2) {
            Object[] options = new Object[]{UIManager.getString("OptionPane.yesButtonText"), UIManager.getString("OptionPane.noButtonText")};
            int answer = JOptionPane.showOptionDialog(LicenseDataEntryDialog.this.getContentPane(), "Are you sure you'd like to remove your license from this computer?\nAfter removing, you will be asked for a license to continue using " + ApplicationNamesInfo.getInstance().getFullProductName() + ".", "Confirmation", 0, 3, null, options, options[1]);
            if (0 == answer) {
                try {
                    LicenseDataEntryDialog.this.myLicenseEntry.forgetLicense();
                }
                finally {
                    LicenseDataEntryDialog.super.doCancelAction();
                }
            }
        }
    }
}

