/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.ui;

import com.intellij.CommonBundle;
import com.intellij.ide.license.LicenseEntry;
import com.intellij.ide.license.LicenseSource;
import com.intellij.ide.license.ui.LicenseEditor;
import com.intellij.ide.license.ui.LicenseEntryUI;
import com.intellij.ide.license.ui.LicenseMessagesImpl;
import com.intellij.ide.license.ui.LicensePanel;
import com.intellij.ide.license.ui.LicenseUrls;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.Gray;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

class LicenseDataEntryFrame
extends JFrame
implements LicenseEntryUI {
    private final LicenseEditor myLicensePanel;
    private final LicenseEntry myLicenseEntry;
    @NotNull
    private final JButton myOkButton;
    @NotNull
    private final JButton myCancelButton;

    LicenseDataEntryFrame(LicenseEntry licenseEntry, LicenseUrls licenseUrls, int licenseKeyLines) {
        super(ApplicationNamesInfo.getInstance().getFullProductName() + " License Activation");
        AppUIUtil.updateWindowIcon(this);
        this.myOkButton = new JButton(CommonBundle.getOkButtonText());
        this.myCancelButton = new JButton(licenseEntry.cancelMeansShutdown() ? "Exit" : CommonBundle.getCancelButtonText());
        this.myLicensePanel = new LicensePanel(licenseEntry, licenseUrls, licenseKeyLines, this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                LicenseDataEntryFrame.this.doCancelAction();
            }

            @Override
            public void windowActivated(WindowEvent e2) {
                LicenseDataEntryFrame.this.myLicensePanel.doSmartDiscover();
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel licensePanel = this.myLicensePanel.getPanel();
        contentPane.add((Component)licensePanel, "Center");
        this.getRootPane().setDefaultButton(this.myOkButton);
        this.myOkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                LicenseDataEntryFrame.this.myLicensePanel.proceedSelectedLicenseSource();
            }
        });
        this.myCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                LicenseDataEntryFrame.this.doCancelAction();
            }
        });
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                LicenseDataEntryFrame.this.doCancelAction();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        JPanel pnlButtonsHolder = new JPanel(new GridLayout(1, 2, SystemInfo.isMacOSLeopard ? 0 : 5, 0));
        if (SystemInfo.isMac) {
            pnlButtonsHolder.add(this.myCancelButton);
            pnlButtonsHolder.add(this.myOkButton);
        } else {
            pnlButtonsHolder.add(this.myOkButton);
            pnlButtonsHolder.add(this.myCancelButton);
        }
        this.myLicensePanel.createUI();
        this.myLicenseEntry = licenseEntry;
        JPanel pnlButtons = new JPanel(new GridBagLayout());
        pnlButtons.add((Component)pnlButtonsHolder, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 5, 8), 0, 0));
        contentPane.add((Component)pnlButtons, "South");
        MnemonicHelper.init((Component)contentPane);
    }

    @Override
    public void setProceedButtonText(@NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ide/license/ui/LicenseDataEntryFrame", "setProceedButtonText"));
        }
        SwingUtilities.invokeLater(() -> {
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ide/license/ui/LicenseDataEntryFrame", "lambda$setProceedButtonText$0"));
            }
            this.myOkButton.setText(text2);
        });
    }

    @Override
    public void setOKEnabled(boolean enabled) {
        boolean oldState = this.myOkButton.isEnabled();
        this.myOkButton.setEnabled(enabled);
        if (SystemInfo.isMac) {
            this.myOkButton.setForeground((Color)(enabled ? Gray._236 : UIManager.getColor("Button.foreground")));
        }
        if (!oldState && enabled) {
            SwingUtilities.invokeLater(() -> {
                if (this.myCancelButton.hasFocus()) {
                    this.myOkButton.requestFocus();
                }
            });
        }
    }

    @Override
    public void proceed(LicenseSource selected) {
        if (selected != null) {
            UIUtil.invokeLaterIfNeeded(() -> {
                this.dispose();
                this.myLicenseEntry.proceed(selected);
            });
        }
    }

    private void doCancelAction() {
        this.dispose();
        this.myLicenseEntry.cancel();
    }

    @Override
    public void showUI() {
        this.pack();
        this.setLocationRelativeTo(null);
        this.setMinimumSize(this.getPreferredSize());
        this.setVisible(true);
    }

    @Override
    public void dispose() {
        super.dispose();
        LicenseMessagesImpl.ourReopenLock.set(false);
    }
}

