/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.ui;

import com.intellij.ide.BrowserUtil;
import com.intellij.licensecommon.license.LicenseData;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.ui.ClickListener;
import com.intellij.ui.JBColor;
import com.intellij.util.concurrency.EdtExecutorService;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class LicenseEntryUtil {
    protected static final String EMPTY_LABEL = "  ";

    public static void setSingleLine(JTextArea field) {
        ((AbstractDocument)field.getDocument()).setDocumentFilter(new SingleLineDocumentFilter());
    }

    public static void fixFocusTraversal(JTextArea field) {
        HashSet<KeyStroke> strokes = new HashSet<KeyStroke>(Arrays.asList(KeyStroke.getKeyStroke("pressed TAB")));
        field.setFocusTraversalKeys(0, strokes);
        strokes = new HashSet<KeyStroke>(Arrays.asList(KeyStroke.getKeyStroke("shift pressed TAB")));
        field.setFocusTraversalKeys(1, strokes);
    }

    protected static void installCutCopyPasteKeyStrokes(JTextComponent textField) {
        InputMap inputMap = textField.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(155, 130), "copy-to-clipboard");
        inputMap.put(KeyStroke.getKeyStroke(155, 65), "paste-from-clipboard");
        inputMap.put(KeyStroke.getKeyStroke(127, 65), "cut-to-clipboard");
    }

    protected static void makeLinkLabel(JLabel label, String displayUrl, final String url) {
        label.setText(displayUrl);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e2, int clickCount) {
                if (e2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/license/ui/LicenseEntryUtil$1", "onClick"));
                }
                try {
                    BrowserUtil.browse((String)url);
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    // empty catch block
                }
                return true;
            }
        }.installOn((Component)label);
        label.setForeground(JBColor.blue.darker());
        label.setCursor(Cursor.getPredefinedCursor(12));
    }

    public static void showLicenseProceedNotificationLater(LicenseData licenseData) {
        StringBuilder message2 = new StringBuilder();
        message2.append("Your copy is licensed to ").append(licenseData.getUserName());
        String restrictions = licenseData.getRestrictionsText();
        if (restrictions != null && !restrictions.isEmpty()) {
            message2.append(".").append("<br>").append(restrictions);
            if (!restrictions.endsWith(".")) {
                message2.append(".");
            }
        }
        LicenseEntryUtil.showLicenseNotificationLater("Registration", message2.toString(), NotificationType.INFORMATION);
    }

    public static void showLicenseNotificationLater(String title, String text2, NotificationType notificationType) {
        LicenseEntryUtil.invokeOnEdtWhenApplicationLoaded(() -> {
            final String groupID = "LIGHTWEIGHT_LICENSE_NOTIFICATION";
            NotificationsConfiguration.getNotificationsConfiguration().register("LIGHTWEIGHT_LICENSE_NOTIFICATION", NotificationDisplayType.STICKY_BALLOON);
            Notifications.Bus.notify((Notification)new Notification("LIGHTWEIGHT_LICENSE_NOTIFICATION", title, text2, notificationType){

                public void hideBalloon() {
                    try {
                        super.hideBalloon();
                    }
                    catch (Throwable throwable) {
                        NotificationsConfigurationImpl.remove(groupID);
                        throw throwable;
                    }
                    NotificationsConfigurationImpl.remove(groupID);
                }
            });
        });
    }

    public static void invokeOnEdtWhenApplicationLoaded(final Runnable action2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Application app = ApplicationManager.getApplication();
                if (app == null || app instanceof ApplicationEx && !((ApplicationEx)app).isLoaded()) {
                    EdtExecutorService.getScheduledExecutorInstance().schedule(this, 3000L, TimeUnit.MILLISECONDS);
                } else if (!app.isDisposeInProgress() && !app.isDisposed()) {
                    action2.run();
                }
            }
        });
    }

    private static class SingleLineDocumentFilter
    extends DocumentFilter {
        private SingleLineDocumentFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb2, int offset, String string2, AttributeSet attr) throws BadLocationException {
            super.insertString(fb2, offset, SingleLineDocumentFilter.removeNewlines(string2), attr);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb2, int offset, int length, String text2, AttributeSet attrs) throws BadLocationException {
            super.replace(fb2, offset, length, SingleLineDocumentFilter.removeNewlines(text2), attrs);
        }

        private static String removeNewlines(String string2) {
            return string2 == null ? null : string2.replace("\r", "").replace("\n", "");
        }
    }
}

