/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.ui;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.license.LicenseEntry;
import com.intellij.ide.license.LicenseMessages;
import com.intellij.ide.license.impl.CertKey;
import com.intellij.ide.license.impl.CertKeyLicense;
import com.intellij.ide.license.impl.EvaluationLicenseData;
import com.intellij.ide.license.impl.TargetSaveException;
import com.intellij.ide.license.ui.HtmlHelp;
import com.intellij.ide.license.ui.LicenseDataEntryDialog;
import com.intellij.ide.license.ui.LicenseDataEntryFrame;
import com.intellij.ide.license.ui.LicenseEntryUI;
import com.intellij.ide.license.ui.LicenseUrls;
import com.intellij.licensecommon.license.LicenseData;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class LicenseMessagesImpl
implements LicenseMessages {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.license.ui.LicenseMessagesImpl");
    protected boolean myAsDialog;
    protected LicenseUrls myLicenseUrls;
    private final int myDefaultEvaluationPeriod;
    private int myLicenseEntryLines = 1;
    static final AtomicBoolean ourReopenLock = new AtomicBoolean(false);

    public LicenseMessagesImpl(LicenseUrls urls, int defaultEvaluationPeriod) {
        this.myLicenseUrls = urls;
        this.myDefaultEvaluationPeriod = defaultEvaluationPeriod;
    }

    public LicenseMessagesImpl withLicenseEntryLines(int lines) {
        this.myLicenseEntryLines = lines;
        return this;
    }

    protected static String getProductName() {
        ApplicationInfoEx info = ApplicationInfoImpl.getShadowInstance();
        return info.getVersionName();
    }

    @Override
    public boolean doesUserAcceptLicense(LicenseData license) {
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        if (!(license instanceof EvaluationLicenseData)) {
            return true;
        }
        String appName = appInfo.getFullApplicationName();
        String evalLicenseUrl = appInfo.getEvalLicenseUrl();
        Ref agreed = new Ref((Object)false);
        Runnable showRunner = () -> agreed.set((Object)LicenseMessagesImpl.acceptEvalLicense(appName, evalLicenseUrl));
        if (EventQueue.isDispatchThread()) {
            showRunner.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(showRunner);
            }
            catch (Exception e2) {
                LOG.error((Throwable)e2);
                return false;
            }
        }
        return (Boolean)agreed.get();
    }

    private static boolean acceptEvalLicense(String appName, final String evalLicenseUrl) {
        JPanel content2 = new JPanel(new BorderLayout());
        content2.add((Component)new JLabel("To start your evaluation you must accept license agreement located at"), "North");
        LinkLabel<String> urlLabel = new LinkLabel<String>(evalLicenseUrl, null){

            public void doClick() {
                BrowserUtil.browse((String)evalLicenseUrl, null);
            }
        };
        content2.add((Component)urlLabel, "Center");
        String title = "License Agreement for " + appName;
        String cancelOption = "Cancel";
        String proceedOption = "Accept";
        int rc = JOptionPane.showOptionDialog(JOptionPane.getRootFrame(), content2, title, -1, 1, null, new Object[]{"Accept", "Cancel"}, "Accept");
        return rc == 0;
    }

    public int showUpgradeOptionMessage(final LicenseEntry licenseEntry, final @NotNull String title, final @NotNull JTextPane content2) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/ide/license/ui/LicenseMessagesImpl", "showUpgradeOptionMessage"));
        }
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ide/license/ui/LicenseMessagesImpl", "showUpgradeOptionMessage"));
        }
        final Ref rc = new Ref();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                rc.set((Object)JOptionPane.showOptionDialog(JOptionPane.getRootFrame(), content2, title, -1, 0, null, new Object[]{"Enter Key or Evaluate", "Upgrade Online Now", licenseEntry.cancelMeansShutdown() ? "Shutdown " + ApplicationNamesInfo.getInstance().getFullProductName() : "Close"}, null));
                if ((Integer)rc.get() == 1) {
                    BrowserUtil.browse((String)LicenseMessagesImpl.this.myLicenseUrls.getUpgradeUrl());
                }
                if ((Integer)rc.get() > 0) {
                    licenseEntry.cancel();
                }
            }
        });
        return (Integer)rc.get();
    }

    @Override
    public void showNeedUpgradeMessage(LicenseEntry licenseEntry) {
        this.showUpgradeOptionMessage(licenseEntry, IdeBundle.message((String)"title.upgrade.needed", (Object[])new Object[0]), HtmlHelp.makeHtmlPane(IdeBundle.message((String)"message.upgrade.from.previous.required", (Object[])new Object[]{LicenseMessagesImpl.getProductName(), HtmlHelp.makeUrl(this.myLicenseUrls.getUpgradeUrl())})));
    }

    @Override
    public boolean askEnterKeyBecauseLicenseExpired(final boolean isEvaluation) {
        final Ref rc = new Ref();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                String notificationText = isEvaluation ? IdeBundle.message((String)"message.evaluation.has.expired", (Object[])new Object[]{LicenseMessagesImpl.getProductName(), LicenseMessagesImpl.this.evalText()}) : IdeBundle.message((String)"message.license.has.expired", (Object[])new Object[]{LicenseMessagesImpl.getProductName()});
                rc.set((Object)JOptionPane.showOptionDialog(JOptionPane.getRootFrame(), HtmlHelp.makeHtmlPane(notificationText), IdeBundle.message((String)(isEvaluation ? "title.evaluation.license.expired" : "title.license.expired"), (Object[])new Object[0]), -1, 0, null, new Object[]{"Enter Key", "Upgrade Online Now", "OK"}, "Enter Key"));
                if ((Integer)rc.get() == 1) {
                    BrowserUtil.browse((String)LicenseMessagesImpl.this.myLicenseUrls.getUpgradeUrl());
                }
            }
        });
        return (Integer)rc.get() == 0;
    }

    private String evalText() {
        return IdeBundle.message((String)"message.purchase.or.upgrade", (Object[])new Object[]{HtmlHelp.makeUrl(this.myLicenseUrls.getPurchaseUrl()), HtmlHelp.makeUrl(this.myLicenseUrls.getUpgradeUrl())});
    }

    @Override
    public void showLicenseCorruptMessage() {
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), IdeBundle.message((String)"message.license.is.corrupt", (Object[])new Object[0]), IdeBundle.message((String)"title.license.corrupt", (Object[])new Object[0]), 0);
            }
        });
    }

    @Override
    public void showLicenseInvalidMessage() {
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), IdeBundle.message((String)"message.invalid.license.data", (Object[])new Object[0]), IdeBundle.message((String)"title.invalid.license.data", (Object[])new Object[0]), 0);
            }
        });
    }

    @Override
    public boolean showWillExpireWarning(final long daysBeforeExpiration, final boolean evaluation) {
        final Ref rc = new Ref();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                String days = IdeBundle.message((String)"message.evaluation.N.days", (Object[])new Object[]{daysBeforeExpiration});
                if (daysBeforeExpiration == 1L) {
                    days = IdeBundle.message((String)"message.evaluation.one.day", (Object[])new Object[0]);
                } else if (daysBeforeExpiration == 0L) {
                    days = IdeBundle.message((String)"message.evaluation.less.than.one.day", (Object[])new Object[0]);
                }
                String title = evaluation ? IdeBundle.message((String)"title.product.evaluation", (Object[])new Object[]{LicenseMessagesImpl.getProductName()}) : IdeBundle.message((String)"title.license.will.expire", (Object[])new Object[]{LicenseMessagesImpl.getProductName()});
                String content2 = evaluation ? HtmlHelp.makeHtmlPane(IdeBundle.message((String)"message.evaluation.will.expire", (Object[])new Object[]{LicenseMessagesImpl.getProductName(), days, LicenseMessagesImpl.this.evalText()})) : IdeBundle.message((String)"message.license.will.expire", (Object[])new Object[]{LicenseMessagesImpl.getProductName(), days});
                rc.set((Object)JOptionPane.showOptionDialog(JOptionPane.getRootFrame(), content2, title, -1, 2, null, new Object[]{"Enter License", "Upgrade Online Now", "Continue Evaluation"}, null));
            }
        });
        if ((Integer)rc.get() == 1) {
            BrowserUtil.browse((String)this.myLicenseUrls.getUpgradeUrl());
        }
        return (Integer)rc.get() == 0;
    }

    @Override
    public void showSaveLicenseWarning(final TargetSaveException exception) {
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                Throwable cause = exception.getCause();
                String message2 = cause == null ? exception.getMessage() : cause.getMessage();
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), IdeBundle.message((String)"error.saving.license.data", (Object[])new Object[]{message2}), IdeBundle.message((String)"title.unable.to.save.data", (Object[])new Object[0]), 0);
            }
        });
    }

    @Override
    public void setShowLicenseEntryAsDialog(boolean asDialog) {
        this.myAsDialog = asDialog;
    }

    @Override
    public List<String> getUsageRestrictionsMessages(LicenseData license) {
        ArrayList<String> result2 = new ArrayList<String>();
        if (license instanceof CertKeyLicense) {
            String restrictionsText;
            CertKeyLicense certKeyLicense = (CertKeyLicense)((Object)license);
            CertKey certKey = certKeyLicense.getCertKey();
            Date firstExpiredDate = certKey.getFirstExpiredDate(certKeyLicense.getProductCode());
            Date expirationDate = certKey.getExpirationDate(certKeyLicense.getProductCode());
            if (certKey.isPerpetualForProduct(certKeyLicense.getProductCode(), certKeyLicense.getProductBuildDate())) {
                result2.add("You have a perpetual fallback license for this version");
            }
            if (firstExpiredDate != null && expirationDate != null) {
                result2.add("Subscription " + (new Date().before(firstExpiredDate) ? "is active until " : "expired on ") + DateFormatUtil.formatAboutDialogDate((Date)expirationDate));
            }
            if (!StringUtil.isEmpty((String)(restrictionsText = license.getRestrictionsText()))) {
                if (!restrictionsText.endsWith(".")) {
                    restrictionsText = restrictionsText + ".";
                }
                result2.add(restrictionsText);
            }
            return result2;
        }
        StringBuilder builder = new StringBuilder();
        Date expirationDate = license.getExpirationDate();
        if (expirationDate != null) {
            String expirationText = IdeBundle.message((String)"message.expiration.date", (Object[])new Object[]{LicenseMessagesImpl.dateString(expirationDate)});
            if (license.isYearAcademic()) {
                builder.append(IdeBundle.message((String)"message.educational.license", (Object[])new Object[]{expirationText}));
            } else if (license.isOpenSource()) {
                builder.append(IdeBundle.message((String)"message.open.source.project.license", (Object[])new Object[]{expirationText}));
            } else {
                builder.append(expirationText);
            }
        } else if (license.isNonCommercial()) {
            builder.append(IdeBundle.message((String)"message.non.commercial.use.only", (Object[])new Object[0]));
        } else if (license.isPersonal()) {
            builder.append(IdeBundle.message((String)"message.personal.license", (Object[])new Object[0]));
        }
        String restrictionsText = license.getRestrictionsText();
        if (restrictionsText != null && restrictionsText.length() > 0) {
            boolean firstMessagePartExists;
            boolean bl = firstMessagePartExists = builder.length() > 0;
            if (firstMessagePartExists) {
                builder.append(". ");
            }
            builder.append(restrictionsText);
            if (firstMessagePartExists && !restrictionsText.endsWith(".")) {
                builder.append(".");
            }
        }
        return Collections.singletonList(builder.toString());
    }

    @Override
    public void noFreeLicensesOnServer(final String serverMessage) {
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), serverMessage, IdeBundle.message((String)"title.server.no.licenses", (Object[])new Object[0]), 0);
            }
        });
    }

    @Override
    public void unableToContactLicenseServer() {
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), IdeBundle.message((String)"message.server.not.available", (Object[])new Object[0]), IdeBundle.message((String)"title.server.not.available", (Object[])new Object[0]), 0);
            }
        });
    }

    @Override
    public void showServerProtocolHijacked(final String reason) {
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), IdeBundle.message((String)"message.server.protocol.hijacked", (Object[])new Object[]{reason}), IdeBundle.message((String)"title.server.protocol.hijacked", (Object[])new Object[0]), 0);
            }
        });
    }

    @Override
    public void showServerConnectionError() {
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), IdeBundle.message((String)"message.server.not.available", (Object[])new Object[0]), IdeBundle.message((String)"title.server.not.available", (Object[])new Object[0]), 0);
            }
        });
    }

    @Override
    public void showNoLicenseOnServer() {
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), IdeBundle.message((String)"message.server.no.licenses", (Object[])new Object[0]), IdeBundle.message((String)"title.server.no.licenses", (Object[])new Object[0]), 0);
            }
        });
    }

    @Override
    public boolean showLicenseExpired() {
        final Ref rc = new Ref();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                String title = IdeBundle.message((String)"title.license.expired", (Object[])new Object[]{LicenseMessagesImpl.getProductName()});
                String content2 = IdeBundle.message((String)"message.license.expired", (Object[])new Object[0]);
                rc.set((Object)JOptionPane.showOptionDialog(JOptionPane.getRootFrame(), content2, title, -1, 0, null, new Object[]{"Enter License", "Upgrade Online Now", "OK"}, null));
            }
        });
        if ((Integer)rc.get() == 1) {
            BrowserUtil.browse((String)this.myLicenseUrls.getPurchaseUrl());
        }
        return (Integer)rc.get() == 0;
    }

    @Override
    public void showLicenseExpiredBeforeShutdownNotification(boolean isEval) {
        String title = IdeBundle.message((String)(isEval ? "title.evaluation.license.expired" : "title.license.expired"), (Object[])new Object[0]);
        String content2 = IdeBundle.message((String)(isEval ? "message.evaluation.license.expired.shutdown" : "message.license.expired.shutdown"), (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()});
        int rc = JOptionPane.showOptionDialog(JOptionPane.getRootFrame(), content2, title, -1, 0, null, new Object[]{"Upgrade Online Now", "OK"}, null);
        if (rc == 0) {
            BrowserUtil.browse((String)this.myLicenseUrls.getPurchaseUrl());
        }
    }

    private static String dateString(Date date) {
        return DateFormat.getDateInstance(1, Locale.ENGLISH).format(date);
    }

    @Override
    public void showLicenseEntryScreen(LicenseEntry licenseEntry) {
        if (!ourReopenLock.compareAndSet(false, true)) {
            return;
        }
        UIUtil.invokeAndWaitIfNeeded(() -> {
            LicenseEntryUI ui = this.createUI(licenseEntry);
            if (LOG.isDebugEnabled()) {
                LOG.debug("entering license data...");
            }
            ui.showUI();
        });
    }

    protected LicenseEntryUI createUI(LicenseEntry licenseEntry) {
        boolean thereIsVisibleFrame = false;
        for (Frame frame : Frame.getFrames()) {
            if (!frame.isVisible()) continue;
            thereIsVisibleFrame = true;
        }
        if (thereIsVisibleFrame) {
            return new LicenseDataEntryDialog(licenseEntry, this.myLicenseUrls, this.getLicenseEntryLines());
        }
        return new LicenseDataEntryFrame(licenseEntry, this.myLicenseUrls, this.getLicenseEntryLines());
    }

    protected int getLicenseEntryLines() {
        return this.myLicenseEntryLines;
    }

    @Override
    public int getDefaultEvaluationPeriod() {
        return this.myDefaultEvaluationPeriod;
    }

    @Override
    public String getUpgradeUrl() {
        return this.myLicenseUrls.getUpgradeUrl();
    }

    @Override
    public String getRenewInformationUrl() {
        return this.myLicenseUrls.getRenewInformationUrl();
    }
}

