/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.ui;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.license.LicenseCreationException;
import com.intellij.ide.license.LicenseEntry;
import com.intellij.ide.license.LicenseSource;
import com.intellij.ide.license.impl.BuiltInEvaluationSource;
import com.intellij.ide.license.impl.CertKey;
import com.intellij.ide.license.impl.CertKeyLicense;
import com.intellij.ide.license.impl.DefaultLicenseServerUtil;
import com.intellij.ide.license.impl.FileLicenseSource;
import com.intellij.ide.license.impl.JBALicenseData;
import com.intellij.ide.license.impl.JetProfileSubscriptionLicenseData;
import com.intellij.ide.license.impl.JetprofileSource;
import com.intellij.ide.license.impl.LegacyKeyException;
import com.intellij.ide.license.impl.LicenseServerSource;
import com.intellij.ide.license.impl.LicensingProxyService;
import com.intellij.ide.license.impl.ServerLicenseData;
import com.intellij.ide.license.impl.UserEntrySource;
import com.intellij.ide.license.impl.ValidationFailedException;
import com.intellij.ide.license.ui.LicenseEditor;
import com.intellij.ide.license.ui.LicenseEntryUI;
import com.intellij.ide.license.ui.LicenseEntryUtil;
import com.intellij.ide.license.ui.LicenseUrls;
import com.intellij.licensecommon.license.LicenseData;
import com.intellij.licensecommon.license.MaintenanceDueAware;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DarculaColors;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.ls.responses.ExchangeKeyResponse;
import com.jetbrains.ls.responses.ResponseCode;
import com.jetbrains.ls.util.ClientUtil;
import com.jetbrains.ls.util.JBAClientUtil;
import com.jetbrains.ls.util.ServiceConfig;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SortingFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

class LicensePanel
extends JPanel
implements LicenseEditor,
ActionListener,
Disposable {
    private static final Logger LOG;
    private static final boolean allowReturnToEvaluation = false;
    private static final int GAP = 15;
    private static final String KEY_IS_INVALID = "Key is invalid.";
    public static final String KEY_EXCHANGE_URL = "https://www.jetbrains.com/shop/eform/keys-exchange";
    private static final Pattern EMAIL_PATTERN;
    private final Icon ERROR_ICON;
    private final Icon EMPTY_ERROR_ICON;
    private static final Pattern LICENSE_START_PATTERN1;
    private static final Pattern LICENSE_END_PATTERN1;
    private static final Pattern LICENSE_PATTERN2;
    private final Color myErrorColor;
    private final Color myOkColor;
    private final Color myLinkColor;
    private final Color myStatusBackground;
    private final Font myLabelFont;
    private final LoadingDecorator myDecorator;
    private final LicenseEntryUI myUI;
    private LicenseSource myActualLicenseSource;
    private boolean myIgnoreDocumentChanges;
    private final JLabel myMyKeyValidationLabel;
    private final JPanel myContent;
    private final JTextField myFirstNameField;
    private final JTextField myLastNameField;
    private final JTextField myEmailField;
    private static final State DEFAULT;
    private BuiltInEvaluationSource myEvalSource;
    private FileLicenseSource myKeySource;
    private JetprofileSource myAccountSource;
    private JBALicenseData myChosenAccountLicenseData;
    private LicenseServerSource myServerSource;
    @Nullable
    private LicenseData myActualLicenseData;
    @NotNull
    private State myState;
    @NotNull
    private State myLastInputState;
    private final JRadioButton myJetProfileButton;
    private final JRadioButton myKeyButton;
    private final JRadioButton myServerButton;
    private final JPanel myStatusPanel;
    private final JRadioButton myActivateButton;
    private final JRadioButton myEvaluateButton;
    private final JButton myBuyButton;
    private final JButton myGetNewLicenseButton;
    private final JPanel myRadioPanel;
    private final JPanel myFieldsPanel;
    private final JPanel myProfileChoosePanel;
    private final JTextField myAccountNameField;
    private final JPasswordField myAccountPasswordField;
    private final Link myForgotAccountPasswordLink;
    private final JTextArea myKeyArea;
    private final ErrorLabel myKeyErrorMessage;
    private final Link myProblemsEnteringKeyLink;
    private final JTextField myServerAddressField;
    private final JLabel myServerStatusLabel;
    private final JButton myDiscoverButton;
    private final Link myServerMoreInfoLink;
    private final JPanel myReturnToEvaluationPanel;
    private final JButton myReturnToEvaluationButton;
    private final JLabel myEvalLabel;
    private final JCheckBox myNewsCb;
    private final JCheckBox myTipsCb;
    private final JBTextField mySubscriptionEmailField;
    private final AtomicBoolean myServerDiscoverLock;
    private final AtomicBoolean myJetProfileLicenseLock;
    private final AtomicBoolean myServerLicenseLock;
    private final AtomicBoolean myEmailSubscriptionLock;
    private static final long SECOND = 1000L;
    private static final long DEFAULT_TIMEOUT = 30000L;
    private static final long SMART_DISCOVER_TIMEOUT = 5000L;
    private static final long UI_ASYNC_TASK_TIMEOUT;
    private final Border myFieldsPanelBottomBorder;
    @NotNull
    private LicenseEntry myLicenseEntry;
    private String myRecentProblemDescription;
    private LicenseUrls myLicenseUrls;
    private int myLicenseKeyLines;
    private volatile boolean myDisposed;
    private static boolean isRequiredJBA;
    private static boolean isOptionalJBA;

    LicensePanel(@NotNull LicenseEntry licenseEntry, LicenseUrls licenseUrls, int licenseKeyLines, LicenseEntryUI ui) {
        if (licenseEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "licenseEntry", "com/intellij/ide/license/ui/LicensePanel", "<init>"));
        }
        super(new GridLayout(1, 1));
        this.myErrorColor = new JBColor(new Color(12719904), new Color(12719904));
        this.myOkColor = new Color(4953673);
        this.myLinkColor = new JBColor(new Color(5807606), DarculaColors.BLUE);
        this.myStatusBackground = new JBColor(new Color(0xFCFCFC), new Color(0x333333));
        this.myLabelFont = UIUtil.getLabelFont();
        this.myIgnoreDocumentChanges = false;
        this.myMyKeyValidationLabel = new JLabel("", 4);
        this.myFirstNameField = new JTextField(20);
        this.myLastNameField = new JTextField(20);
        this.myEmailField = new JTextField(20);
        this.myChosenAccountLicenseData = null;
        this.myState = DEFAULT;
        this.myLastInputState = DEFAULT;
        this.myServerDiscoverLock = new AtomicBoolean(false);
        this.myJetProfileLicenseLock = new AtomicBoolean(false);
        this.myServerLicenseLock = new AtomicBoolean(false);
        this.myEmailSubscriptionLock = new AtomicBoolean(false);
        this.myFieldsPanelBottomBorder = new Border(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
                Graphics2D g2d = (Graphics2D)g2.create();
                try {
                    g2d.setColor(UIUtil.getLabelDisabledForeground());
                    g2d.drawLine(x2, y2 + height - 10, x2 + width - 1, y2 + height - 10);
                }
                finally {
                    g2d.dispose();
                }
            }

            @Override
            public Insets getBorderInsets(Component c2) {
                return JBUI.insetsBottom((int)20);
            }

            @Override
            public boolean isBorderOpaque() {
                return true;
            }
        };
        this.myDisposed = false;
        IconLoader.activate();
        this.ERROR_ICON = AllIcons.General.Error;
        this.EMPTY_ERROR_ICON = EmptyIcon.create((int)this.ERROR_ICON.getIconWidth());
        this.myUI = ui;
        this.myLicenseEntry = licenseEntry;
        this.myLicenseUrls = licenseUrls;
        this.myLicenseKeyLines = licenseKeyLines;
        DocumentAdapter listener2 = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e2) {
                if (LicensePanel.this.myIgnoreDocumentChanges) {
                    return;
                }
                LicensePanel.this.updateOKButton();
            }
        };
        this.myKeyArea = new HintTextArea(Math.max(1, this.myLicenseKeyLines), 31, "Paste or drop activation code here");
        this.myKeyArea.setTransferHandler(new MyTransferHandler());
        this.myKeyArea.setFont(new JTextPane().getFont());
        this.myKeyArea.setLineWrap(true);
        LicenseEntryUtil.fixFocusTraversal(this.myKeyArea);
        this.myKeyArea.getDocument().addDocumentListener((DocumentListener)listener2);
        this.myKeyErrorMessage = new ErrorLabel();
        this.myProblemsEnteringKeyLink = new Link("", "https://intellij-support.jetbrains.com/hc/en-us/articles/207241025");
        this.myServerAddressField = new JTextField(31);
        this.myServerAddressField.getDocument().addDocumentListener((DocumentListener)listener2);
        this.myServerStatusLabel = new JLabel("");
        this.myGetNewLicenseButton = this.createButton("Enter another license");
        this.myAccountNameField = new JTextField(18);
        this.myAccountNameField.getDocument().addDocumentListener((DocumentListener)listener2);
        this.myAccountPasswordField = new JPasswordField(18);
        this.myAccountPasswordField.getDocument().addDocumentListener((DocumentListener)listener2);
        LicensePanel.addPasteAndUndoActions(this.myAccountNameField);
        LicensePanel.addPasteAndUndoActions(this.myAccountPasswordField);
        LicensePanel.addPasteAndUndoActions(this.myKeyArea);
        LicensePanel.addPasteAndUndoActions(this.myServerAddressField);
        this.myForgotAccountPasswordLink = new Link("Forgot?", "https://account.jetbrains.com/secured/ForgotPasswordForm");
        this.myDiscoverButton = this.createButton("Discover server");
        this.myServerMoreInfoLink = new Link("More info...", this.myLicenseUrls.getLicenseServerInfoUrl());
        this.myEvalLabel = new JLabel("Evaluation is free for 30 days.");
        this.myTipsCb = new JCheckBox("Send me tips to learn " + ApplicationNamesInfo.getInstance().getFullProductName() + " faster");
        this.myNewsCb = new JCheckBox("Tell me about new product features as they come out");
        ActionListener checkBoxListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                LicensePanel.this.mySubscriptionEmailField.setEnabled(!LicensePanel.areTipsAvailable() || LicensePanel.this.myNewsCb.isSelected() || LicensePanel.this.myTipsCb.isSelected());
                LicensePanel.this.updateOKButton();
            }
        };
        this.myTipsCb.addActionListener(checkBoxListener);
        this.myNewsCb.addActionListener(checkBoxListener);
        this.mySubscriptionEmailField = new JBTextField();
        this.mySubscriptionEmailField.setEnabled(!LicensePanel.areTipsAvailable());
        this.mySubscriptionEmailField.getDocument().addDocumentListener((DocumentListener)listener2);
        this.myContent = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        this.myStatusPanel = new JPanel(new GridBagLayout());
        this.myContent.add((Component)this.myStatusPanel, gbc);
        this.myRadioPanel = new JPanel(new GridBagLayout());
        this.myContent.add((Component)this.myRadioPanel, gbc);
        this.myFieldsPanel = new JPanel(new CardLayout());
        this.myFieldsPanel.add(State.JETPROFILE_INPUT.name(), this.createProfileInputPanel());
        this.myProfileChoosePanel = new JPanel(new GridBagLayout());
        this.myFieldsPanel.add(State.JETPROFILE_CHOOSE.name(), this.myProfileChoosePanel);
        this.myFieldsPanel.add(State.KEY_INPUT.name(), this.createKeyInputPanel());
        this.myFieldsPanel.add(State.SERVER_INPUT.name(), this.createServerInputPanel());
        this.myFieldsPanel.add(State.EVALUATE.name(), this.createEvaluateInputPanel());
        gbc.weighty = 1.0;
        this.myContent.add((Component)this.myFieldsPanel, gbc);
        gbc.weighty = 0.0;
        this.myReturnToEvaluationPanel = new JPanel(new GridBagLayout());
        this.myContent.add((Component)this.myReturnToEvaluationPanel, gbc);
        this.myStatusPanel.setBorder((Border)JBUI.Borders.empty((int)15, (int)15, (int)15, (int)15));
        this.myRadioPanel.setBorder((Border)JBUI.Borders.empty((int)5, (int)15, (int)15, (int)15));
        this.myFieldsPanel.setBorder(new CompoundBorder(this.myFieldsPanelBottomBorder, (Border)JBUI.Borders.empty((int)0, (int)15, (int)5, (int)15)));
        this.myReturnToEvaluationPanel.setBorder(new CompoundBorder(this.myFieldsPanelBottomBorder, (Border)JBUI.Borders.empty((int)5, (int)15, (int)5, (int)15)));
        this.myDecorator = new LoadingDecorator((JComponent)this.myContent, (Disposable)this, 300);
        MouseAdapter mouseAdapter = new MouseAdapter(){};
        Component[] components = ((JLayeredPane)this.myDecorator.getComponent()).getComponentsInLayer(JLayeredPane.DRAG_LAYER);
        if (components.length > 0) {
            Component layer = components[0];
            layer.addMouseListener(mouseAdapter);
            layer.addMouseMotionListener(mouseAdapter);
            layer.addMouseWheelListener(mouseAdapter);
            layer.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e2) {
                    if (e2.getKeyCode() == 9) {
                        e2.consume();
                    }
                }
            });
        }
        this.add(this.myDecorator.getComponent());
        this.myStatusPanel.setOpaque(true);
        this.myStatusPanel.setBackground(this.myStatusBackground);
        this.myActivateButton = this.createRadioButton("Activate", null);
        this.myEvaluateButton = this.createRadioButton("Evaluate for free", State.EVALUATE);
        this.myActivateButton.setSelected(true);
        this.myActivateButton.setOpaque(false);
        this.myEvaluateButton.setOpaque(false);
        this.myActivateButton.setBorder((Border)JBUI.Borders.empty((int)0, (int)5, (int)0, (int)10));
        ButtonGroup topGroup = new ButtonGroup();
        topGroup.add(this.myActivateButton);
        topGroup.add(this.myEvaluateButton);
        this.myBuyButton = this.createButton("Buy " + ApplicationNamesInfo.getInstance().getFullProductName());
        this.myJetProfileButton = this.createRadioButton("JetBrains Account", State.JETPROFILE_INPUT);
        this.myKeyButton = this.createRadioButton("Activation code", State.KEY_INPUT);
        this.myServerButton = this.createRadioButton("License server", State.SERVER_INPUT);
        this.myReturnToEvaluationButton = this.createButton("Return to evaluation");
        this.updateState(this.guessState());
        this.doAsyncTask(new AtomicBoolean(false), () -> {
            try {
                return ServiceConfig.getResetPasswordUrl();
            }
            catch (IOException iOException) {
                return null;
            }
        }, resetPassUrl -> {
            if (resetPassUrl != null) {
                this.myForgotAccountPasswordLink.setUrl((String)resetPassUrl);
            }
        }, 5000L, false);
    }

    public void dispose() {
        this.myDisposed = true;
    }

    @Override
    public void proceedSelectedLicenseSource() {
        this.myUI.setProceedButtonText(CommonBundle.getOkButtonText());
        if (this.myState == State.JETPROFILE_INPUT) {
            String login = this.myAccountNameField.getText();
            if (StringUtil.isEmpty((String)login) || this.myAccountPasswordField.getPassword().length == 0) {
                return;
            }
            this.doAsyncTask(this.myJetProfileLicenseLock, () -> {
                this.myAccountSource.setLogin(login);
                this.myAccountSource.setPassword(new String(this.myAccountPasswordField.getPassword()));
                try {
                    this.myAccountSource.create();
                }
                catch (LicenseCreationException e2) {
                    this.showErrorMessage(e2.getMessage(), e2.getDetails(), e2.getCause() instanceof IOException && LicensingProxyService.isActive());
                }
                return this.myAccountSource.getLicense();
            }, data -> {
                if (data != null) {
                    if (this.myAccountSource.getAvailableLicenses().size() > 1) {
                        this.updateState(State.JETPROFILE_CHOOSE);
                    } else {
                        this.myUI.proceed(this.myAccountSource);
                    }
                } else {
                    this.myAccountSource.restore();
                }
            }, UI_ASYNC_TASK_TIMEOUT, true);
            return;
        }
        if (this.myState == State.JETPROFILE_CHOOSE) {
            if (this.myChosenAccountLicenseData == null) {
                return;
            }
            this.myAccountSource.switchToLicence(this.myChosenAccountLicenseData);
            this.myUI.proceed(this.myAccountSource);
            return;
        }
        if (this.myState == State.KEY_INPUT) {
            try {
                this.myKeyErrorMessage.setText(null);
                LicenseData licenseData = this.createKeyLicense(this.myKeyArea.getText());
                if (licenseData == null) {
                    return;
                }
                this.myKeySource.create(licenseData);
                this.myUI.proceed(this.myKeySource);
            }
            catch (LegacyKeyException e2) {
                LicenseData legacyLicense = e2.getLicenseData();
                this.myKeyErrorMessage.setText(e2.getMessage() + ". Press Convert button.");
                this.myUI.setProceedButtonText("Convert");
                if (!legacyLicense.isPersonal()) {
                    if (new ExchangeKeyDialog(this, false).showAndGet()) {
                        this.requestLegacyKeyConversion(legacyLicense, this.myFirstNameField.getText().trim(), this.myLastNameField.getText().trim(), this.myEmailField.getText().trim());
                    }
                    return;
                }
                this.requestLegacyKeyConversion(legacyLicense, "", "", "");
                return;
            }
            catch (ValidationFailedException e3) {
                this.myKeyErrorMessage.setText(e3.getMessage() != null ? e3.getMessage() : KEY_IS_INVALID);
            }
            return;
        }
        if (this.myState == State.SERVER_INPUT) {
            this.doAsyncTask(this.myServerLicenseLock, () -> {
                this.myServerSource.releaseLicense();
                this.myServerSource.setServerUrl(this.myServerAddressField.getText());
                try {
                    this.myServerSource.create();
                }
                catch (LicenseCreationException e2) {
                    this.showErrorMessage(e2.getMessage(), e2.getDetails(), false);
                }
                return this.myServerSource.getLicense();
            }, data -> {
                if (data != null) {
                    this.myUI.proceed(this.myServerSource);
                } else {
                    this.myServerSource.restore();
                }
            }, UI_ASYNC_TASK_TIMEOUT, true);
            return;
        }
        if (this.myState == State.EVALUATE) {
            try {
                this.myEvalSource.create();
                LicenseData license = this.myEvalSource.getLicense();
                if (license != null) {
                    license.setFromUser(true);
                    license.setAccepted(false);
                }
                String email = this.mySubscriptionEmailField.getText();
                String formData = this.getFormData();
                if (formData != null && LicensePanel.isValidEmail(email)) {
                    this.doSubscribeWithEmail(email, formData);
                }
                this.myUI.proceed(this.myEvalSource);
            }
            catch (LicenseCreationException e1) {
                this.showErrorMessage(e1.getMessage(), e1.getDetails(), false);
            }
        }
    }

    private static boolean isValidEmail(String s2) {
        return s2 != null && EMAIL_PATTERN.matcher(s2).matches();
    }

    private void doSubscribeWithEmail(@NotNull String email, @NotNull String formData) {
        if (email == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "email", "com/intellij/ide/license/ui/LicensePanel", "doSubscribeWithEmail"));
        }
        if (formData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formData", "com/intellij/ide/license/ui/LicensePanel", "doSubscribeWithEmail"));
        }
        this.doAsyncTask(this.myEmailSubscriptionLock, () -> {
            if (email == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "email", "com/intellij/ide/license/ui/LicensePanel", "lambda$doSubscribeWithEmail$6"));
            }
            if (formData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formData", "com/intellij/ide/license/ui/LicensePanel", "lambda$doSubscribeWithEmail$6"));
            }
            try {
                String[] mx = new String[]{"QVD", "114", "426", "munc", "hkinId"};
                final byte[] bytes = ("Email=" + URLEncoder.encode(email) + "&" + formData + "&" + mx[3] + mx[4] + "=" + mx[2] + "-" + mx[0] + "-" + mx[1] + "&_mkt_trk=&_mktoReferrer=" + URLEncoder.encode("https://www.jetbrains.com/")).getBytes("utf-8");
                return (Boolean)HttpRequests.request((String)"https://app-lon02.marketo.com/index.php/leadCapture/save").tuner(new HttpRequests.ConnectionTuner(){

                    public void tune(@NotNull URLConnection connection) throws IOException {
                        if (connection == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/ide/license/ui/LicensePanel$7", "tune"));
                        }
                        ((HttpURLConnection)connection).setRequestMethod("POST");
                        connection.setDoOutput(true);
                        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
                        connection.setRequestProperty("Origin", "https://www.jetbrains.com");
                        ((HttpURLConnection)connection).setFixedLengthStreamingMode(bytes.length);
                        OutputStream os = connection.getOutputStream();
                        os.write(bytes);
                        os.close();
                    }
                }).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<Boolean>(){

                    public Boolean process(@NotNull HttpRequests.Request request2) throws IOException {
                        if (request2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/ide/license/ui/LicensePanel$6", "process"));
                        }
                        try {
                            request2.getInputStream().close();
                            return Boolean.TRUE;
                        }
                        catch (IOException e2) {
                            LOG.info("Email subscription failed");
                            return Boolean.FALSE;
                        }
                    }
                });
            }
            catch (IOException e2) {
                return Boolean.FALSE;
            }
        }, null, UI_ASYNC_TASK_TIMEOUT, false);
    }

    @Nullable
    private String getFormData() {
        ApplicationInfoEx appInfo = (ApplicationInfoEx)LicensePanel.getAppInfo();
        String formId = appInfo.getSubscriptionFormId();
        if (formId == null) {
            return null;
        }
        StringBuilder form = new StringBuilder("formid=").append(formId).append("&formVid=").append(formId);
        String additionalFormData = appInfo.getSubscriptionAdditionalFormData();
        if (!StringUtil.isEmpty((String)additionalFormData)) {
            form.append('&').append(additionalFormData);
        }
        if (!appInfo.areSubscriptionTipsAvailable() || this.myNewsCb.isSelected()) {
            form.append('&').append(appInfo.getSubscriptionNewsKey()).append('=').append(appInfo.getSubscriptionNewsValue());
        }
        if (appInfo.areSubscriptionTipsAvailable() && this.myTipsCb.isSelected()) {
            form.append('&').append(appInfo.getSubscriptionTipsKey()).append("=yes");
        }
        return form.toString();
    }

    private static boolean areTipsAvailable() {
        return ((ApplicationInfoEx)LicensePanel.getAppInfo()).areSubscriptionTipsAvailable();
    }

    private void requestLegacyKeyConversion(LicenseData legacyLicense, String firstName, String lastName, String email) {
        LicensingProxyService.getInstance();
        this.doAsyncTask(new AtomicBoolean(false), () -> {
            String error = null;
            String newKey = null;
            Boolean suggestProxyConfig = Boolean.FALSE;
            try {
                ExchangeKeyResponse response = JBAClientUtil.exchangeKey(this.myKeySource.getFactory().getProductDescriptor().getProductCode(), legacyLicense.getKey(), firstName, lastName, email);
                if (response.getResponseCode() == ResponseCode.OK) {
                    newKey = response.getNewLicenseKey();
                } else {
                    error = response.getMessage();
                }
            }
            catch (Throwable e2) {
                LOG.info(e2.getClass().getName() + ": " + e2.getMessage());
                error = LicensePanel.buildConversionProblemMessage("Failed to convert legacy license key because of network problems");
                suggestProxyConfig = e2 instanceof IOException;
            }
            return Trinity.create((Object)newKey, (Object)error, (Object)suggestProxyConfig);
        }, trinity -> {
            String newKey;
            String string2 = newKey = trinity != null ? (String)trinity.first : null;
            if (!StringUtil.isEmptyOrSpaces((String)newKey)) {
                this.myKeyErrorMessage.setText("Legacy license key was converted");
                this.myKeyArea.setText(newKey);
            } else {
                boolean suggestProxyConfig = trinity != null ? (Boolean)trinity.third : false;
                String defaultErrorDescription = "Failed to convert legacy license key";
                String error = trinity != null ? (String)trinity.second : LicensePanel.buildConversionProblemMessage("Server connection timeout");
                this.myKeyErrorMessage.setText(StringUtil.isEmptyOrSpaces((String)error) ? "Failed to convert legacy license key" : error);
                if (suggestProxyConfig) {
                    this.showErrorMessage("Convert Legacy License", "Failed to convert legacy license key", true);
                }
            }
        }, UI_ASYNC_TASK_TIMEOUT, true);
    }

    private static String buildConversionProblemMessage(@NotNull String msg) {
        if (msg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/intellij/ide/license/ui/LicensePanel", "buildConversionProblemMessage"));
        }
        ApplicationInfo appInfo = LicensePanel.getAppInfo();
        StringBuilder builder = new StringBuilder();
        msg = msg.trim();
        builder.append(msg);
        if (!msg.endsWith(".")) {
            builder.append(".");
        }
        return builder.append(" Please visit <a href=\"").append(appInfo.getKeyConversionUrl()).append("\">").append(appInfo.getCompanyName()).append(" official site</a>.").toString();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            FocusTraversalPolicy policy = window.getFocusTraversalPolicy();
            final List<JComponent> order = Arrays.asList(this.myAccountNameField, this.myAccountPasswordField, this.myForgotAccountPasswordLink);
            if (policy instanceof SortingFocusTraversalPolicy) {
                try {
                    Method method2 = SortingFocusTraversalPolicy.class.getDeclaredMethod("getComparator", new Class[0]);
                    method2.setAccessible(true);
                    final Comparator comparator2 = (Comparator)method2.invoke((Object)policy, new Object[0]);
                    method2 = SortingFocusTraversalPolicy.class.getDeclaredMethod("setComparator", Comparator.class);
                    method2.setAccessible(true);
                    method2.invoke((Object)policy, new Comparator<Component>(){

                        @Override
                        public int compare(Component o1, Component o2) {
                            int index1 = order.indexOf(o1);
                            int index2 = order.indexOf(o2);
                            if (index1 == -1 || index2 == -1) {
                                return comparator2.compare(o1, o2);
                            }
                            return index1 - index2;
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.updateState(this.myState);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        Disposer.dispose((Disposable)this);
    }

    private void showErrorMessage(final @NotNull String message2, final @Nullable String details, final boolean suggestProxyConfig) {
        if (message2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/ide/license/ui/LicensePanel", "showErrorMessage"));
        }
        if (this.myDisposed) {
            return;
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                String detailsMessage;
                String string2 = detailsMessage = StringUtil.isEmpty((String)details) ? message2 : details;
                if (!suggestProxyConfig) {
                    LicensePanel.this.myRecentProblemDescription = detailsMessage;
                    LicensePanel.this.updateTopStatusPanel();
                    LicensePanel.this.myStatusPanel.revalidate();
                    LicensePanel.this.myStatusPanel.repaint();
                    return;
                }
                JComponent detailsComponent = this.createErrorMessageComponent(detailsMessage);
                LicensingProxyService proxyService = LicensingProxyService.getInstance();
                Pair<String, String> prevHostPort = proxyService.getProxyConfig();
                if (prevHostPort == null) {
                    prevHostPort = proxyService.getDiscoveredConfig();
                }
                JPanel panel2 = new JPanel(new GridBagLayout());
                panel2.add((Component)detailsComponent, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
                String text2 = prevHostPort == null ? "Your host may be behind a proxy.\n" + LicensePanel.getAppInfo().getVersionName() + " was not able to detect your proxy configuration.\nYou may want to specify HTTPS proxy parameters and try again." : LicensePanel.getAppInfo().getVersionName() + " was not able  to connect using specified proxy configuration.\nYou may want to correct HTTPS proxy parameters and try again.";
                MultiLineLabel proxyHeader = new MultiLineLabel(text2);
                panel2.add((Component)proxyHeader, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)5, (int)0, (int)10, (int)0), 0, 0));
                panel2.add((Component)new JLabel("Proxy host:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
                JTextField hostField = new JTextField();
                panel2.add((Component)hostField, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insetsLeft((int)5), 0, 0));
                panel2.add((Component)new JLabel("Proxy port:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 18, 2, (Insets)JBUI.insetsTop((int)5), 0, 0));
                JTextField portField = new JTextField();
                panel2.add((Component)portField, new GridBagConstraints(1, -1, 1, 1, 1.0, 1.0, 18, 2, (Insets)JBUI.insets((int)5, (int)5, (int)0, (int)0), 0, 0));
                if (prevHostPort != null) {
                    hostField.setText((String)prevHostPort.first);
                    portField.setText((String)prevHostPort.second);
                }
                JOptionPane.showMessageDialog(LicensePanel.this, panel2, StringUtil.isEmpty((String)details) ? "Error" : message2, 0);
                proxyService.setUserDefinedProxy(hostField.getText(), portField.getText());
            }

            @NotNull
            private JComponent createErrorMessageComponent(String detailsMessage) {
                if (detailsMessage.length() < 40) {
                    JLabel jLabel = new JLabel(detailsMessage);
                    if (jLabel == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/ui/LicensePanel$9", "createErrorMessageComponent"));
                    }
                    return jLabel;
                }
                JTextArea textArea = new JTextArea(detailsMessage, 3, 64);
                textArea.setFont(UIManager.getFont("Label.font"));
                textArea.setLineWrap(true);
                textArea.setWrapStyleWord(true);
                textArea.setOpaque(false);
                textArea.setEditable(false);
                textArea.setBorder((Border)JBUI.Borders.empty());
                final JScrollPane scrollPane = new JScrollPane(textArea, 20, 31);
                scrollPane.setOpaque(false);
                scrollPane.getViewport().setOpaque(false);
                scrollPane.setBorder(new LineBorder(JBColor.border(), 1){

                    @Override
                    public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
                        if (!scrollPane.getVerticalScrollBar().isVisible()) {
                            return;
                        }
                        super.paintBorder(c2, g2, x2, y2, width, height);
                    }
                });
                JScrollPane jScrollPane = scrollPane;
                if (jScrollPane == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/ui/LicensePanel$9", "createErrorMessageComponent"));
                }
                return jScrollPane;
            }
        });
    }

    @Override
    public void createUI() {
    }

    @Override
    @NotNull
    public JPanel getPanel() {
        LicensePanel licensePanel = this;
        if (licensePanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/ui/LicensePanel", "getPanel"));
        }
        return licensePanel;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.myContent.getPreferredSize();
    }

    private static void addPasteAndUndoActions(JTextComponent textComponent) {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem pasteItem = new JMenuItem(new DefaultEditorKit.PasteAction());
        pasteItem.setText("Paste");
        popupMenu.add(pasteItem);
        JMenuItem copyItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        copyItem.setText("Copy");
        popupMenu.add(copyItem);
        textComponent.setComponentPopupMenu(popupMenu);
        UIUtil.addUndoRedoActions((JTextComponent)textComponent);
    }

    private JPanel createProfileInputPanel() {
        JPanel profileInputPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = JBUI.insets((int)5, (int)5, (int)0, (int)5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        profileInputPanel.add((Component)new JLabel("Username or email:"), gbc);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.insets.bottom = 10;
        profileInputPanel.add((Component)this.myAccountNameField, gbc);
        ++gbc.gridy;
        gbc.insets.bottom = 0;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        profileInputPanel.add((Component)new JLabel("Password:"), gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        profileInputPanel.add((Component)this.myForgotAccountPasswordLink, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        profileInputPanel.add((Component)this.myAccountPasswordField, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weighty = 1.0;
        profileInputPanel.add(Box.createVerticalGlue(), gbc);
        return profileInputPanel;
    }

    private JPanel createKeyInputPanel() {
        JPanel keyInputPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = JBUI.insets((int)5, (int)5, (int)0, (int)5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        final JLabel invisibleSizeBase = new JLabel("Size Holder");
        keyInputPanel.add((Component)new JLabel(){

            @Override
            public Dimension getPreferredSize() {
                return invisibleSizeBase.getPreferredSize();
            }
        }, gbc);
        gbc.weightx = 1.0;
        ++gbc.gridx;
        keyInputPanel.add(Box.createHorizontalGlue(), gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        keyInputPanel.add((Component)this.myProblemsEnteringKeyLink, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        JBScrollPane scrollPane = new JBScrollPane(this.myKeyArea, 20, 31){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.height += 2;
                return size;
            }
        };
        keyInputPanel.add((Component)scrollPane, gbc);
        ++gbc.gridy;
        gbc.fill = 2;
        gbc.anchor = 17;
        keyInputPanel.add((Component)this.myKeyErrorMessage, gbc);
        return keyInputPanel;
    }

    private JPanel createServerInputPanel() {
        JPanel serverInputPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = JBUI.insets((int)5, (int)5, (int)0, (int)5);
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        serverInputPanel.add((Component)new JLabel("License server address:"), gbc);
        ++gbc.gridx;
        gbc.weightx = 0.1;
        serverInputPanel.add(Box.createHorizontalGlue(), gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        serverInputPanel.add((Component)this.myServerMoreInfoLink, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 3;
        serverInputPanel.add((Component)this.myServerAddressField, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        serverInputPanel.add((Component)this.myServerStatusLabel, gbc);
        ++gbc.gridx;
        gbc.gridwidth = 2;
        serverInputPanel.add((Component)this.myDiscoverButton, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 3;
        serverInputPanel.add(Box.createVerticalGlue(), gbc);
        return serverInputPanel;
    }

    private JPanel createEvaluateInputPanel() {
        JPanel evaluatePanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = JBUI.insets((int)10, (int)5, (int)15, (int)5);
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 4;
        gbc.weightx = 1.0;
        evaluatePanel.add((Component)this.myEvalLabel, gbc);
        ++gbc.gridy;
        if (this.getFormData() != null) {
            gbc.insets = JBUI.insets((int)10, (int)5, (int)0, (int)5);
            this.mySubscriptionEmailField.getEmptyText().clear();
            if (LicensePanel.areTipsAvailable()) {
                this.mySubscriptionEmailField.getEmptyText().appendText("Email address (will never be shared outside JetBrains)");
                evaluatePanel.add((Component)this.myTipsCb, gbc);
                ++gbc.gridy;
                evaluatePanel.add((Component)this.myNewsCb, gbc);
                ++gbc.gridy;
            } else {
                this.mySubscriptionEmailField.getEmptyText().appendText("Email address (optional)");
                gbc.insets = JBUI.insets((int)5, (int)5, (int)0, (int)0);
                evaluatePanel.add((Component)new JLabel("Tell me about new product features as they come out:"), gbc);
                ++gbc.gridy;
            }
            gbc.insets = JBUI.insets((int)10, (int)5, (int)0, (int)5);
            evaluatePanel.add((Component)this.mySubscriptionEmailField, gbc);
            ++gbc.gridy;
        }
        gbc.weighty = 1.0;
        evaluatePanel.add(Box.createGlue(), gbc);
        return evaluatePanel;
    }

    private void initLicenses() {
        this.myIgnoreDocumentChanges = true;
        try {
            LicenseData keyLicense;
            this.myActualLicenseSource = this.myLicenseEntry.getActualLicenseSource();
            this.myActualLicenseData = this.myActualLicenseSource != null ? this.myActualLicenseSource.getLicense() : null;
            this.myEvalSource = this.myLicenseEntry.getBuiltInEvalSource();
            if (this.myEvalSource != null && this.myEvalSource.getLicense() == null) {
                this.myEvalSource.restore();
                this.myEvalLabel.setText("Evaluation is free for " + this.myEvalSource.getEvalPeriod() + " days.");
            }
            this.myKeySource = this.myLicenseEntry.getFileSource();
            if (this.myKeySource != null && (keyLicense = this.myKeySource.getLicense()) != null) {
                this.myKeyArea.setText(keyLicense.getKey());
                this.myKeyArea.setCaretPosition(0);
            }
            this.myAccountSource = this.myLicenseEntry.getJetProfileSource();
            if (this.myAccountSource != null) {
                this.myAccountNameField.setText(this.myAccountSource.getLogin());
                this.myAccountPasswordField.setText(this.myAccountSource.getPassword());
            }
            this.myServerSource = this.myLicenseEntry.getLicenseServerSource();
            if (this.myServerSource != null) {
                this.myServerAddressField.setText(this.myServerSource.getServerUrl());
                if (this.myActualLicenseSource instanceof LicenseServerSource) {
                    boolean permanent = this.myActualLicenseData instanceof ServerLicenseData && ((ServerLicenseData)this.myActualLicenseData).isPermanent();
                    this.myServerStatusLabel.setText((permanent ? "Permanent" : "Floating") + " ticket obtained.");
                }
            }
        }
        finally {
            this.myIgnoreDocumentChanges = false;
        }
    }

    private JButton createButton(String text2) {
        JButton button = new JButton(text2);
        if (UIUtil.isUnderAquaLookAndFeel() || UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF() || UIUtil.isUnderAlloyLookAndFeel()) {
            button.setOpaque(false);
        }
        button.addActionListener(this);
        return button;
    }

    private State guessState() {
        this.initLicenses();
        if (this.myActualLicenseSource == null || this.myActualLicenseSource instanceof BuiltInEvaluationSource) {
            return DEFAULT;
        }
        if (this.myActualLicenseSource instanceof FileLicenseSource) {
            return State.KEY_INPUT;
        }
        if (this.myActualLicenseSource instanceof JetprofileSource) {
            return State.JETPROFILE_INPUT;
        }
        if (this.myActualLicenseSource instanceof LicenseServerSource) {
            return State.SERVER_INPUT;
        }
        return DEFAULT;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (e2.getSource() == this.myBuyButton) {
            BrowserUtil.browse((String)this.myLicenseUrls.getPurchaseUrl());
            return;
        }
        if (e2.getSource() == this.myGetNewLicenseButton) {
            if (this.myActualLicenseSource instanceof FileLicenseSource) {
                this.updateState(State.KEY_INPUT);
            } else if (this.myActualLicenseSource instanceof LicenseServerSource) {
                this.updateState(State.SERVER_INPUT);
            } else {
                this.updateState(DEFAULT);
            }
            return;
        }
        if (e2.getSource() == this.myReturnToEvaluationButton) {
            if (0 != JOptionPane.showConfirmDialog(this, "Are you sure you want to return to evaluation license?", "Confirmation", 0)) {
                return;
            }
            LicenseData license = this.myEvalSource.getLicense();
            if (license != null) {
                license.setAccepted(false);
            }
            this.myUI.setOKEnabled(true);
            this.myUI.proceed(this.myEvalSource);
            return;
        }
        if (e2.getSource() == this.myDiscoverButton) {
            this.doServerDiscover(false);
            return;
        }
    }

    private void updateState(@NotNull State state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/ide/license/ui/LicensePanel", "updateState"));
        }
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        this.myState = state;
        if (state != State.EVALUATE) {
            this.myLastInputState = state;
        }
        if (state == State.JETPROFILE_CHOOSE) {
            this.myRecentProblemDescription = null;
        }
        this.updateTopStatusPanel();
        this.updateRadioPanel();
        ((CardLayout)this.myFieldsPanel.getLayout()).show(this.myFieldsPanel, this.myState.name());
        if (state == State.JETPROFILE_CHOOSE) {
            this.updateProfileChoosePanel();
        }
        this.updateOKButton();
        this.updateReturnToEvaluationPanel();
        if (owner != null && owner.isShowing()) {
            owner.requestFocus();
        }
        if (state == State.JETPROFILE_CHOOSE) {
            this.myContent.remove(this.myRadioPanel);
            this.myContent.revalidate();
            this.myContent.repaint();
        } else if (state == State.SERVER_INPUT) {
            this.doServerDiscover(true);
        }
        if (state == State.JETPROFILE_INPUT) {
            this.myAccountNameField.requestFocus();
        }
    }

    private void updateTopStatusPanel() {
        String error;
        this.myStatusPanel.removeAll();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = JBUI.insets((int)5);
        String biggerStyle = "font-size:" + (this.myLabelFont.getSize() + 1) + "pt;font-family:" + this.myLabelFont.getFamily() + ";font-weight:bold;";
        JLabel statusLabel = new JLabel();
        String string2 = error = this.myRecentProblemDescription != null ? this.myRecentProblemDescription : this.myLicenseEntry.getInitialProblemDescription();
        if (!StringUtil.isEmpty((String)error)) {
            JLabel label = new JLabel();
            label.setText("<html><body><p style=\"" + biggerStyle + "\"><span color=\"#" + ColorUtil.toHex((Color)this.myErrorColor) + "\">" + StringUtil.replace((String)error, (String)" ", (String)"&nbsp;") + "</p></body></html>");
            gbc.weighty = 1.0;
            this.myStatusPanel.add((Component)label, gbc);
            ++gbc.gridy;
        } else if (this.myActualLicenseData instanceof CertKeyLicense) {
            CertKeyLicense license = (CertKeyLicense)((Object)this.myActualLicenseData);
            String restrictions = this.myActualLicenseData.getRestrictionsText();
            CertKey certKey = license.getCertKey();
            String assigneeName = certKey.getAssigneeName();
            Date firstExpiredDate = certKey.getFirstExpiredDate(license.getProductCode());
            Date expirationDate = certKey.getExpirationDate(license.getProductCode());
            statusLabel.setText("<html><body><p style=\"margin-top:5px;\">Licensed to " + certKey.getLicenseeName() + (!StringUtil.isEmpty((String)assigneeName) ? " / " + assigneeName : "") + ".</p>" + (firstExpiredDate != null && expirationDate != null ? "<p>Subscription " + (new Date().before(firstExpiredDate) ? "is active until " : "expired on ") + DateFormatUtil.formatAboutDialogDate((Date)expirationDate) + ".</p>" : "") + (certKey.isPerpetualForProduct(license.getProductCode(), license.getProductBuildDate()) ? "<p>You have a perpetual fallback license for this version.</p>" : "") + (restrictions != null ? "<p>" + restrictions + "</p>" : "") + "</body></html>");
            this.myStatusPanel.add((Component)statusLabel, gbc);
        } else if (this.myActualLicenseData != null && !(this.myActualLicenseSource instanceof BuiltInEvaluationSource)) {
            String restrictions = this.myActualLicenseData.getRestrictionsText();
            statusLabel.setText("<html><body><p style=\"" + biggerStyle + "\"><p style=\"margin-top:5px;\">Licensed to " + this.myActualLicenseData.getUserName() + "</p>" + (restrictions != null ? "<p>" + restrictions + "</p>" : "") + "</body></html>");
            this.myStatusPanel.add((Component)statusLabel, gbc);
        } else if (this.myActualLicenseData != null) {
            long days = Math.min(this.myEvalSource.getEvalPeriod(), (long)BuiltInEvaluationSource.remainsDays(this.myActualLicenseData.getExpirationDate(), new Date()));
            statusLabel.setText("<html><body><p style=\"" + biggerStyle + "\">Free evaluation: <span color=\"#" + ColorUtil.toHex((Color)this.myErrorColor) + "\">" + (days > 1L ? days + " days left." : (days > 0L ? "1 day left." : "Expires today.")) + "</span></p></body></html>");
            this.myStatusPanel.add((Component)statusLabel, gbc);
            gbc.weightx = 0.0;
            ++gbc.gridx;
            this.myStatusPanel.add((Component)this.myBuyButton, gbc);
        } else {
            boolean expired;
            boolean bl = expired = this.myEvalSource != null && this.myEvalSource.getLicense() != null && this.myEvalSource.getLicense().isExpired(new Date());
            if (expired) {
                statusLabel.setText("<html><body><p style=\"" + biggerStyle + "\">Evaluation&nbsp;expired.</p></body></html>");
            }
            this.myStatusPanel.add(this.myActivateButton);
            gbc.weightx = 1.0;
            ++gbc.gridx;
            this.myStatusPanel.add((Component)this.myEvaluateButton, gbc);
            this.myEvaluateButton.setEnabled(!expired);
            gbc.weightx = 0.0;
            ++gbc.gridx;
            this.myStatusPanel.add((Component)this.myBuyButton, gbc);
        }
    }

    private void updateProfileChoosePanel() {
        this.myProfileChoosePanel.removeAll();
        List<JBALicenseData> availableLicenses = this.myAccountSource.getAvailableLicenses();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = JBUI.insets((int)5);
        String commonLicensee = null;
        for (JBALicenseData license : availableLicenses) {
            String licensee = license.getUserName();
            if (commonLicensee == null) {
                commonLicensee = licensee;
                continue;
            }
            if (commonLicensee.equals(licensee)) continue;
            commonLicensee = null;
            break;
        }
        String message2 = commonLicensee == null ? "You have several licenses." : "There are several licenses for \"" + commonLicensee + "\".";
        this.myProfileChoosePanel.add((Component)new JLabel("<html><body>" + message2 + "<br>Select the one you want to use for this copy of " + LicensePanel.getAppInfo().getVersionName() + "."), gbc);
        gbc.insets = JBUI.insets((int)5, (int)25, (int)5, (int)5);
        ButtonGroup group = new ButtonGroup();
        this.myChosenAccountLicenseData = this.myAccountSource.getLicense();
        for (final JBALicenseData licenseData : availableLicenses) {
            Date expiration;
            Date upgradeDueDate;
            String restrictions;
            StringBuilder label = new StringBuilder();
            if (commonLicensee == null) {
                label.append("Licensed to \"").append(licenseData.getUserName()).append("\"");
            }
            if (!StringUtil.isEmptyOrSpaces((String)(restrictions = licenseData.getRestrictionsText()))) {
                label.append(", ").append(restrictions);
            }
            Date date = upgradeDueDate = licenseData instanceof JetProfileSubscriptionLicenseData ? ((JetProfileSubscriptionLicenseData)licenseData).getMaintenanceDueDate() : null;
            if (upgradeDueDate != null) {
                label.append(", subscription ends on ").append(DateFormatUtil.formatDate((Date)upgradeDueDate));
            }
            if ((expiration = licenseData.getExpirationDate()) != null) {
                label.append(", expires on ").append(DateFormatUtil.formatDate((Date)expiration));
            }
            if (licenseData instanceof CertKeyLicense) {
                label.append(" (license id: ").append(((CertKeyLicense)((Object)licenseData)).getCertKey().getLicenseId()).append(")");
            }
            if (label.charAt(0) == ',') {
                label.delete(0, 2);
            }
            label.insert(0, "<html><body>");
            label.append("</body></html>");
            JRadioButton button = new JRadioButton(label.toString(), this.myAccountSource.getLicense() == licenseData);
            button.setBorder(null);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    LicensePanel.this.myChosenAccountLicenseData = licenseData;
                }
            });
            group.add(button);
            ++gbc.gridy;
            this.myProfileChoosePanel.add((Component)button, gbc);
        }
        ++gbc.gridy;
        gbc.weighty = 1.0;
        this.myProfileChoosePanel.add(Box.createVerticalGlue(), gbc);
    }

    private void updateRadioPanel() {
        this.myRadioPanel.removeAll();
        if (this.myState == State.JETPROFILE_CHOOSE) {
            return;
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = JBUI.insets((int)5, (int)5, (int)5, (int)15);
        gbc.gridwidth = 0;
        this.myRadioPanel.add((Component)new JLabel(this.myActualLicenseData != null ? "Activate new license with:" : "Activate license with:"), gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.insets = JBUI.insets((int)5, (int)10, (int)5, (int)5);
        ButtonGroup group = new ButtonGroup();
        if (this.myAccountSource != null) {
            group.add(this.myJetProfileButton);
            ++gbc.gridx;
            this.myRadioPanel.add((Component)this.myJetProfileButton, gbc);
        }
        if (this.myKeySource != null) {
            group.add(this.myKeyButton);
            ++gbc.gridx;
            this.myRadioPanel.add((Component)this.myKeyButton, gbc);
        }
        if (this.myServerSource != null) {
            group.add(this.myServerButton);
            ++gbc.gridx;
            this.myRadioPanel.add((Component)this.myServerButton, gbc);
        }
        gbc.insets = JBUI.insets((int)5);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        this.myRadioPanel.add(Box.createHorizontalGlue(), gbc);
        this.myJetProfileButton.setSelected(this.myState == State.JETPROFILE_INPUT);
        this.myKeyButton.setSelected(this.myState == State.KEY_INPUT);
        this.myServerButton.setSelected(this.myState == State.SERVER_INPUT);
        this.myRadioPanel.setVisible(this.myState != State.JETPROFILE_CHOOSE && this.myState != State.EVALUATE);
    }

    private void updateOKButton() {
        this.myUI.setOKEnabled(false);
        this.myUI.setProceedButtonText("Activate");
        if (this.myState == State.JETPROFILE_INPUT) {
            this.myUI.setOKEnabled(!StringUtil.isEmpty((String)this.myAccountNameField.getText()) && this.myAccountPasswordField.getDocument().getLength() > 0);
            return;
        }
        if (this.myState == State.JETPROFILE_CHOOSE) {
            this.myUI.setOKEnabled(true);
            return;
        }
        if (this.myState == State.KEY_INPUT) {
            this.updateKeyFields(this.myKeyArea.getText(), false);
            return;
        }
        if (this.myState == State.SERVER_INPUT) {
            try {
                URL url = new URL(this.myServerAddressField.getText());
                if (StringUtil.isEmpty((String)url.getProtocol())) {
                    return;
                }
                if (StringUtil.isEmpty((String)url.getHost())) {
                    return;
                }
                this.myUI.setOKEnabled(true);
            }
            catch (MalformedURLException url) {
                // empty catch block
            }
            return;
        }
        if (this.myState == State.EVALUATE) {
            boolean enabled;
            boolean validEmail = LicensePanel.isValidEmail(this.mySubscriptionEmailField.getText());
            boolean emptyEmail = StringUtil.isEmpty((String)this.mySubscriptionEmailField.getText());
            boolean bl = enabled = validEmail || emptyEmail;
            if (LicensePanel.areTipsAvailable()) {
                enabled = (this.myNewsCb.isSelected() || this.myTipsCb.isSelected()) && validEmail;
                enabled |= !this.myNewsCb.isSelected() && !this.myTipsCb.isSelected() && emptyEmail;
            }
            this.myUI.setOKEnabled(enabled);
            this.myUI.setProceedButtonText("Evaluate");
        }
    }

    private void updateKeyFields(String key, boolean smartDiscover) {
        this.myKeyArea.setForeground(UIManager.getColor("TextArea.foreground"));
        this.myMyKeyValidationLabel.setText("");
        this.myProblemsEnteringKeyLink.setText("");
        this.myUI.setProceedButtonText(CommonBundle.getOkButtonText());
        LicenseData license = null;
        String message2 = null;
        if (!smartDiscover) {
            this.myKeyErrorMessage.setText(null);
        }
        try {
            license = this.createKeyLicense(key);
        }
        catch (LegacyKeyException e2) {
            license = e2.getLicenseData();
            this.myKeyErrorMessage.setText(e2.getMessage() + ". Press Convert button.");
            this.myUI.setProceedButtonText("Convert");
        }
        catch (ValidationFailedException e3) {
            message2 = e3.getMessage();
        }
        if (license == null) {
            if (!smartDiscover && !StringUtil.isEmpty((String)key)) {
                this.myProblemsEnteringKeyLink.setText("Problems entering key?");
                this.myKeyErrorMessage.setText(message2 != null ? message2 : KEY_IS_INVALID);
            }
            return;
        }
        if (this.myState == State.KEY_INPUT) {
            this.myUI.setOKEnabled(true);
        }
        SwingUtilities.invokeLater(() -> {
            this.myIgnoreDocumentChanges = true;
            try {
                if (!StringUtil.equals((CharSequence)key, (CharSequence)this.myKeyArea.getText())) {
                    this.myKeyArea.setText(key);
                    this.myKeyArea.repaint();
                }
            }
            finally {
                this.myIgnoreDocumentChanges = false;
            }
        });
        this.myKeyArea.setForeground(this.myOkColor);
        Date expirationDate = license.getExpirationDate();
        if (expirationDate != null && expirationDate.after(new Date())) {
            this.myMyKeyValidationLabel.setText(IdeBundle.message((String)"license.panel.expirable.license.description", (Object[])new Object[]{expirationDate}));
        } else if (license instanceof MaintenanceDueAware) {
            Date maintenanceDueDate = ((MaintenanceDueAware)((Object)license)).getMaintenanceDueDate();
            this.myMyKeyValidationLabel.setText(IdeBundle.message((String)"license.panel.maintenance.aware.license.description", (Object[])new Object[]{maintenanceDueDate}));
        } else {
            int version = license.getMajorVersion();
            String versionStr = version > 2000000 ? String.valueOf(version / 1000) + "." + String.valueOf(version % 1000 / 100) : String.valueOf(version);
            this.myMyKeyValidationLabel.setText(IdeBundle.message((String)"license.panel.perpetual.license.description", (Object[])new Object[]{LicensePanel.getAppInfo().getVersionName(), versionStr}));
        }
    }

    private static ApplicationInfo getAppInfo() {
        ApplicationInfo impl = null;
        if (ApplicationManager.getApplication() != null) {
            impl = ApplicationInfo.getInstance();
        }
        if (impl == null) {
            impl = ApplicationInfoImpl.getShadowInstance();
        }
        return impl;
    }

    private LicenseData createKeyLicense(String key) throws ValidationFailedException {
        UserEntrySource source = new UserEntrySource(this.myKeySource.getFactory());
        source.setUserName(null);
        source.setKey(key.trim());
        if (StringUtil.isEmpty((String)source.getKey())) {
            return null;
        }
        try {
            source.create();
        }
        catch (LicenseCreationException e2) {
            return null;
        }
        source.validate();
        LicenseData license = source.getLicense();
        if (license == null) {
            return null;
        }
        license.setFromUser(true);
        license.setAccepted(false);
        return license;
    }

    private void updateReturnToEvaluationPanel() {
        LicenseData licenseData;
        this.myReturnToEvaluationPanel.removeAll();
        boolean hideAndReturn = true;
        LicenseData licenseData2 = licenseData = this.myEvalSource == null ? null : this.myEvalSource.getLicense();
        if (this.myActualLicenseSource instanceof BuiltInEvaluationSource) {
            hideAndReturn = true;
        } else if (licenseData == null || licenseData.isExpired(new Date())) {
            hideAndReturn = true;
        }
        this.myReturnToEvaluationPanel.setVisible(!hideAndReturn);
        if (hideAndReturn) {
            return;
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.myReturnToEvaluationPanel.add((Component)this.myReturnToEvaluationButton, gbc);
        int daysLeft = BuiltInEvaluationSource.remainsDays(licenseData.getExpirationDate(), new Date());
        if (daysLeft != -1) {
            ++gbc.gridx;
            gbc.insets.left = 5;
            String daysLeftMessage = daysLeft > 1 ? IdeBundle.message((String)"license.panel.buildit.evaluation.expires.in.many", (Object[])new Object[]{daysLeft}) : IdeBundle.message((String)"license.panel.buildit.evaluation.expires.in.one", (Object[])new Object[0]);
            this.myReturnToEvaluationPanel.add((Component)new JLabel(daysLeftMessage), gbc);
        }
        ++gbc.gridx;
        gbc.weightx = 1.0;
        this.myReturnToEvaluationPanel.add(Box.createHorizontalGlue(), gbc);
    }

    private JRadioButton createRadioButton(String text2, final @Nullable State state) {
        JRadioButton button = new JRadioButton(text2);
        button.setBorder(null);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (LicensePanel.this.myState != state) {
                    LicensePanel.this.myRecentProblemDescription = null;
                    LicensePanel.this.updateState(state != null ? state : LicensePanel.this.myLastInputState);
                }
            }
        });
        return button;
    }

    @Override
    public void doSmartDiscover() {
        this.doServerDiscover(true);
        this.doClipboardDiscover();
    }

    private void doServerDiscover(boolean isSmartDiscover) {
        if (!this.myServerButton.isSelected() || isSmartDiscover && !StringUtil.isEmpty((String)this.myServerAddressField.getText())) {
            return;
        }
        this.doAsyncTask(this.myServerDiscoverLock, () -> {
            try {
                String url = DefaultLicenseServerUtil.discoverServerUrl();
                return DefaultLicenseServerUtil.ping(url) ? url : null;
            }
            catch (Throwable throwable) {
                return null;
            }
        }, s2 -> {
            if (s2 != null) {
                this.myServerAddressField.setText((String)s2);
            }
        }, isSmartDiscover ? 5000L : UI_ASYNC_TASK_TIMEOUT, !isSmartDiscover);
    }

    private <T> void doAsyncTask(AtomicBoolean inProgressFlag, Computable<T> computable, Consumer<T> edtRunnable, long timeout, boolean useDecorator) {
        if (this.myDisposed || !inProgressFlag.compareAndSet(false, true)) {
            return;
        }
        if (useDecorator) {
            this.myDecorator.setLoadingText("Please wait...");
            this.myDecorator.startLoading(false);
            this.setAllEnabled(false);
            this.myUI.setOKEnabled(false);
        }
        Future<Object> task2 = PooledThreadExecutor.INSTANCE.submit(() -> computable.compute());
        new Thread(() -> {
            Object t2 = null;
            try {
                t2 = task2.get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Object asyncResult = t2;
            SwingUtilities.invokeLater(() -> {
                try {
                    if (useDecorator) {
                        this.myDecorator.stopLoading();
                        this.setAllEnabled(true);
                        this.updateOKButton();
                    }
                    if (!this.myDisposed) {
                        edtRunnable.accept(asyncResult);
                    }
                }
                finally {
                    inProgressFlag.set(false);
                }
            });
        }, "server discover").start();
    }

    private void setAllEnabled(boolean enabled) {
        UIUtil.setEnabled((Component)this.myBuyButton, (boolean)enabled, (boolean)true);
        UIUtil.setEnabled((Component)this.myActivateButton, (boolean)enabled, (boolean)true);
        UIUtil.setEnabled((Component)this.myEvaluateButton, (boolean)enabled, (boolean)true);
        UIUtil.setEnabled((Component)this.myRadioPanel, (boolean)enabled, (boolean)true);
        UIUtil.setEnabled((Component)this.myFieldsPanel, (boolean)enabled, (boolean)true);
        UIUtil.setEnabled((Component)this.myReturnToEvaluationButton, (boolean)enabled, (boolean)true);
    }

    private void doClipboardDiscover() {
        block11: {
            if (!StringUtil.isEmpty((String)this.myKeyArea.getText()) || this.myState != State.KEY_INPUT) {
                return;
            }
            try {
                boolean keyFound;
                Object data = Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
                if (!(data instanceof String)) break block11;
                String s2 = (String)data;
                if (s2.length() > 10000) {
                    return;
                }
                s2 = s2.trim();
                Matcher licenseStartMatcher = LICENSE_START_PATTERN1.matcher(s2);
                Matcher licenseEndMatcher = LICENSE_END_PATTERN1.matcher(s2);
                boolean bl = keyFound = licenseStartMatcher.find() && licenseEndMatcher.find() && licenseStartMatcher.end() < licenseEndMatcher.start();
                if (keyFound) {
                    String licenseKey = s2.substring(licenseStartMatcher.end(), licenseEndMatcher.start());
                    licenseKey = licenseKey.replace(' ', '\n').replace('\r', '\n').replace("\n\n", "\n");
                    while (licenseKey.endsWith("\n")) {
                        licenseKey = licenseKey.substring(0, licenseKey.length() - 1);
                    }
                    this.updateKeyFields(licenseKey, true);
                    return;
                }
                Matcher licenseMatcher = LICENSE_PATTERN2.matcher(s2);
                if (licenseMatcher.find()) {
                    String licenseKey = licenseMatcher.group(1);
                    this.updateKeyFields(licenseKey, true);
                    return;
                }
                try {
                    LicenseData license = this.createKeyLicense(s2);
                    if (license != null) {
                        this.updateKeyFields(s2, true);
                    }
                }
                catch (LegacyKeyException lke) {
                    this.updateKeyFields(s2, true);
                }
                catch (ValidationFailedException validationFailedException) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        long timeoutBase;
        LOG = Logger.getInstance((String)"#com.intellij.ide.license.ui.LicensePanel");
        EMAIL_PATTERN = Pattern.compile("^[A-z0-9._%+-]+@[A-z0-9.-]+\\.[A-z]{2,5}$");
        LICENSE_START_PATTERN1 = Pattern.compile("LICENSE BEGIN\\s\\={3,}[\\n\\r]+");
        LICENSE_END_PATTERN1 = Pattern.compile("\\={3,}\\sLICENSE END");
        LICENSE_PATTERN2 = Pattern.compile("License Key\\s?[\\d]*:\\s(.+)[\\n\\r]+");
        DEFAULT = State.JETPROFILE_INPUT;
        try {
            timeoutBase = Long.parseLong(System.getProperty("license.request.timeout", String.valueOf(30000L)));
        }
        catch (Throwable ignored) {
            timeoutBase = 30000L;
        }
        UI_ASYNC_TASK_TIMEOUT = timeoutBase;
        isRequiredJBA = false;
        isOptionalJBA = false;
        Calendar calendar = Calendar.getInstance(Locale.US);
        calendar.setTimeInMillis(0L);
        calendar.set(1, 2016);
        calendar.set(2, 1);
        calendar.set(5, 1);
        Date startTestingDate = calendar.getTime();
        calendar.set(1, 2016);
        calendar.set(2, 2);
        calendar.set(5, 15);
        Date endTestingDate = calendar.getTime();
        Date now = new Date();
        if (now.after(startTestingDate) && now.before(endTestingDate)) {
            int value2 = Math.abs(ClientUtil.getMachineId().hashCode() % 1000);
            isRequiredJBA = value2 < 25;
            isOptionalJBA = value2 >= 25 && value2 < 50;
        }
    }

    private class ErrorLabel
    extends JPanel {
        private JLabel myIconLabel;
        private JEditorPane myTextPane;

        public ErrorLabel() {
            this.setLayout(new BorderLayout(2, 2));
            this.myIconLabel = new JLabel();
            this.add((Component)this.myIconLabel, "West");
            this.myTextPane = new JEditorPane();
            this.add((Component)this.myTextPane, "Center");
            this.myIconLabel.setVerticalAlignment(1);
            this.myTextPane.setOpaque(false);
            this.myTextPane.setContentType("text/html");
            this.myTextPane.addHyperlinkListener((HyperlinkListener)new BrowserHyperlinkListener());
            this.myTextPane.setFont(new JLabel().getFont());
            this.myTextPane.setEditable(false);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.height = Math.max(this.myIconLabel.getPreferredSize().height * 3 / 2, size.height);
            return size;
        }

        public void setText(String text2) {
            int pos;
            if (text2 != null && text2.contains("href") && (pos = text2.indexOf(".")) != -1 && pos < text2.length() - 2 && !text2.contains("<br>") && !text2.contains("</p>")) {
                text2 = text2.substring(0, pos + 1) + "<br>" + text2.substring(pos + 2);
            }
            this.myIconLabel.setIcon(StringUtil.isEmpty((String)text2) ? LicensePanel.this.EMPTY_ERROR_ICON : LicensePanel.this.ERROR_ICON);
            this.myTextPane.setText(StringUtil.isEmpty((String)text2) ? null : "<html><body style=\"font-family:" + this.myIconLabel.getFont().getFamily() + ";font-size:" + this.myIconLabel.getFont().getSize() + "pt;\">" + text2);
            int baseline1 = this.myIconLabel.getBaseline(Math.max(0, this.myIconLabel.getWidth()), Math.max(0, this.myIconLabel.getHeight()));
            int baseline2 = this.myTextPane.getBaseline(Math.max(0, this.myTextPane.getWidth()), Math.max(0, this.myTextPane.getHeight()));
            this.myTextPane.setBorder((Border)JBUI.Borders.empty((int)(baseline1 - baseline2), (int)0, (int)0, (int)0));
        }
    }

    private class MyTransferHandler
    extends TransferHandler {
        private final int maxLength = 15000;

        private MyTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return true;
        }

        @Override
        public void exportToClipboard(JComponent comp, Clipboard clip, int action2) throws IllegalStateException {
            if (action2 == 1) {
                clip.setContents(new StringSelection(LicensePanel.this.myKeyArea.getSelectedText()), null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            Transferable transferable = support.getTransferable();
            try {
                Object data;
                List<File> list2 = FileCopyPasteUtil.getFileList(support.getTransferable());
                if (list2 != null && list2.size() == 1) {
                    File toRead = list2.get(0);
                    FileInputStream stream = null;
                    try {
                        stream = new FileInputStream(toRead);
                        byte[] bytes = new byte[16384];
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        int l2 = stream.read(bytes);
                        while (l2 > 0) {
                            baos.write(bytes, 0, l2);
                            if (baos.size() > 15000) {
                                boolean bl = false;
                                return bl;
                            }
                            l2 = stream.read(bytes);
                        }
                        LicensePanel.this.myKeyArea.setText(new String(baos.toByteArray(), Charset.forName("UTF-8")));
                        boolean bl = true;
                        return bl;
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                if ((data = transferable.getTransferData(DataFlavor.selectBestTextFlavor(transferable.getTransferDataFlavors()))) instanceof String && ((String)data).length() <= 15000) {
                    LicensePanel.this.myKeyArea.setText((String)data);
                    return true;
                }
                data = transferable.getTransferData(DataFlavor.stringFlavor);
                if (!(data instanceof String)) return false;
                if (((String)data).length() > 15000) return false;
                LicensePanel.this.myKeyArea.setText((String)data);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }

    private class ExchangeKeyDialog
    extends DialogWrapper {
        public ExchangeKeyDialog(Component parent, boolean canBeParent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/ide/license/ui/LicensePanel$ExchangeKeyDialog", "<init>"));
            }
            super(parent, canBeParent);
            this.setTitle("Please provide your contact details");
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JPanel form = new JPanel((LayoutManager)new MigLayout("ins 5, gap 5, flowx, fill"));
            form.add(new JLabel("First Name:"));
            form.add((Component)LicensePanel.this.myFirstNameField, "wrap");
            form.add(new JLabel("Last Name:"));
            form.add((Component)LicensePanel.this.myLastNameField, "wrap");
            form.add(new JLabel("Email:"));
            form.add(LicensePanel.this.myEmailField);
            return form;
        }

        protected void createDefaultActions() {
            super.createDefaultActions();
            this.getOKAction().putValue("Name", "Send");
        }

        public void show() {
            this.init();
            this.pack();
            super.show();
        }

        @Nullable
        protected ValidationInfo doValidate() {
            if (this.isEmpty()) {
                return new ValidationInfo("All fields are required", null);
            }
            if (!EMAIL_PATTERN.matcher(LicensePanel.this.myEmailField.getText()).matches()) {
                return new ValidationInfo("Email address is not valid", (JComponent)LicensePanel.this.myEmailField);
            }
            return null;
        }

        private boolean isEmpty() {
            return StringUtil.isEmpty((String)LicensePanel.this.myFirstNameField.getText()) || StringUtil.isEmpty((String)LicensePanel.this.myLastNameField.getText()) || StringUtil.isEmpty((String)LicensePanel.this.myEmailField.getText());
        }
    }

    private static class HintTextArea
    extends JTextArea {
        private final char[] myHint;

        public HintTextArea(int rows, int columns, String hint) {
            super(rows, columns);
            this.myHint = hint.toCharArray();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintComponent(Graphics g2) {
            super.paintComponent(g2);
            if (this.getText().isEmpty()) {
                Color oldColor = g2.getColor();
                Font oldFont = g2.getFont();
                try {
                    g2.setColor((Color)JBColor.GRAY);
                    ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    FontMetrics metrics = g2.getFontMetrics();
                    int x2 = Math.abs(this.getWidth() - metrics.charsWidth(this.myHint, 0, this.myHint.length)) / 2;
                    int y2 = Math.abs(this.getHeight() - metrics.getHeight()) / 2 + metrics.getAscent();
                    g2.drawChars(this.myHint, 0, this.myHint.length, x2, y2);
                }
                finally {
                    g2.setColor(oldColor);
                    g2.setFont(oldFont);
                }
            }
        }
    }

    private static class HintTextField
    extends JTextField {
        private final char[] myHint;

        public HintTextField(String hint, int columns) {
            super(columns);
            this.myHint = hint.toCharArray();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintComponent(Graphics g2) {
            super.paintComponent(g2);
            boolean isFocused = this.isFocusOwner();
            if (!isFocused && this.getText().isEmpty()) {
                Color oldColor = g2.getColor();
                Font oldFont = g2.getFont();
                try {
                    g2.setColor((Color)JBColor.GRAY);
                    ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    FontMetrics metrics = g2.getFontMetrics();
                    int x2 = Math.abs(this.getWidth() - metrics.charsWidth(this.myHint, 0, this.myHint.length)) / 2;
                    int y2 = Math.abs(this.getHeight() - metrics.getHeight()) / 2 + metrics.getAscent();
                    g2.drawChars(this.myHint, 0, this.myHint.length, x2, y2);
                }
                finally {
                    g2.setColor(oldColor);
                    g2.setFont(oldFont);
                }
            }
        }
    }

    private class Link
    extends JLabel
    implements Border {
        private String myUrl;

        private Link(String text2, String url) {
            this.setText(text2);
            this.myUrl = url;
            super.setForeground(LicensePanel.this.myLinkColor);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e2) {
                    if (SwingUtilities.isLeftMouseButton(e2)) {
                        Link.this.requestFocus();
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e2) {
                    if (SwingUtilities.isLeftMouseButton(e2)) {
                        Link.this.doAction();
                    }
                }
            });
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e2) {
                    if (e2.getKeyCode() == 10) {
                        Link.this.doAction();
                    }
                }
            });
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e2) {
                    Link.this.repaint();
                }

                @Override
                public void focusLost(FocusEvent e2) {
                    Link.this.repaint();
                }
            });
            this.setBorder(this);
        }

        @Override
        public void setForeground(Color fg) {
        }

        @Override
        public String toString() {
            return "Link:" + this.myUrl;
        }

        public void setUrl(String url) {
            this.myUrl = url;
        }

        private void doAction() {
            BrowserUtil.browse((String)this.myUrl);
        }

        @Override
        public boolean isFocusable() {
            return !StringUtil.isEmpty((String)this.getText());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
            if (!c2.isFocusOwner() || StringUtil.isEmpty((String)this.getText())) {
                return;
            }
            Graphics2D g2d = (Graphics2D)g2.create();
            try {
                g2d.setStroke(new BasicStroke(0.5f, 0, 0, 1.0f, new float[]{3.0f, 1.0f}, 0.0f));
                g2d.setColor(ColorUtil.withAlpha((Color)LicensePanel.this.myLinkColor, (double)0.5));
                g2d.drawRect(x2, y2, width - 1, height - 1);
            }
            finally {
                g2d.dispose();
            }
        }

        @Override
        public Insets getBorderInsets(Component c2) {
            return JBUI.insets((int)0, (int)2);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    private static enum State {
        JETPROFILE_INPUT,
        JETPROFILE_CHOOSE,
        KEY_INPUT,
        SERVER_INPUT,
        EVALUATE;

    }
}

