/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.license.LicenseCreationException;
import com.intellij.ide.license.impl.DefaultLicenseServerUtil;
import com.intellij.ide.license.impl.LicenseServerSource;
import com.intellij.ide.license.impl.ServerLicenseData;
import com.intellij.ide.license.ui.BaseLicenseDataEdit;
import com.intellij.ide.license.ui.LicenseEntryUI;
import com.intellij.ide.license.ui.LicenseEntryUtil;
import com.intellij.licensecommon.license.LicenseData;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nullable;

public class LicenseServerEditPanel
extends BaseLicenseDataEdit<LicenseServerSource> {
    private static final String LICENSE_SERVER_INFO_DISPLAY_URL = IdeBundle.message((String)"link.click.here.to.license.server.info", (Object[])new Object[0]);
    private JTextArea licenseAddressField;
    private JButton discoverButton;
    private JLabel ticketStatus;
    private JLabel infoLink;
    private String infoUrl;
    private JRadioButton dataType;
    private JPanel mainPanel;
    private AsyncProcessIcon myAsyncProcessIcon1;

    public LicenseServerEditPanel(LicenseServerSource licenseSource, String infoUrl, LicenseEntryUI ui) {
        super(licenseSource, ui);
        this.infoUrl = infoUrl;
        this.$$$setupUI$$$();
    }

    @Override
    public void init() {
        super.init();
        LicenseEntryUtil.setSingleLine(this.licenseAddressField);
        LicenseEntryUtil.fixFocusTraversal(this.licenseAddressField);
        this.licenseAddressField.setText(((LicenseServerSource)this.licenseSource).getServerUrl());
        LicenseEntryUtil.installCutCopyPasteKeyStrokes(this.licenseAddressField);
        LicenseEntryUtil.makeLinkLabel(this.infoLink, this.getLicenseServerInfoDisplayUrl(this.infoUrl), this.infoUrl);
        this.myAsyncProcessIcon1.suspend();
        this.myAsyncProcessIcon1.setPaintPassiveIcon(false);
        this.discoverButton.setVisible(true);
        this.discoverButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                LicenseServerEditPanel.this.discoverDefaultServer();
            }
        });
        this.ticketStatus.setText(this.describeLicense(((LicenseServerSource)this.licenseSource).getLicense()));
        this.ticketStatus.setForeground(Color.BLACK);
        DocumentAdapter listener2 = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e2) {
                LicenseServerEditPanel.this.updateOkAction();
            }
        };
        this.licenseAddressField.getDocument().addDocumentListener((DocumentListener)listener2);
    }

    private void updateOkAction() {
        this.ui.setOKEnabled(!StringUtil.isEmpty((String)this.licenseAddressField.getText()));
    }

    private String describeLicense(@Nullable LicenseData license) {
        if (license == null) {
            return "  ";
        }
        if (license instanceof ServerLicenseData && ((ServerLicenseData)license).isPermanent()) {
            return IdeBundle.message((String)"license.panel.current.permanent.ticket.description", (Object[])new Object[0]);
        }
        return IdeBundle.message((String)"license.panel.current.floating.ticket.description", (Object[])new Object[0]);
    }

    private void discoverDefaultServer() {
        if (this.myAsyncProcessIcon1.isRunning()) {
            return;
        }
        this.myAsyncProcessIcon1.resume();
        new Thread(() -> {
            String url = null;
            boolean pingOk = false;
            try {
                url = DefaultLicenseServerUtil.discoverServerUrl();
                pingOk = DefaultLicenseServerUtil.ping(url);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            String finalUrl = url;
            boolean finalPingOk = pingOk;
            SwingUtilities.invokeLater(() -> {
                this.myAsyncProcessIcon1.suspend();
                if (finalUrl == null) {
                    this.ticketStatus.setText(IdeBundle.message((String)"license.panel.discover.license.server.error.message", (Object[])new Object[0]));
                    this.ticketStatus.setForeground(Color.RED);
                } else if (!finalPingOk) {
                    this.ticketStatus.setText(IdeBundle.message((String)"license.panel.ping.license.server.error.message", (Object[])new Object[]{finalUrl}));
                    this.ticketStatus.setForeground(Color.RED);
                } else {
                    this.licenseAddressField.setText(finalUrl);
                    this.ticketStatus.setText("  ");
                    this.ticketStatus.setForeground(Color.BLACK);
                }
            });
        }, "server ping").start();
    }

    @Override
    public LicenseServerSource getLicenseSourceToProceed() {
        String newUrl;
        String oldUrl = ((LicenseServerSource)this.licenseSource).getServerUrl() != null ? ((LicenseServerSource)this.licenseSource).getServerUrl() : "";
        if (!oldUrl.equals(newUrl = this.licenseAddressField.getText()) || ((LicenseServerSource)this.licenseSource).getLicense() == null) {
            ((LicenseServerSource)this.licenseSource).setServerUrl(newUrl);
            try {
                ((LicenseServerSource)this.licenseSource).create();
            }
            catch (LicenseCreationException e2) {
                return null;
            }
            ServerLicenseData license = ((LicenseServerSource)this.licenseSource).getLicense();
            if (license == null) {
                return null;
            }
            license.setFromUser(true);
            license.setAccepted(false);
        }
        return (LicenseServerSource)this.licenseSource;
    }

    @Override
    protected void disableControls() {
        super.disableControls();
        this.licenseAddressField.setEditable(false);
        this.licenseAddressField.setEnabled(false);
        this.discoverButton.setEnabled(false);
    }

    @Override
    protected void enableControls() {
        super.enableControls();
        this.licenseAddressField.setEditable(true);
        this.licenseAddressField.setEnabled(true);
        this.discoverButton.setEnabled(true);
        this.licenseAddressField.requestFocus();
        this.updateOkAction();
    }

    private String getLicenseServerInfoDisplayUrl(String url) {
        return SystemInfo.isUnix && !SystemInfo.isMac ? url : LICENSE_SERVER_INFO_DISPLAY_URL;
    }

    @Override
    public JRadioButton getTypeSelector() {
        return this.dataType;
    }

    @Override
    public JPanel getPanel() {
        return this.mainPanel;
    }

    private void createUIComponents() {
        this.myAsyncProcessIcon1 = new AsyncProcessIcon("Discovering license server...");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JRadioButton jRadioButton;
        JLabel jLabel2;
        JButton jButton;
        JTextArea jTextArea;
        JPanel jPanel;
        this.createUIComponents();
        this.mainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(10, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jBScrollPane.setVerticalScrollBarPolicy(21);
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 1, 1, 7, 3, new Dimension(500, 20), null, null, 3));
        this.licenseAddressField = jTextArea = new JTextArea();
        ((Component)jTextArea).setFont(UIManager.getFont("TextField.font"));
        jTextArea.setColumns(30);
        jBScrollPane.setViewportView(jTextArea);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 1, 1, 3, 3, null, null, null, 1));
        this.discoverButton = jButton = new JButton();
        jButton.setText("Discover");
        jPanel2.add((Component)jButton, new GridConstraints(0, 3, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.ticketStatus = jLabel2 = new JLabel();
        jLabel2.setText("Label");
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        AsyncProcessIcon asyncProcessIcon = this.myAsyncProcessIcon1;
        jPanel2.add((Component)asyncProcessIcon, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.dataType = jRadioButton = new JRadioButton();
        jRadioButton.setText("Enter license server address");
        jPanel3.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.infoLink = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

