/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.ui;

import com.intellij.ide.license.LicenseCreationException;
import com.intellij.ide.license.impl.JBALicenseData;
import com.intellij.ide.license.impl.JetprofileSource;
import com.intellij.ide.license.ui.BaseLicenseDataEdit;
import com.intellij.ide.license.ui.LicenseEntryUI;
import com.intellij.ide.license.ui.LicenseEntryUtil;
import com.intellij.licensecommon.license.LicenseData;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nullable;

public class LicenseServiceEditPanel
extends BaseLicenseDataEdit<JetprofileSource> {
    private JLabel ticketStatus;
    private JRadioButton dataType;
    private JPanel mainPanel;
    private JTextField myLoginField;
    private JPasswordField myPasswordField;

    public LicenseServiceEditPanel(JetprofileSource licenseSource, LicenseEntryUI ui) {
        super(licenseSource, ui);
        this.$$$setupUI$$$();
    }

    @Override
    public void init() {
        super.init();
        String login = ((JetprofileSource)this.licenseSource).getLogin();
        this.myLoginField.setText(login != null ? login : "");
        String password = ((JetprofileSource)this.licenseSource).getPassword();
        this.myPasswordField.setText(password != null ? password : "");
        LicenseEntryUtil.installCutCopyPasteKeyStrokes(this.myLoginField);
        LicenseEntryUtil.installCutCopyPasteKeyStrokes(this.myPasswordField);
        this.ticketStatus.setText(LicenseServiceEditPanel.describeLicense(((JetprofileSource)this.licenseSource).getLicense()));
        this.ticketStatus.setForeground(Color.BLACK);
        this.myLoginField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e2) {
                LicenseServiceEditPanel.this.updateOkAction();
            }
        });
        if (this.dataType.isSelected()) {
            this.enableControls();
        } else {
            this.disableControls();
        }
    }

    private void updateOkAction() {
        this.ui.setOKEnabled(!StringUtil.isEmpty((String)this.myLoginField.getText()));
    }

    private static String describeLicense(@Nullable LicenseData license) {
        return license == null ? "" : "Valid license obtained from JetBrains Account. The license granted to " + license.getUserName();
    }

    @Override
    public JetprofileSource getLicenseSourceToProceed() {
        String login = this.myLoginField.getText();
        String password = new String(this.myPasswordField.getPassword());
        if (((JetprofileSource)this.licenseSource).getLicense() == null || !Comparing.equal((String)((JetprofileSource)this.licenseSource).getLogin(), (String)login) || !Comparing.equal((String)((JetprofileSource)this.licenseSource).getPassword(), (String)password)) {
            ((JetprofileSource)this.licenseSource).setLogin(login);
            ((JetprofileSource)this.licenseSource).setPassword(password);
            try {
                ((JetprofileSource)this.licenseSource).create();
            }
            catch (LicenseCreationException e2) {
                return null;
            }
            JBALicenseData license = ((JetprofileSource)this.licenseSource).getLicense();
            if (license == null) {
                return null;
            }
            license.setFromUser(true);
            license.setAccepted(false);
        }
        return (JetprofileSource)this.licenseSource;
    }

    @Override
    protected void disableControls() {
        super.disableControls();
        this.myLoginField.setEnabled(false);
        this.myLoginField.setEditable(false);
        this.myPasswordField.setEnabled(false);
        this.myPasswordField.setEditable(false);
    }

    @Override
    protected void enableControls() {
        super.enableControls();
        this.myLoginField.setEnabled(true);
        this.myLoginField.setEditable(true);
        this.myPasswordField.setEnabled(true);
        this.myPasswordField.setEditable(true);
        this.myLoginField.requestFocus();
        this.updateOkAction();
    }

    @Override
    public JRadioButton getTypeSelector() {
        return this.dataType;
    }

    @Override
    public JPanel getPanel() {
        return this.mainPanel;
    }

    private void createUIComponents() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPasswordField jPasswordField;
        JTextField jTextField;
        JRadioButton jRadioButton;
        JPanel jPanel;
        this.mainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(10, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.dataType = jRadioButton = new JRadioButton();
        jRadioButton.setText("Use JetBrains account");
        jPanel2.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myLoginField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Login:");
        jPanel.add((Component)jLabel2, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null, 5));
        this.myPasswordField = jPasswordField = new JPasswordField();
        jPanel.add((Component)jPasswordField, new GridConstraints(2, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Password:");
        jPanel.add((Component)jLabel3, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null, 5));
        this.ticketStatus = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(3, 1, 1, 2, 8, 0, 0, 0, null, null, null, 5));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

