/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.navigationToolbar.NavBarModel;
import com.intellij.ide.navigationToolbar.NavBarModelExtension;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IconUtil;
import java.awt.Color;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavBarPresentation {
    private static final SimpleTextAttributes WOLFED = new SimpleTextAttributes(null, null, (Color)JBColor.red, 8);
    private final Project myProject;

    public NavBarPresentation(Project project2) {
        this.myProject = project2;
    }

    @Nullable
    public Icon getIcon(final Object object) {
        if (!NavBarModel.isValid(object)) {
            return null;
        }
        if (object instanceof Project) {
            return AllIcons.Nodes.Project;
        }
        if (object instanceof Module) {
            return ModuleType.get((Module)((Module)object)).getIcon();
        }
        try {
            if (object instanceof PsiElement) {
                Icon icon = (Icon)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Icon>(){

                    public Icon compute() {
                        return ((PsiElement)object).isValid() ? ((PsiElement)object).getIcon(0) : null;
                    }
                });
                if (icon != null && (icon.getIconHeight() > 32 || icon.getIconWidth() > 32)) {
                    icon = IconUtil.cropIcon((Icon)icon, (int)32, (int)32);
                }
                return icon;
            }
        }
        catch (IndexNotReadyException e2) {
            return null;
        }
        if (object instanceof JdkOrderEntry) {
            SdkTypeId sdkType = ((JdkOrderEntry)object).getJdk().getSdkType();
            return ((SdkType)sdkType).getIcon();
        }
        if (object instanceof LibraryOrderEntry) {
            return AllIcons.Nodes.PpLibFolder;
        }
        if (object instanceof ModuleOrderEntry) {
            return ModuleType.get((Module)((ModuleOrderEntry)object).getModule()).getIcon();
        }
        return null;
    }

    @NotNull
    protected String getPresentableText(Object object) {
        if (!NavBarModel.isValid(object)) {
            String string2 = IdeBundle.message((String)"node.structureview.invalid", (Object[])new Object[0]);
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/navigationToolbar/NavBarPresentation", "getPresentableText"));
            }
            return string2;
        }
        for (NavBarModelExtension modelExtension : (NavBarModelExtension[])Extensions.getExtensions(NavBarModelExtension.EP_NAME)) {
            String text2 = modelExtension.getPresentableText(object);
            if (text2 == null) continue;
            String string3 = text2.length() > 50 ? text2.substring(0, 47) + "..." : text2;
            if (string3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/navigationToolbar/NavBarPresentation", "getPresentableText"));
            }
            return string3;
        }
        String string4 = object.toString();
        if (string4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/navigationToolbar/NavBarPresentation", "getPresentableText"));
        }
        return string4;
    }

    protected SimpleTextAttributes getTextAttributes(final Object object, boolean selected) {
        if (!NavBarModel.isValid(object)) {
            return SimpleTextAttributes.REGULAR_ATTRIBUTES;
        }
        if (object instanceof PsiElement) {
            VirtualFile vDir;
            if (!((Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    return ((PsiElement)object).isValid();
                }
            })).booleanValue()) {
                return SimpleTextAttributes.GRAYED_ATTRIBUTES;
            }
            PsiFile psiFile = ((PsiElement)object).getContainingFile();
            if (psiFile != null) {
                VirtualFile virtualFile = psiFile.getVirtualFile();
                return new SimpleTextAttributes(null, selected ? null : FileStatusManager.getInstance((Project)this.myProject).getStatus(virtualFile).getColor(), (Color)JBColor.red, WolfTheProblemSolver.getInstance((Project)this.myProject).isProblemFile(virtualFile) ? 8 : 0);
            }
            if (object instanceof PsiDirectory && ((vDir = ((PsiDirectory)object).getVirtualFile()).getParent() == null || ProjectRootsUtil.isModuleContentRoot(vDir, this.myProject))) {
                return SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            }
            if (NavBarPresentation.wolfHasProblemFilesBeneath((PsiElement)object)) {
                return WOLFED;
            }
        } else if (object instanceof Module) {
            if (WolfTheProblemSolver.getInstance((Project)this.myProject).hasProblemFilesBeneath((Module)object)) {
                return WOLFED;
            }
        } else if (object instanceof Project) {
            Module[] modules;
            final Project project2 = (Project)object;
            for (Module module2 : modules = (Module[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<Module[]>(){

                public Module[] compute() {
                    return ModuleManager.getInstance((Project)project2).getModules();
                }
            })) {
                if (!WolfTheProblemSolver.getInstance((Project)project2).hasProblemFilesBeneath(module2)) continue;
                return WOLFED;
            }
        }
        return SimpleTextAttributes.REGULAR_ATTRIBUTES;
    }

    public static boolean wolfHasProblemFilesBeneath(PsiElement scope) {
        return WolfTheProblemSolver.getInstance((Project)scope.getProject()).hasProblemFilesBeneath(virtualFile -> {
            if (scope instanceof PsiDirectory) {
                PsiDirectory directory = (PsiDirectory)scope;
                if (!VfsUtil.isAncestor((VirtualFile)directory.getVirtualFile(), (VirtualFile)virtualFile, (boolean)false)) {
                    return false;
                }
                return ModuleUtil.findModuleForFile((VirtualFile)virtualFile, (Project)scope.getProject()) == ModuleUtil.findModuleForPsiElement((PsiElement)scope);
            }
            if (scope instanceof PsiDirectoryContainer) {
                PsiDirectory[] psiDirectories;
                for (PsiDirectory directory : psiDirectories = ((PsiDirectoryContainer)scope).getDirectories()) {
                    if (!VfsUtil.isAncestor((VirtualFile)directory.getVirtualFile(), (VirtualFile)virtualFile, (boolean)false)) continue;
                    return true;
                }
            }
            return false;
        });
    }
}

