/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.navigationToolbar.NavBarListWrapper;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.navigationToolbar.SelectInNavBarTarget;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;

public class ShowNavBarAction
extends AnAction
implements DumbAware,
PopupAction {
    public void actionPerformed(AnActionEvent e2) {
        DataContext context2 = e2.getDataContext();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(context2);
        if (project2 != null) {
            UISettings uiSettings = UISettings.getInstance();
            if (uiSettings.getShowNavigationBar() && !uiSettings.getPresentationMode()) {
                new SelectInNavBarTarget(project2).select(null, false);
            } else {
                Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(context2);
                if (!ShowNavBarAction.isInsideNavBar(component)) {
                    Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context2);
                    NavBarPanel toolbarPanel = new NavBarPanel(project2, false);
                    toolbarPanel.showHint(editor, context2);
                }
            }
        }
    }

    private static boolean isInsideNavBar(Component c2) {
        return c2 == null || c2 instanceof NavBarPanel || UIUtil.getParentOfType(NavBarListWrapper.class, (Component)c2) != null;
    }

    public void update(AnActionEvent e2) {
        boolean enabled = e2.getData(CommonDataKeys.PROJECT) != null;
        e2.getPresentation().setEnabled(enabled);
    }
}

