/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.impl.providers;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ByteArrayWrapper
implements Comparable<ByteArrayWrapper> {
    private final byte[] myData;

    public ByteArrayWrapper(@NotNull byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/ide/passwordSafe/impl/providers/ByteArrayWrapper", "<init>"));
        }
        this.myData = data;
    }

    public int hashCode() {
        return Arrays.hashCode(this.myData);
    }

    public boolean equals(Object obj) {
        return obj instanceof ByteArrayWrapper && Arrays.equals(this.myData, ((ByteArrayWrapper)obj).myData);
    }

    @Override
    public int compareTo(ByteArrayWrapper o2) {
        if (o2 == null) {
            return -1;
        }
        int n2 = Math.max(o2.myData.length, this.myData.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            int d2 = this.myData[i2] - o2.myData[i2];
            if (d2 == 0) continue;
            return d2;
        }
        return this.myData.length - o2.myData.length;
    }

    public byte[] unwrap() {
        return this.myData;
    }
}

