/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.impl.providers.memory;

import com.intellij.ide.passwordSafe.impl.PasswordSafeTimed;
import com.intellij.ide.passwordSafe.impl.providers.BasePasswordSafeProvider;
import com.intellij.ide.passwordSafe.impl.providers.ByteArrayWrapper;
import com.intellij.ide.passwordSafe.impl.providers.EncryptionUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class MemoryPasswordSafe
extends BasePasswordSafeProvider {
    private final transient AtomicReference<byte[]> key = new AtomicReference();
    private final transient PasswordSafeTimed<Map<ByteArrayWrapper, byte[]>> database = new PasswordSafeTimed<Map<ByteArrayWrapper, byte[]>>(){

        @Override
        protected Map<ByteArrayWrapper, byte[]> compute() {
            return Collections.synchronizedMap(ContainerUtil.newHashMap());
        }

        @Override
        protected int getMinutesToLive() {
            return MemoryPasswordSafe.this.getMinutesToLive();
        }
    };

    protected int getMinutesToLive() {
        return Registry.intValue((String)"passwordSafe.memorySafe.ttl");
    }

    @Override
    @NotNull
    protected byte[] key() {
        if (this.key.get() == null) {
            byte[] rnd = new byte[256];
            new SecureRandom().nextBytes(rnd);
            this.key.compareAndSet(null, EncryptionUtil.genKey(EncryptionUtil.hash(new byte[][]{rnd})));
        }
        byte[] byArray = this.key.get();
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/passwordSafe/impl/providers/memory/MemoryPasswordSafe", "key"));
        }
        return byArray;
    }

    @Override
    protected byte[] getEncryptedPassword(@NotNull byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/ide/passwordSafe/impl/providers/memory/MemoryPasswordSafe", "getEncryptedPassword"));
        }
        return this.database.get().get(new ByteArrayWrapper(key));
    }

    @Override
    protected void removeEncryptedPassword(byte[] key) {
        this.database.get().remove(new ByteArrayWrapper(key));
    }

    @Override
    protected void storeEncryptedPassword(byte[] key, byte[] encryptedPassword) {
        this.database.get().put(new ByteArrayWrapper(key), encryptedPassword);
    }

    public void clear() {
        this.database.get().clear();
    }
}

