/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginReplacement;
import com.intellij.ide.plugins.PluginStateListener;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class PluginInstaller {
    private static final Logger LOG = Logger.getInstance(PluginInstaller.class);
    public static final String UNKNOWN_HOST_MARKER = "__unknown_repository__";
    private static final Object ourLock = new Object();
    private static List<PluginStateListener> myStateListeners;

    private PluginInstaller() {
    }

    public static boolean prepareToInstall(List<PluginNode> pluginsToInstall, List<PluginId> allPlugins, PluginManagerMain.PluginEnabler pluginEnabler, @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/plugins/PluginInstaller", "prepareToInstall"));
        }
        PluginInstaller.updateUrls(pluginsToInstall, indicator);
        THashSet dependant = new THashSet();
        boolean install2 = PluginInstaller.prepareToInstall(pluginsToInstall, allPlugins, (Set<PluginNode>)dependant, pluginEnabler, indicator);
        for (PluginNode node : dependant) {
            if (pluginsToInstall.contains(node)) continue;
            pluginsToInstall.add(node);
        }
        return install2;
    }

    private static void updateUrls(List<PluginNode> pluginsToInstall, @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/plugins/PluginInstaller", "updateUrls"));
        }
        boolean unknownNodes = false;
        for (PluginNode node : pluginsToInstall) {
            if (node.getRepositoryName() != UNKNOWN_HOST_MARKER) continue;
            unknownNodes = true;
            break;
        }
        if (!unknownNodes) {
            return;
        }
        List hosts = ContainerUtil.newSmartList();
        ContainerUtil.addIfNotNull((Collection)hosts, (Object)ApplicationInfoEx.getInstanceEx().getBuiltinPluginsUrl());
        hosts.addAll(UpdateSettings.getInstance().getPluginHosts());
        HashMap allPlugins = ContainerUtil.newHashMap();
        for (String host : hosts) {
            try {
                List<IdeaPluginDescriptor> descriptors = RepositoryHelper.loadPlugins(host, indicator);
                for (IdeaPluginDescriptor descriptor2 : descriptors) {
                    allPlugins.put(descriptor2.getPluginId(), descriptor2);
                }
            }
            catch (IOException descriptors) {
            }
        }
        for (PluginNode node : pluginsToInstall) {
            if (node.getRepositoryName() != UNKNOWN_HOST_MARKER) continue;
            IdeaPluginDescriptor descriptor3 = (IdeaPluginDescriptor)allPlugins.get(node.getPluginId());
            if (descriptor3 != null) {
                node.setRepositoryName(((PluginNode)descriptor3).getRepositoryName());
                node.setDownloadUrl(((PluginNode)descriptor3).getDownloadUrl());
                continue;
            }
            node.setRepositoryName(null);
        }
    }

    private static boolean prepareToInstall(List<PluginNode> pluginsToInstall, List<PluginId> allPlugins, Set<PluginNode> installedDependant, PluginManagerMain.PluginEnabler pluginEnabler, @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/plugins/PluginInstaller", "prepareToInstall"));
        }
        SmartList pluginIds = new SmartList();
        for (PluginNode pluginNode : pluginsToInstall) {
            pluginIds.add(pluginNode.getPluginId());
        }
        boolean result2 = false;
        for (PluginNode pluginNode : pluginsToInstall) {
            indicator.setText(pluginNode.getName());
            try {
                result2 |= PluginInstaller.prepareToInstall(pluginNode, (List<PluginId>)pluginIds, allPlugins, installedDependant, pluginEnabler, indicator);
            }
            catch (IOException e2) {
                String title = IdeBundle.message((String)"title.plugin.error", (Object[])new Object[0]);
                Notifications.Bus.notify((Notification)new Notification(title, title, pluginNode.getName() + ": " + e2.getMessage(), NotificationType.ERROR));
                return false;
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean prepareToInstall(PluginNode pluginNode, List<PluginId> pluginIds, List<PluginId> allPlugins, Set<PluginNode> installedDependant, PluginManagerMain.PluginEnabler pluginEnabler, @NotNull ProgressIndicator indicator) throws IOException {
        PluginDownloader downloader;
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/plugins/PluginInstaller", "prepareToInstall"));
        }
        installedDependant.add(pluginNode);
        if (pluginNode.getDepends() != null && pluginNode.getDepends().size() > 0) {
            Object[] optionalDependentPluginIds = pluginNode.getOptionalDependentPluginIds();
            ArrayList<PluginNode> depends = new ArrayList<PluginNode>();
            ArrayList<PluginNode> optionalDeps = new ArrayList<PluginNode>();
            for (int i2 = 0; i2 < pluginNode.getDepends().size(); ++i2) {
                PluginId depPluginId = pluginNode.getDepends().get(i2);
                if (PluginManager.isPluginInstalled(depPluginId) || PluginManagerCore.isModuleDependency(depPluginId) || InstalledPluginsState.getInstance().wasInstalled(depPluginId) || pluginIds != null && pluginIds.contains(depPluginId)) continue;
                PluginNode depPlugin = new PluginNode(depPluginId);
                depPlugin.setSize("-1");
                depPlugin.setName(depPluginId.getIdString());
                if (!PluginInstaller.isPluginInRepo(depPluginId, allPlugins)) continue;
                if (ArrayUtil.indexOf((Object[])optionalDependentPluginIds, (Object)depPluginId) != -1) {
                    optionalDeps.add(depPlugin);
                    continue;
                }
                depends.add(depPlugin);
            }
            if (depends.size() > 0) {
                boolean[] proceed = new boolean[1];
                try {
                    GuiUtils.runOrInvokeAndWait(() -> {
                        String title = IdeBundle.message((String)"plugin.manager.dependencies.detected.title", (Object[])new Object[0]);
                        String deps = StringUtil.join((Collection)depends, node -> node.getName(), (String)", ");
                        String message2 = IdeBundle.message((String)"plugin.manager.dependencies.detected.message", (Object[])new Object[]{depends.size(), deps});
                        proceed[0] = Messages.showYesNoDialog((String)message2, (String)title, (Icon)Messages.getWarningIcon()) == 0;
                    });
                }
                catch (Exception e2) {
                    return false;
                }
                if (!proceed[0] || !PluginInstaller.prepareToInstall(depends, allPlugins, installedDependant, pluginEnabler, indicator)) {
                    return false;
                }
            }
            if (optionalDeps.size() > 0) {
                boolean[] proceed = new boolean[1];
                try {
                    GuiUtils.runOrInvokeAndWait(() -> {
                        String title = IdeBundle.message((String)"plugin.manager.dependencies.detected.title", (Object[])new Object[0]);
                        String deps = StringUtil.join((Collection)optionalDeps, node -> node.getName(), (String)", ");
                        String message2 = IdeBundle.message((String)"plugin.manager.optional.dependencies.detected.message", (Object[])new Object[]{optionalDeps.size(), deps});
                        proceed[0] = Messages.showYesNoDialog((String)message2, (String)title, (Icon)Messages.getWarningIcon()) == 0;
                    });
                }
                catch (Exception e3) {
                    return false;
                }
                if (proceed[0] && !PluginInstaller.prepareToInstall(optionalDeps, allPlugins, installedDependant, pluginEnabler, indicator)) {
                    return false;
                }
            }
        }
        Ref toDisable = Ref.create(null);
        Optional replacement = StreamEx.of((Object[])PluginReplacement.EP_NAME.getExtensions()).findFirst(r2 -> r2.getNewPluginId().equals(pluginNode.getPluginId().getIdString()));
        if (replacement.isPresent()) {
            PluginReplacement pluginReplacement = (PluginReplacement)replacement.get();
            IdeaPluginDescriptor oldPlugin = PluginManager.getPlugin(pluginReplacement.getOldPluginDescriptor().getPluginId());
            if (oldPlugin == null) {
                LOG.warn("Plugin with id '" + pluginReplacement.getOldPluginDescriptor().getPluginId() + "' not found");
            } else if (!pluginEnabler.isDisabled(oldPlugin.getPluginId())) {
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    String title = IdeBundle.message((String)"plugin.manager.obsolete.plugins.detected.title", (Object[])new Object[0]);
                    String message2 = pluginReplacement.getReplacementMessage(oldPlugin, (IdeaPluginDescriptor)pluginNode);
                    if (Messages.showYesNoDialog((String)message2, (String)title, (Icon)Messages.getWarningIcon()) == 0) {
                        toDisable.set((Object)oldPlugin);
                    }
                });
            }
        }
        if ((downloader = PluginDownloader.createDownloader(pluginNode, pluginNode.getRepositoryName(), null)).prepareToInstall(indicator)) {
            Object object = ourLock;
            synchronized (object) {
                downloader.install();
            }
            pluginNode.setStatus(5);
            if (!toDisable.isNull()) {
                pluginEnabler.disablePlugins(Collections.singleton(toDisable.get()));
            }
        } else {
            return false;
        }
        return true;
    }

    private static boolean isPluginInRepo(PluginId depPluginId, List<PluginId> allPlugins) {
        return allPlugins.contains(depPluginId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepareToUninstall(PluginId pluginId) throws IOException {
        Object object = ourLock;
        synchronized (object) {
            if (PluginManager.isPluginInstalled(pluginId)) {
                IdeaPluginDescriptor pluginDescriptor = PluginManager.getPlugin(pluginId);
                if (pluginDescriptor != null) {
                    StartupActionScriptManager.DeleteCommand deleteOld = new StartupActionScriptManager.DeleteCommand(pluginDescriptor.getPath());
                    StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)deleteOld);
                    PluginInstaller.fireState(pluginDescriptor, false);
                } else {
                    PluginManagerMain.LOG.error("Plugin not found: " + pluginId);
                }
            }
        }
    }

    public static void install(@NotNull File fromFile, @NotNull String pluginName, boolean deleteFromFile, @NotNull IdeaPluginDescriptor descriptor2) throws IOException {
        if (fromFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromFile", "com/intellij/ide/plugins/PluginInstaller", "install"));
        }
        if (pluginName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginName", "com/intellij/ide/plugins/PluginInstaller", "install"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/plugins/PluginInstaller", "install"));
        }
        if (fromFile.getName().endsWith(".jar")) {
            StartupActionScriptManager.CopyCommand copyPlugin = new StartupActionScriptManager.CopyCommand(fromFile, new File(PathManager.getPluginsPath() + File.separator + fromFile.getName()));
            StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)copyPlugin);
        } else {
            String unzipPath = ZipUtil.isZipContainsFolder((File)fromFile) ? PathManager.getPluginsPath() : PathManager.getPluginsPath() + File.separator + pluginName;
            StartupActionScriptManager.UnzipCommand unzip = new StartupActionScriptManager.UnzipCommand(fromFile, new File(unzipPath));
            StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)unzip);
        }
        if (deleteFromFile) {
            StartupActionScriptManager.DeleteCommand deleteTemp = new StartupActionScriptManager.DeleteCommand(fromFile);
            StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)deleteTemp);
        }
        PluginInstaller.fireState(descriptor2, true);
    }

    public static void addStateListener(@NotNull PluginStateListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ide/plugins/PluginInstaller", "addStateListener"));
        }
        if (myStateListeners == null) {
            myStateListeners = new ArrayList<PluginStateListener>();
        }
        myStateListeners.add(listener2);
    }

    public static void removeStateListener(@NotNull PluginStateListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ide/plugins/PluginInstaller", "removeStateListener"));
        }
        if (myStateListeners != null) {
            myStateListeners.remove(listener2);
        }
    }

    private static void fireState(@NotNull IdeaPluginDescriptor descriptor2, boolean install2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/plugins/PluginInstaller", "fireState"));
        }
        if (myStateListeners != null) {
            UIUtil.invokeLaterIfNeeded(() -> {
                if (descriptor2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/plugins/PluginInstaller", "lambda$fireState$6"));
                }
                for (PluginStateListener listener2 : myStateListeners) {
                    if (install2) {
                        listener2.install(descriptor2);
                        continue;
                    }
                    listener2.uninstall(descriptor2);
                }
            });
        }
    }
}

