/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.InstalledPluginsTableModel;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RatesPanel;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.text.DecimalFormat;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class PluginsTableRenderer
extends DefaultTableCellRenderer {
    private static final InstalledPluginsState ourState = InstalledPluginsState.getInstance();
    protected SimpleColoredComponent myName;
    private JLabel myStatus;
    private RatesPanel myRating;
    private JLabel myDownloads;
    private JLabel myLastUpdated;
    private JPanel myPanel;
    private SimpleColoredComponent myCategory;
    private JPanel myRightPanel;
    private JPanel myBottomPanel;
    private JPanel myInfoPanel;
    protected final IdeaPluginDescriptor myPluginDescriptor;
    private final boolean myPluginsView;

    public PluginsTableRenderer(IdeaPluginDescriptor pluginDescriptor, boolean showFullInfo) {
        this.myPluginDescriptor = pluginDescriptor;
        this.$$$setupUI$$$();
        this.myPluginsView = !showFullInfo;
        Font smallFont = SystemInfo.isMac ? UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.MINI) : UIUtil.getLabelFont().deriveFont(Math.max(UISettings.getInstance().getFontSize() - JBUI.scale((int)3), JBUI.scaleFontSize((float)10.0f)));
        this.myName.setFont(UIUtil.getLabelFont().deriveFont(UISettings.getInstance().getFontSize()));
        this.myStatus.setFont(smallFont);
        this.myCategory.setFont(smallFont);
        this.myDownloads.setFont(smallFont);
        this.myStatus.setText("");
        this.myLastUpdated.setFont(smallFont);
        if (this.myPluginsView || pluginDescriptor.getDownloads() == null || !(pluginDescriptor instanceof PluginNode)) {
            this.myPanel.remove(this.myRightPanel);
        }
        if (this.myPluginsView) {
            this.myInfoPanel.remove(this.myBottomPanel);
        }
        this.myPanel.setBorder(UIUtil.isJreHiDPI((Component)this.myPanel) ? new EmptyBorder(4, 3, 4, 3) : new EmptyBorder(2, 3, 2, 3));
    }

    private void createUIComponents() {
        this.myRating = new RatesPanel();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
        if (this.myPluginDescriptor != null) {
            PluginId pluginId;
            IdeaPluginDescriptor installed;
            String downloads;
            String vendor;
            String category;
            Couple colors = UIUtil.getCellColors((JTable)table2, (boolean)isSelected, (int)row, (int)column);
            Color fg = (Color)colors.getFirst();
            Color background = (Color)colors.getSecond();
            Color grayedFg = isSelected ? fg : new JBColor((Color)Gray._130, (Color)Gray._120);
            this.myPanel.setBackground(background);
            this.myName.setForeground(fg);
            this.myCategory.setForeground(grayedFg);
            this.myStatus.setForeground(grayedFg);
            this.myLastUpdated.setForeground(grayedFg);
            this.myDownloads.setForeground(grayedFg);
            this.myName.clear();
            this.myName.setOpaque(false);
            this.myCategory.clear();
            this.myCategory.setOpaque(false);
            String pluginName = this.myPluginDescriptor.getName() + "  ";
            Object query = table2.getClientProperty("SEARCH_QUERY");
            SimpleTextAttributes attr = new SimpleTextAttributes(UIUtil.getListBackground((boolean)isSelected), UIUtil.getListForeground((boolean)isSelected), (Color)JBColor.RED, 0);
            MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + query), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
            if (query instanceof String) {
                SpeedSearchUtil.appendColoredFragmentForMatcher((String)pluginName, (SimpleColoredComponent)this.myName, (SimpleTextAttributes)attr, (Matcher)matcher, (Color)UIUtil.getTableBackground((boolean)isSelected), (boolean)true);
            } else {
                this.myName.append(pluginName);
            }
            String string2 = category = this.myPluginDescriptor.getCategory() == null ? null : StringUtil.toUpperCase((String)this.myPluginDescriptor.getCategory());
            if (category != null) {
                if (query instanceof String) {
                    SpeedSearchUtil.appendColoredFragmentForMatcher((String)category, (SimpleColoredComponent)this.myCategory, (SimpleTextAttributes)attr, (Matcher)matcher, (Color)UIUtil.getTableBackground((boolean)isSelected), (boolean)true);
                } else {
                    this.myCategory.append(category);
                }
            } else if (!this.myPluginsView) {
                this.myCategory.append("N/A");
            }
            this.myStatus.setIcon(AllIcons.Nodes.Plugin);
            if (this.myPluginDescriptor.isBundled()) {
                this.myCategory.append(" [Bundled]");
                this.myStatus.setIcon(AllIcons.Nodes.PluginJB);
            }
            if ((vendor = this.myPluginDescriptor.getVendor()) != null && StringUtil.containsIgnoreCase((String)vendor, (String)"jetbrains")) {
                this.myStatus.setIcon(AllIcons.Nodes.PluginJB);
            }
            if ((downloads = this.myPluginDescriptor.getDownloads()) != null && this.myPluginDescriptor instanceof PluginNode) {
                if (downloads.length() > 3) {
                    downloads = new DecimalFormat("#,###").format(Integer.parseInt(downloads));
                }
                this.myDownloads.setText(downloads);
                this.myRating.setRate(((PluginNode)this.myPluginDescriptor).getRating());
                this.myLastUpdated.setText(DateFormatUtil.formatBetweenDates((long)((PluginNode)this.myPluginDescriptor).getDate(), (long)System.currentTimeMillis()));
            }
            if ((installed = PluginManager.getPlugin(pluginId = this.myPluginDescriptor.getPluginId())) != null && ((IdeaPluginDescriptorImpl)installed).isDeleted()) {
                this.myStatus.setIcon(AllIcons.Nodes.PluginRestart);
                if (!isSelected) {
                    this.myName.setForeground(FileStatus.DELETED.getColor());
                }
                this.myPanel.setToolTipText(IdeBundle.message((String)"plugin.manager.uninstalled.tooltip", (Object[])new Object[0]));
            } else if (ourState.wasInstalled(pluginId)) {
                this.myStatus.setIcon(AllIcons.Nodes.PluginRestart);
                if (!isSelected) {
                    this.myName.setForeground(FileStatus.ADDED.getColor());
                }
                this.myPanel.setToolTipText(IdeBundle.message((String)"plugin.manager.installed.tooltip", (Object[])new Object[0]));
            } else if (ourState.wasUpdated(pluginId)) {
                this.myStatus.setIcon(AllIcons.Nodes.PluginRestart);
                if (!isSelected) {
                    this.myName.setForeground(FileStatus.ADDED.getColor());
                }
                this.myPanel.setToolTipText(IdeBundle.message((String)"plugin.manager.updated.tooltip", (Object[])new Object[0]));
            } else if (ourState.hasNewerVersion(pluginId)) {
                this.myStatus.setIcon(AllIcons.Nodes.Pluginobsolete);
                if (!isSelected) {
                    this.myName.setForeground(FileStatus.MODIFIED.getColor());
                }
                if (!this.myPluginsView && installed != null) {
                    this.myPanel.setToolTipText(IdeBundle.message((String)"plugin.manager.new.version.tooltip", (Object[])new Object[]{installed.getVersion()}));
                } else {
                    this.myPanel.setToolTipText(IdeBundle.message((String)"plugin.manager.update.available.tooltip", (Object[])new Object[0]));
                }
            } else if (PluginsTableRenderer.isIncompatible(this.myPluginDescriptor, table2.getModel())) {
                if (!isSelected) {
                    this.myName.setForeground((Color)JBColor.RED);
                }
                this.myPanel.setToolTipText(PluginsTableRenderer.whyIncompatible(this.myPluginDescriptor, table2.getModel()));
            } else if (!this.myPluginDescriptor.isEnabled() && this.myPluginsView) {
                this.myStatus.setIcon(IconLoader.getDisabledIcon((Icon)this.myStatus.getIcon()));
            }
        }
        return this.myPanel;
    }

    private static boolean isIncompatible(IdeaPluginDescriptor descriptor2, TableModel model2) {
        return PluginManagerCore.isIncompatible(descriptor2) || model2 instanceof InstalledPluginsTableModel && ((InstalledPluginsTableModel)model2).hasProblematicDependencies(descriptor2.getPluginId());
    }

    private static String whyIncompatible(IdeaPluginDescriptor descriptor2, TableModel model2) {
        InstalledPluginsTableModel installedModel;
        Set<PluginId> required;
        if (model2 instanceof InstalledPluginsTableModel && (required = (installedModel = (InstalledPluginsTableModel)model2).getRequiredPlugins(descriptor2.getPluginId())) != null && required.size() > 0) {
            StringBuilder sb2 = new StringBuilder();
            if (!installedModel.isLoaded(descriptor2.getPluginId())) {
                sb2.append(IdeBundle.message((String)"plugin.manager.incompatible.not.loaded.tooltip", (Object[])new Object[0])).append('\n');
            }
            if (required.contains(PluginId.getId((String)"com.intellij.modules.ultimate"))) {
                sb2.append(IdeBundle.message((String)"plugin.manager.incompatible.ultimate.tooltip", (Object[])new Object[0]));
            } else {
                String deps = StringUtil.join(required, id -> {
                    IdeaPluginDescriptor plugin = PluginManager.getPlugin(id);
                    return plugin != null ? plugin.getName() : id.getIdString();
                }, (String)", ");
                sb2.append(IdeBundle.message((String)"plugin.manager.incompatible.deps.tooltip", (Object[])new Object[]{required.size(), deps}));
            }
            return sb2.toString();
        }
        return IdeBundle.message((String)"plugin.manager.incompatible.tooltip", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        SimpleColoredComponent simpleColoredComponent;
        SimpleColoredComponent simpleColoredComponent2;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.createUIComponents();
        this.myPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.setOpaque(false);
        jPanel4.add((Component)jPanel5, "West");
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 3, 0, 6), null, 0, 0, null, null));
        JBLabel jBLabel = new JBLabel();
        this.myStatus = jBLabel;
        jBLabel.setText("Status");
        jPanel5.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myInfoPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel3.setOpaque(false);
        jPanel4.add((Component)jPanel3, "Center");
        this.myBottomPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setOpaque(false);
        jPanel3.add((Component)jPanel2, "South");
        this.myCategory = simpleColoredComponent2 = new SimpleColoredComponent();
        jPanel2.add((Component)simpleColoredComponent2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.setOpaque(false);
        jPanel3.add((Component)jPanel6, "North");
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0), null, 0, 0, null, null));
        this.myName = simpleColoredComponent = new SimpleColoredComponent();
        jPanel6.add((Component)simpleColoredComponent, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myRightPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setOpaque(false);
        jPanel4.add((Component)jPanel, "East");
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3), null, 0, 0, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.myLastUpdated = jBLabel2;
        jBLabel2.setText("Last Updated");
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 2, 4, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.setOpaque(false);
        jPanel.add((Component)jPanel7, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        RatesPanel ratesPanel = this.myRating;
        ratesPanel.setOpaque(false);
        jPanel7.add((Component)ratesPanel, new GridConstraints(0, 2, 1, 1, 0, 0, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel7.add((Component)spacer3, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.myDownloads = jBLabel3;
        jBLabel3.setText("Downloads");
        jPanel7.add((Component)jBLabel3, new GridConstraints(0, 1, 1, 1, 4, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

