/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.cl;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginClassLoader
extends UrlClassLoader {
    private final ClassLoader[] myParents;
    private final PluginId myPluginId;
    private final String myPluginVersion;
    private final List<String> myLibDirectories;

    public PluginClassLoader(@NotNull List<URL> urls, @NotNull ClassLoader[] parents, PluginId pluginId, String version, File pluginRoot) {
        if (urls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "com/intellij/ide/plugins/cl/PluginClassLoader", "<init>"));
        }
        if (parents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parents", "com/intellij/ide/plugins/cl/PluginClassLoader", "<init>"));
        }
        super(PluginClassLoader.build().urls(urls).allowLock().useCache());
        this.myParents = parents;
        this.myPluginId = pluginId;
        this.myPluginVersion = version;
        this.myLibDirectories = ContainerUtil.newSmartList();
        File libDir = new File(pluginRoot, "lib");
        if (libDir.exists()) {
            this.myLibDirectories.add(libDir.getAbsolutePath());
        }
    }

    public Class loadClass(@NotNull String name, boolean resolve2) throws ClassNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/plugins/cl/PluginClassLoader", "loadClass"));
        }
        Class c2 = this.tryLoadingClass(name, resolve2, null);
        if (c2 == null) {
            throw new ClassNotFoundException(name + " " + (Object)((Object)this));
        }
        return c2;
    }

    @Nullable
    private Class tryLoadingClass(@NotNull String name, boolean resolve2, @Nullable Set<ClassLoader> visited) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/plugins/cl/PluginClassLoader", "tryLoadingClass"));
        }
        Class c2 = this.loadClassInsideSelf(name);
        if (c2 == null) {
            c2 = this.loadClassFromParents(name, visited);
        }
        if (c2 != null) {
            if (resolve2) {
                this.resolveClass(c2);
            }
            return c2;
        }
        return null;
    }

    @Nullable
    private Class loadClassFromParents(String name, Set<ClassLoader> visited) {
        for (ClassLoader parent : this.myParents) {
            if (visited == null) {
                visited = ContainerUtilRt.newHashSet((Object[])new ClassLoader[]{this});
            }
            if (!visited.add((ClassLoader)parent)) continue;
            if (parent instanceof PluginClassLoader) {
                Class c2 = ((PluginClassLoader)((Object)parent)).tryLoadingClass(name, false, visited);
                if (c2 == null) continue;
                return c2;
            }
            try {
                return parent.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private synchronized Class loadClassInsideSelf(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/plugins/cl/PluginClassLoader", "loadClassInsideSelf"));
        }
        Class c2 = this.findLoadedClass(name);
        if (c2 != null) {
            return c2;
        }
        try {
            c2 = this._findClass(name);
        }
        catch (IncompatibleClassChangeError e2) {
            throw new PluginException("While loading class " + name + ": " + e2.getMessage(), (Throwable)e2, this.myPluginId);
        }
        catch (UnsupportedClassVersionError e3) {
            throw new PluginException("While loading class " + name + ": " + e3.getMessage(), (Throwable)e3, this.myPluginId);
        }
        if (c2 != null) {
            PluginManagerCore.addPluginClass(this.myPluginId);
        }
        return c2;
    }

    public URL findResource(String name) {
        URL resource = this.findResourceImpl(name);
        if (resource != null) {
            return resource;
        }
        for (ClassLoader parent : this.myParents) {
            URL parentResource = PluginClassLoader.fetchResource(parent, name);
            if (parentResource == null) continue;
            return parentResource;
        }
        return null;
    }

    @Nullable
    public InputStream getResourceAsStream(String name) {
        InputStream stream = super.getResourceAsStream(name);
        if (stream != null) {
            return stream;
        }
        for (ClassLoader parent : this.myParents) {
            InputStream inputStream = parent.getResourceAsStream(name);
            if (inputStream == null) continue;
            return inputStream;
        }
        return null;
    }

    public Enumeration<URL> findResources(String name) throws IOException {
        Enumeration[] resources = new Enumeration[this.myParents.length + 1];
        resources[0] = super.findResources(name);
        for (int idx = 0; idx < this.myParents.length; ++idx) {
            resources[idx + 1] = PluginClassLoader.fetchResources(this.myParents[idx], name);
        }
        return new DeepEnumeration(resources);
    }

    public void addLibDirectories(@NotNull Collection<String> libDirectories) {
        if (libDirectories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libDirectories", "com/intellij/ide/plugins/cl/PluginClassLoader", "addLibDirectories"));
        }
        this.myLibDirectories.addAll(libDirectories);
    }

    protected String findLibrary(String libName) {
        if (!this.myLibDirectories.isEmpty()) {
            String libFileName = System.mapLibraryName(libName);
            ListIterator<String> i2 = this.myLibDirectories.listIterator(this.myLibDirectories.size());
            while (i2.hasPrevious()) {
                File libFile = new File(i2.previous(), libFileName);
                if (!libFile.exists()) continue;
                return libFile.getAbsolutePath();
            }
        }
        return null;
    }

    private static URL fetchResource(ClassLoader cl, String resourceName) {
        try {
            Method findResource = PluginClassLoader.getFindResourceMethod(cl.getClass(), "findResource");
            return findResource != null ? (URL)findResource.invoke((Object)cl, resourceName) : null;
        }
        catch (Exception e2) {
            Logger.getInstance(PluginClassLoader.class).error((Throwable)e2);
            return null;
        }
    }

    private static Enumeration<URL> fetchResources(ClassLoader cl, String resourceName) {
        try {
            Method findResources = PluginClassLoader.getFindResourceMethod(cl.getClass(), "findResources");
            Enumeration e2 = findResources == null ? null : (Enumeration)findResources.invoke((Object)cl, resourceName);
            return e2;
        }
        catch (Exception e3) {
            Logger.getInstance(PluginClassLoader.class).error((Throwable)e3);
            return null;
        }
    }

    private static Method getFindResourceMethod(Class<?> clClass, String methodName) {
        try {
            Method declaredMethod = clClass.getDeclaredMethod(methodName, String.class);
            declaredMethod.setAccessible(true);
            return declaredMethod;
        }
        catch (NoSuchMethodException e2) {
            Class<?> superclass = clClass.getSuperclass();
            if (superclass == null || superclass.equals(Object.class)) {
                return null;
            }
            return PluginClassLoader.getFindResourceMethod(superclass, methodName);
        }
    }

    public PluginId getPluginId() {
        return this.myPluginId;
    }

    public String toString() {
        return "PluginClassLoader[" + this.myPluginId + ", " + this.myPluginVersion + "]";
    }

    private static class DeepEnumeration
    implements Enumeration<URL> {
        private final Enumeration<URL>[] myEnumerations;
        private int myIndex = 0;

        public DeepEnumeration(Enumeration<URL>[] enumerations) {
            this.myEnumerations = enumerations;
        }

        @Override
        public boolean hasMoreElements() {
            while (this.myIndex < this.myEnumerations.length) {
                Enumeration<URL> e2 = this.myEnumerations[this.myIndex];
                if (e2 != null && e2.hasMoreElements()) {
                    return true;
                }
                ++this.myIndex;
            }
            return false;
        }

        @Override
        public URL nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            return this.myEnumerations[this.myIndex].nextElement();
        }
    }
}

