/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnmarkRootAction
extends MarkRootActionBase {
    @Override
    protected void doUpdate(@NotNull AnActionEvent e2, @Nullable Module module2, @NotNull MarkRootActionBase.RootsSelection selection) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/projectView/actions/UnmarkRootAction", "doUpdate"));
        }
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/intellij/ide/projectView/actions/UnmarkRootAction", "doUpdate"));
        }
        if (!Registry.is((String)"ide.hide.excluded.files") && !selection.mySelectedExcludeRoots.isEmpty() && selection.mySelectedDirectories.isEmpty() && selection.mySelectedRoots.isEmpty()) {
            e2.getPresentation().setEnabledAndVisible(true);
            e2.getPresentation().setText(LangBundle.message("mark.as.unmark.excluded", new Object[0]));
            return;
        }
        super.doUpdate(e2, module2, selection);
        String text2 = this.getActionText(e2, module2, selection);
        if (text2 != null) {
            e2.getPresentation().setText(text2);
        }
    }

    @Nullable
    protected String getActionText(@NotNull AnActionEvent e2, @Nullable Module module2, @NotNull MarkRootActionBase.RootsSelection selection) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/projectView/actions/UnmarkRootAction", "getActionText"));
        }
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/intellij/ide/projectView/actions/UnmarkRootAction", "getActionText"));
        }
        Set<ModuleSourceRootEditHandler<?>> selectedRootHandlers = UnmarkRootAction.getHandlersForSelectedRoots(selection);
        if (!selectedRootHandlers.isEmpty()) {
            if (selectedRootHandlers.size() == 1) {
                ModuleSourceRootEditHandler<?> handler2 = selectedRootHandlers.iterator().next();
                return LangBundle.message("mark.as.unmark", StringUtil.pluralize((String)handler2.getFullRootTypeName(), (int)selection.mySelectedRoots.size()));
            }
            return LangBundle.message("mark.as.unmark.several", new Object[0]);
        }
        return null;
    }

    @NotNull
    private static Set<ModuleSourceRootEditHandler<?>> getHandlersForSelectedRoots(@NotNull MarkRootActionBase.RootsSelection selection) {
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/intellij/ide/projectView/actions/UnmarkRootAction", "getHandlersForSelectedRoots"));
        }
        HashSet selectedRootHandlers = new HashSet();
        for (SourceFolder root : selection.mySelectedRoots) {
            ContainerUtil.addIfNotNull((Collection)selectedRootHandlers, ModuleSourceRootEditHandler.getEditHandler(root.getRootType()));
        }
        HashSet hashSet = selectedRootHandlers;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/actions/UnmarkRootAction", "getHandlersForSelectedRoots"));
        }
        return hashSet;
    }

    @Override
    protected boolean isEnabled(@NotNull MarkRootActionBase.RootsSelection selection, @NotNull Module module2) {
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/intellij/ide/projectView/actions/UnmarkRootAction", "isEnabled"));
        }
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ide/projectView/actions/UnmarkRootAction", "isEnabled"));
        }
        return selection.mySelectedDirectories.isEmpty() && !UnmarkRootAction.getHandlersForSelectedRoots(selection).isEmpty();
    }

    @Override
    protected void modifyRoots(@NotNull VirtualFile file2, @NotNull ContentEntry entry) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/projectView/actions/UnmarkRootAction", "modifyRoots"));
        }
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/ide/projectView/actions/UnmarkRootAction", "modifyRoots"));
        }
        for (ExcludeFolder excludeFolder : entry.getExcludeFolders()) {
            if (!file2.equals(excludeFolder.getFile())) continue;
            entry.removeExcludeFolder(excludeFolder);
            break;
        }
    }
}

