/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.impl.ProjectPaneSelectInTarget;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewSettings;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPSIPane;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.ProjectViewProjectNode;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDirectory;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ProjectViewPane
extends AbstractProjectViewPSIPane {
    @NonNls
    public static final String ID = "ProjectPane";
    public static final String SHOW_EXCLUDED_FILES_OPTION = "show-excluded-files";
    private boolean myShowExcludedFiles = true;

    public ProjectViewPane(Project project2) {
        super(project2);
    }

    @Override
    public String getTitle() {
        return IdeBundle.message((String)"title.project", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/ProjectViewPane", "getId"));
        }
        return ID;
    }

    @Override
    public Icon getIcon() {
        return AllIcons.General.ProjectTab;
    }

    @Override
    public SelectInTarget createSelectInTarget() {
        return new ProjectPaneSelectInTarget(this.myProject);
    }

    @Override
    protected AbstractTreeUpdater createTreeUpdater(AbstractTreeBuilder treeBuilder) {
        return new ProjectViewTreeUpdater(treeBuilder);
    }

    @Override
    protected ProjectAbstractTreeStructureBase createStructure() {
        return new ProjectViewPaneTreeStructure();
    }

    @Override
    protected ProjectViewTree createTree(DefaultTreeModel treeModel) {
        return new ProjectViewTree(this.myProject, treeModel){

            public String toString() {
                return ProjectViewPane.this.getTitle() + " " + super.toString();
            }

            public void setFont(Font font) {
                if (Registry.is((String)"bigger.font.in.project.view")) {
                    font = font.deriveFont((float)font.getSize() + 1.0f);
                }
                super.setFont(font);
            }

            @Override
            public DefaultMutableTreeNode getSelectedNode() {
                return ProjectViewPane.this.getSelectedNode();
            }
        };
    }

    @NotNull
    public String getComponentName() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/ProjectViewPane", "getComponentName"));
        }
        return ID;
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        String showExcludedOption = JDOMExternalizerUtil.readField((Element)element, (String)SHOW_EXCLUDED_FILES_OPTION);
        this.myShowExcludedFiles = showExcludedOption == null || Boolean.parseBoolean(showExcludedOption);
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        if (!this.myShowExcludedFiles) {
            JDOMExternalizerUtil.writeField((Element)element, (String)SHOW_EXCLUDED_FILES_OPTION, (String)String.valueOf(false));
        }
    }

    @Override
    public void addToolbarActions(DefaultActionGroup actionGroup) {
        actionGroup.addAction((AnAction)new ShowExcludedFilesAction()).setAsSecondary(true);
    }

    @Override
    public int getWeight() {
        return 0;
    }

    private final class ShowExcludedFilesAction
    extends ToggleAction
    implements DumbAware {
        private ShowExcludedFilesAction() {
            super(IdeBundle.message((String)"action.show.excluded.files", (Object[])new Object[0]), IdeBundle.message((String)"action.show.hide.excluded.files", (Object[])new Object[0]), null);
        }

        public boolean isSelected(AnActionEvent event) {
            return ProjectViewPane.this.myShowExcludedFiles;
        }

        public void setSelected(AnActionEvent event, boolean flag) {
            if (ProjectViewPane.this.myShowExcludedFiles != flag) {
                ProjectViewPane.this.myShowExcludedFiles = flag;
                ProjectViewPane.this.updateFromRoot(true);
            }
        }

        public void update(AnActionEvent e2) {
            super.update(e2);
            Presentation presentation = e2.getPresentation();
            ProjectView projectView = ProjectView.getInstance(ProjectViewPane.this.myProject);
            presentation.setEnabledAndVisible(projectView.getCurrentProjectViewPane() == ProjectViewPane.this);
        }
    }

    private class ProjectViewPaneTreeStructure
    extends ProjectTreeStructure
    implements ProjectViewSettings {
        public ProjectViewPaneTreeStructure() {
            super(ProjectViewPane.this.myProject, ProjectViewPane.ID);
        }

        @Override
        protected AbstractTreeNode createRoot(Project project2, ViewSettings settings) {
            return new ProjectViewProjectNode(project2, settings);
        }

        @Override
        public boolean isShowExcludedFiles() {
            return ProjectViewPane.this.myShowExcludedFiles;
        }

        public boolean isToBuildChildrenInBackground(Object element) {
            return Registry.is((String)"ide.projectView.ProjectViewPaneTreeStructure.BuildChildrenInBackground");
        }
    }

    private final class ProjectViewTreeUpdater
    extends AbstractTreeUpdater {
        private ProjectViewTreeUpdater(AbstractTreeBuilder treeBuilder) {
            super(treeBuilder);
        }

        public boolean addSubtreeToUpdateByElement(Object element) {
            if (element instanceof PsiDirectory && !ProjectViewPane.this.myProject.isDisposed()) {
                boolean addedOk;
                PsiDirectory dirToUpdateFrom;
                PsiDirectory dir = (PsiDirectory)element;
                ProjectTreeStructure treeStructure = (ProjectTreeStructure)ProjectViewPane.this.myTreeStructure;
                if (!treeStructure.isFlattenPackages() && treeStructure.isHideEmptyMiddlePackages() && !DumbService.isDumb((Project)ProjectViewPane.this.myProject)) {
                    for (dirToUpdateFrom = dir; dirToUpdateFrom != null && ProjectViewDirectoryHelper.getInstance(ProjectViewPane.this.myProject).isEmptyMiddleDirectory(dirToUpdateFrom, true); dirToUpdateFrom = dirToUpdateFrom.getParentDirectory()) {
                    }
                }
                while (!(addedOk = super.addSubtreeToUpdateByElement(dirToUpdateFrom == null ? ProjectViewPane.this.myTreeStructure.getRootElement() : dirToUpdateFrom)) && dirToUpdateFrom != null) {
                    dirToUpdateFrom = dirToUpdateFrom.getParentDirectory();
                }
                return addedOk;
            }
            return super.addSubtreeToUpdateByElement(element);
        }
    }
}

