/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.intellij.util.Function;
import java.awt.Color;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectViewTree
extends DnDAwareTree {
    private final Project myProject;

    protected ProjectViewTree(Project project2, TreeModel model2) {
        super(model2);
        this.myProject = project2;
        NodeRenderer cellRenderer = new NodeRenderer(){

            protected void doPaint(Graphics2D g2) {
                super.doPaint(g2);
                this.setOpaque(false);
            }
        };
        cellRenderer.setOpaque(false);
        cellRenderer.setIconOpaque(false);
        this.setCellRenderer((TreeCellRenderer)cellRenderer);
        cellRenderer.setTransparentIconBackground(true);
        HintUpdateSupply.installDataContextHintUpdateSupply((JComponent)((Object)this));
    }

    public abstract DefaultMutableTreeNode getSelectedNode();

    public Project getProject() {
        return this.myProject;
    }

    public final int getToggleClickCount() {
        NodeDescriptor descriptor2;
        Object object;
        DefaultMutableTreeNode selectedNode = this.getSelectedNode();
        if (selectedNode != null && (object = selectedNode.getUserObject()) instanceof NodeDescriptor && !(descriptor2 = (NodeDescriptor)object).expandOnDoubleClick()) {
            return -1;
        }
        return super.getToggleClickCount();
    }

    public boolean isFileColorsEnabled() {
        return ProjectViewTree.isFileColorsEnabledFor((JTree)((Object)this));
    }

    public static boolean isFileColorsEnabledFor(JTree tree2) {
        boolean enabled = FileColorManagerImpl._isEnabled() && FileColorManagerImpl._isEnabledForProjectView();
        boolean opaque = tree2.isOpaque();
        if (enabled && opaque) {
            tree2.setOpaque(false);
        } else if (!enabled && !opaque) {
            tree2.setOpaque(true);
        }
        return enabled;
    }

    @Nullable
    public Color getFileColorFor(Object object) {
        return ProjectViewTree.getColorForObject(object, this.getProject(), object1 -> {
            Object element;
            if (object1 instanceof AbstractTreeNode && (element = ((AbstractTreeNode)object1).getValue()) instanceof PsiElement) {
                return (PsiElement)element;
            }
            return null;
        });
    }

    @Nullable
    public static <T> Color getColorForObject(T object, Project project2, @NotNull Function<T, PsiElement> converter) {
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "com/intellij/ide/projectView/impl/ProjectViewTree", "getColorForObject"));
        }
        Color color = null;
        PsiElement psi = (PsiElement)converter.fun(object);
        if (psi != null) {
            if (!psi.isValid()) {
                return null;
            }
            VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)psi);
            if (file2 != null) {
                color = FileColorManager.getInstance((Project)project2).getFileColor(file2);
            } else if (psi instanceof PsiDirectory) {
                color = FileColorManager.getInstance((Project)project2).getFileColor(((PsiDirectory)psi).getVirtualFile());
            } else if (psi instanceof PsiDirectoryContainer) {
                PsiDirectory[] dirs;
                for (PsiDirectory dir : dirs = ((PsiDirectoryContainer)psi).getDirectories()) {
                    Color c2 = FileColorManager.getInstance((Project)project2).getFileColor(dir.getVirtualFile());
                    if (c2 != null && color == null) {
                        color = c2;
                        continue;
                    }
                    if (c2 == null) continue;
                    color = null;
                    break;
                }
            }
        }
        return color == null ? null : ColorUtil.softer(color);
    }
}

