/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scopeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.util.scopeChooser.ScopeChooserConfigurable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;

public class EditScopesAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.ide.scopeView.EditScopesAction");

    public EditScopesAction() {
        this.getTemplatePresentation().setIcon(AllIcons.Ide.LocalScope);
    }

    public void actionPerformed(AnActionEvent e2) {
        DataContext dataContext = e2.getDataContext();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        LOG.assertTrue(project2 != null);
        String scopeName = ProjectView.getInstance(project2).getCurrentProjectViewPane().getSubId();
        LOG.assertTrue(scopeName != null);
        ScopeChooserConfigurable scopeChooserConfigurable = new ScopeChooserConfigurable(project2);
        ShowSettingsUtil.getInstance().editConfigurable(project2, (Configurable)scopeChooserConfigurable, () -> scopeChooserConfigurable.selectNodeInTree(scopeName));
    }

    public void update(AnActionEvent e2) {
        String scopeName;
        AbstractProjectViewPane projectViewPane;
        super.update(e2);
        e2.getPresentation().setEnabled(false);
        DataContext dataContext = e2.getDataContext();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 != null && (projectViewPane = ProjectView.getInstance(project2).getCurrentProjectViewPane()) != null && (scopeName = projectViewPane.getSubId()) != null) {
            e2.getPresentation().setEnabled(true);
        }
    }
}

