/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.ide.scratch.LRUPopupBuilder;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.idea.ActionsBundle;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.PerFileMappings;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScratchFileActions {
    private static int ourCurrentBuffer = 0;

    @Nullable
    private static Language detectLanguageFromSelection(Project project2, Editor editor, PsiFile file2, String text2) {
        Language language = ScratchFileActions.getLanguageFromCaret(project2, editor, file2);
        FileType fileType = LanguageUtil.getLanguageFileType((Language)language);
        if (fileType == null) {
            return null;
        }
        CharSequence fileSnippet = text2.subSequence(0, Math.min(text2.length(), 10240));
        PsiFileFactory fileFactory = PsiFileFactory.getInstance((Project)file2.getProject());
        PsiFile psiFile = fileFactory.createFileFromText("a." + fileType.getDefaultExtension(), language, fileSnippet);
        PsiErrorElement firstError = (PsiErrorElement)SyntaxTraverser.psiTraverser((PsiElement)psiFile).traverse().filter(PsiErrorElement.class).first();
        return firstError == null || firstError.getParent() != psiFile ? language : null;
    }

    static void doCreateNewScratch(@NotNull Project project2, boolean buffer, @NotNull Language language, @NotNull String text2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/ScratchFileActions", "doCreateNewScratch"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/ide/scratch/ScratchFileActions", "doCreateNewScratch"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ide/scratch/ScratchFileActions", "doCreateNewScratch"));
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("scratch");
        LanguageFileType fileType = language.getAssociatedFileType();
        String ext = buffer || fileType == null ? "" : fileType.getDefaultExtension();
        String fileName = buffer ? "buffer" + ScratchFileActions.nextBufferIndex() : "scratch";
        ScratchFileService.Option option = buffer ? ScratchFileService.Option.create_if_missing : ScratchFileService.Option.create_new_always;
        VirtualFile f2 = ScratchRootType.getInstance().createScratchFile(project2, PathUtil.makeFileName((String)fileName, (String)ext), language, text2, option);
        if (f2 != null) {
            FileEditorManager.getInstance((Project)project2).openFile(f2, true);
        }
    }

    private static int nextBufferIndex() {
        ourCurrentBuffer = ourCurrentBuffer % Registry.intValue((String)"ide.scratch.buffers") + 1;
        return ourCurrentBuffer;
    }

    @Nullable
    static String getSelectionText(@Nullable Editor editor) {
        if (editor == null) {
            return null;
        }
        return editor.getSelectionModel().getSelectedText();
    }

    @Nullable
    static Language getLanguageFromCaret(@NotNull Project project2, @Nullable Editor editor, @Nullable PsiFile psiFile) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/ScratchFileActions", "getLanguageFromCaret"));
        }
        if (editor == null || psiFile == null) {
            return null;
        }
        Caret caret = editor.getCaretModel().getPrimaryCaret();
        int offset = caret.getOffset();
        PsiElement element = InjectedLanguageManager.getInstance((Project)project2).findInjectedElementAt(psiFile, offset);
        PsiFile file2 = element != null ? element.getContainingFile() : psiFile;
        return file2.getLanguage();
    }

    public static class LanguageAction
    extends DumbAwareAction {
        public void update(AnActionEvent e2) {
            Project project2 = e2.getProject();
            JBIterable files2 = JBIterable.of((Object[])((Object[])e2.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)));
            if (project2 == null || files2.isEmpty()) {
                e2.getPresentation().setEnabledAndVisible(false);
                return;
            }
            Condition<VirtualFile> isScratch = this.fileFilter(project2);
            if (!files2.filter(Conditions.not(isScratch)).isEmpty()) {
                e2.getPresentation().setEnabledAndVisible(false);
                return;
            }
            Set languages = (Set)files2.filter(isScratch).transform(this.fileLanguage(project2)).filter(Conditions.notNull()).addAllTo((Collection)ContainerUtil.newLinkedHashSet());
            String langName = languages.size() == 1 ? ((Language)languages.iterator().next()).getDisplayName() : languages.size() + " different";
            e2.getPresentation().setText(String.format("Change %s (%s)...", this.getLanguageTerm(), langName));
            e2.getPresentation().setEnabledAndVisible(true);
        }

        @NotNull
        protected String getLanguageTerm() {
            if ("Language" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchFileActions$LanguageAction", "getLanguageTerm"));
            }
            return "Language";
        }

        public void actionPerformed(AnActionEvent e2) {
            Project project2 = e2.getProject();
            JBIterable files2 = JBIterable.of((Object[])((Object[])e2.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).filter(this.fileFilter(project2));
            if (project2 == null || files2.isEmpty()) {
                return;
            }
            this.actionPerformedImpl(e2, project2, (JBIterable<VirtualFile>)files2);
        }

        @NotNull
        protected Condition<VirtualFile> fileFilter(Project project2) {
            Condition condition = file2 -> ScratchRootType.getInstance().containsFile((VirtualFile)file2);
            if (condition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchFileActions$LanguageAction", "fileFilter"));
            }
            return condition;
        }

        @NotNull
        protected Function<VirtualFile, Language> fileLanguage(final Project project2) {
            Function<VirtualFile, Language> function2 = new Function<VirtualFile, Language>(){
                ScratchFileService fileService = ScratchFileService.getInstance();

                public Language fun(VirtualFile file2) {
                    Language lang = (Language)this.fileService.getScratchesMapping().getMapping(file2);
                    return lang != null ? lang : LanguageUtil.getLanguageForPsi((Project)project2, (VirtualFile)file2);
                }
            };
            if (function2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchFileActions$LanguageAction", "fileLanguage"));
            }
            return function2;
        }

        protected void actionPerformedImpl(AnActionEvent e2, Project project2, JBIterable<VirtualFile> files2) {
            ScratchFileService fileService = ScratchFileService.getInstance();
            PerFileMappings<Language> mapping = fileService.getScratchesMapping();
            LRUPopupBuilder.forFileLanguages(project2, files2, mapping).showInBestPositionFor(e2.getDataContext());
        }
    }

    public static class NewBufferAction
    extends DumbAwareAction {
        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/scratch/ScratchFileActions$NewBufferAction", "update"));
            }
            boolean enabled = e2.getProject() != null && Registry.is((String)"ide.scratch.enabled") && Registry.intValue((String)"ide.scratch.buffers") > 0;
            e2.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/scratch/ScratchFileActions$NewBufferAction", "actionPerformed"));
            }
            Project project2 = e2.getProject();
            if (project2 == null) {
                return;
            }
            PsiFile file2 = (PsiFile)e2.getData(CommonDataKeys.PSI_FILE);
            Editor editor = (Editor)e2.getData(CommonDataKeys.EDITOR);
            String text2 = StringUtil.notNullize((String)ScratchFileActions.getSelectionText(editor));
            Language language = text2.isEmpty() ? null : ScratchFileActions.detectLanguageFromSelection(project2, editor, file2, text2);
            ScratchFileActions.doCreateNewScratch(project2, true, (Language)ObjectUtils.notNull((Object)language, (Object)StdLanguages.TEXT), text2);
        }
    }

    public static class NewFileAction
    extends DumbAwareAction {
        private static final Icon ICON = LayeredIcon.create((Icon)AllIcons.FileTypes.Text, (Icon)AllIcons.Actions.Scratch);
        private static final String ACTION_ID = "NewScratchFile";
        private static final String SMALLER_IDE_CONTAINER_GROUP = "PlatformOpenProjectGroup";
        private final String myActionText;

        public NewFileAction() {
            Presentation templatePresentation = this.getTemplatePresentation();
            templatePresentation.setIcon(ICON);
            this.myActionText = (this.isIdeWithoutNewSubmenu() ? "New " : "") + ActionsBundle.actionText((String)ACTION_ID);
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/scratch/ScratchFileActions$NewFileAction", "update"));
            }
            this.getTemplatePresentation().setText(this.myActionText);
            String place = e2.getPlace();
            boolean enabled = e2.getProject() != null && Registry.is((String)"ide.scratch.enabled") && (ActionPlaces.isMainMenuOrActionSearch((String)place) || ActionPlaces.isPopupPlace((String)place));
            Presentation presentation = e2.getPresentation();
            presentation.setEnabledAndVisible(enabled);
            this.updatePresentationTextAndIcon(e2, presentation);
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            String text2;
            if (e2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/scratch/ScratchFileActions$NewFileAction", "actionPerformed"));
            }
            Project project2 = e2.getProject();
            if (project2 == null) {
                return;
            }
            PsiFile file2 = (PsiFile)e2.getData(CommonDataKeys.PSI_FILE);
            Editor editor = (Editor)e2.getData(CommonDataKeys.EDITOR);
            String eventText = ScratchFileActions.getSelectionText(editor);
            if (eventText == null) {
                eventText = (String)e2.getData(PlatformDataKeys.PREDEFINED_TEXT);
            }
            Language language = (text2 = StringUtil.notNullize((String)eventText)).isEmpty() ? null : ScratchFileActions.detectLanguageFromSelection(project2, editor, file2, text2);
            Consumer consumer2 = language1 -> ScratchFileActions.doCreateNewScratch(project2, false, language1, text2);
            if (language != null) {
                consumer2.consume((Object)language);
            } else {
                LRUPopupBuilder.forFileLanguages(project2, null, (Consumer<Language>)consumer2).showCenteredInCurrentWindow(project2);
            }
        }

        private void updatePresentationTextAndIcon(@NotNull AnActionEvent e2, @NotNull Presentation presentation) {
            if (e2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/scratch/ScratchFileActions$NewFileAction", "updatePresentationTextAndIcon"));
            }
            if (presentation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/ide/scratch/ScratchFileActions$NewFileAction", "updatePresentationTextAndIcon"));
            }
            presentation.setText(this.myActionText);
            presentation.setIcon(ICON);
            if ("MainMenu".equals(e2.getPlace()) && this.isIdeWithoutNewSubmenu()) {
                presentation.setIcon(null);
            }
        }

        private boolean isIdeWithoutNewSubmenu() {
            AnAction group = ActionManager.getInstance().getActionOrStub(SMALLER_IDE_CONTAINER_GROUP);
            return group instanceof DefaultActionGroup && ContainerUtil.find((Object[])((DefaultActionGroup)group).getChildActionsOrStubs(), action2 -> action2 == this || action2 instanceof ActionStub && ((ActionStub)action2).getId().equals(ACTION_ID)) != null;
        }
    }
}

