/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.icons.AllIcons;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.UIBundle;
import com.intellij.util.ObjectUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScratchRootType
extends RootType {
    @NotNull
    public static ScratchRootType getInstance() {
        ScratchRootType scratchRootType = ScratchRootType.findByClass(ScratchRootType.class);
        if (scratchRootType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchRootType", "getInstance"));
        }
        return scratchRootType;
    }

    ScratchRootType() {
        super("scratches", "Scratches");
    }

    @Override
    public Language substituteLanguage(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/ScratchRootType", "substituteLanguage"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/ScratchRootType", "substituteLanguage"));
        }
        return (Language)ScratchFileService.getInstance().getScratchesMapping().getMapping(file2);
    }

    @Override
    @Nullable
    public Icon substituteIcon(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/ScratchRootType", "substituteIcon"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/ScratchRootType", "substituteIcon"));
        }
        Icon icon = (Icon)ObjectUtils.chooseNotNull((Object)super.substituteIcon(project2, file2), (Object)ScratchFileType.INSTANCE.getIcon());
        return LayeredIcon.create((Icon)icon, (Icon)AllIcons.Actions.Scratch);
    }

    @Nullable
    public VirtualFile createScratchFile(Project project2, String fileName, Language language, String text2) {
        return this.createScratchFile(project2, fileName, language, text2, ScratchFileService.Option.create_new_always);
    }

    @Nullable
    public VirtualFile createScratchFile(Project project2, final String fileName, final Language language, final String text2, final ScratchFileService.Option option) {
        RunResult result2 = new WriteCommandAction<VirtualFile>(project2, UIBundle.message((String)"file.chooser.create.new.scratch.file.command.name", (Object[])new Object[0]), new PsiFile[0]){

            protected boolean isGlobalUndoAction() {
                return true;
            }

            protected boolean shouldRecordActionForActiveDocument() {
                return false;
            }

            protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
                return UndoConfirmationPolicy.REQUEST_CONFIRMATION;
            }

            protected void run(@NotNull Result<VirtualFile> result2) throws Throwable {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ide/scratch/ScratchRootType$1", "run"));
                }
                ScratchFileService fileService = ScratchFileService.getInstance();
                VirtualFile file2 = fileService.findFile(ScratchRootType.this, fileName, option);
                VfsUtil.saveText((VirtualFile)file2, (String)text2);
                fileService.getScratchesMapping().setMapping(file2, (Object)language);
                result2.setResult((Object)file2);
            }
        }.execute();
        if (result2.hasException()) {
            Messages.showMessageDialog((String)UIBundle.message((String)"create.new.file.could.not.create.file.error.message", (Object[])new Object[]{fileName}), (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return null;
        }
        return (VirtualFile)result2.getResultObject();
    }
}

