/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.scratch.ScratchFileType;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScratchUtil {
    private ScratchUtil() {
    }

    public static boolean isScratch(@Nullable VirtualFile file2) {
        return file2 != null && file2.getFileType() == ScratchFileType.INSTANCE;
    }

    public static void updateFileExtension(@NotNull Project project2, @Nullable VirtualFile file2) throws IOException {
        LanguageFileType actual;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/ScratchUtil", "updateFileExtension"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (CommandProcessor.getInstance().getCurrentCommand() == null) {
            throw new AssertionError((Object)"command required");
        }
        if (file2 == null) {
            return;
        }
        Language language = LanguageUtil.getLanguageForPsi((Project)project2, (VirtualFile)file2);
        FileType expected = ScratchUtil.getFileTypeFromName(file2);
        LanguageFileType languageFileType = actual = language == null ? null : language.getAssociatedFileType();
        if (expected == actual || actual == null) {
            return;
        }
        String ext = actual.getDefaultExtension();
        if (StringUtil.isEmpty((String)ext)) {
            return;
        }
        String newName = PathUtil.makeFileName((String)file2.getNameWithoutExtension(), (String)ext);
        VirtualFile parent = file2.getParent();
        newName = parent != null && parent.findChild(newName) != null ? PathUtil.makeFileName((String)file2.getName(), (String)ext) : newName;
        file2.rename(ScratchUtil.class, newName);
    }

    public static boolean hasMatchingExtension(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/ScratchUtil", "hasMatchingExtension"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/ScratchUtil", "hasMatchingExtension"));
        }
        FileType expected = ScratchUtil.getFileTypeFromName(file2);
        Language language = LanguageUtil.getLanguageForPsi((Project)project2, (VirtualFile)file2);
        LanguageFileType actual = language == null ? null : language.getAssociatedFileType();
        return expected == actual && actual != null;
    }

    @Nullable
    public static FileType getFileTypeFromName(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/ScratchUtil", "getFileTypeFromName"));
        }
        String extension = file2.getExtension();
        return extension == null ? null : FileTypeManager.getInstance().getFileTypeByExtension(extension);
    }
}

