/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.impl;

import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.local.FileWatcher;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.project.ProjectKt;
import com.intellij.ui.GuiUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.messages.MessageBusConnection;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

public class StartupManagerImpl
extends StartupManagerEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.startup.impl.StartupManagerImpl");
    private final List<Runnable> myPreStartupActivities = Collections.synchronizedList(new LinkedList());
    private final List<Runnable> myStartupActivities = Collections.synchronizedList(new LinkedList());
    private final List<Runnable> myDumbAwarePostStartupActivities = Collections.synchronizedList(new LinkedList());
    private final List<Runnable> myNotDumbAwarePostStartupActivities = Collections.synchronizedList(new LinkedList());
    private boolean myPostStartupActivitiesPassed;
    private volatile boolean myPreStartupActivitiesPassed;
    private volatile boolean myStartupActivitiesRunning;
    private volatile boolean myStartupActivitiesPassed;
    private final Project myProject;
    private boolean myInitialRefreshScheduled;

    public StartupManagerImpl(Project project2) {
        this.myProject = project2;
    }

    @Override
    public void registerPreStartupActivity(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/ide/startup/impl/StartupManagerImpl", "registerPreStartupActivity"));
        }
        LOG.assertTrue(!this.myPreStartupActivitiesPassed, (Object)"Registering pre startup activity that will never be run");
        this.myPreStartupActivities.add(runnable2);
    }

    public void registerStartupActivity(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/ide/startup/impl/StartupManagerImpl", "registerStartupActivity"));
        }
        LOG.assertTrue(!this.myStartupActivitiesPassed, (Object)"Registering startup activity that will never be run");
        this.myStartupActivities.add(runnable2);
    }

    public synchronized void registerPostStartupActivity(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/ide/startup/impl/StartupManagerImpl", "registerPostStartupActivity"));
        }
        LOG.assertTrue(!this.myPostStartupActivitiesPassed, (Object)("Registering post-startup activity that will never be run: disposed=" + this.myProject.isDisposed() + "; open=" + this.myProject.isOpen() + "; passed=" + this.myStartupActivitiesPassed));
        (DumbService.isDumbAware((Object)runnable2) ? this.myDumbAwarePostStartupActivities : this.myNotDumbAwarePostStartupActivities).add(runnable2);
    }

    @Override
    public boolean startupActivityRunning() {
        return this.myStartupActivitiesRunning;
    }

    @Override
    public boolean startupActivityPassed() {
        return this.myStartupActivitiesPassed;
    }

    @Override
    public synchronized boolean postStartupActivityPassed() {
        return this.myPostStartupActivitiesPassed;
    }

    public void runStartupActivities() {
        ApplicationManager.getApplication().runReadAction(() -> {
            AccessToken token = HeavyProcessLatch.INSTANCE.processStarted("Running Startup Activities");
            try {
                StartupManagerImpl.runActivities(this.myPreStartupActivities);
                StartupManagerImpl startupManagerImpl = this;
                synchronized (startupManagerImpl) {
                    this.myPreStartupActivitiesPassed = true;
                    this.myStartupActivitiesRunning = true;
                }
                StartupManagerImpl.runActivities(this.myStartupActivities);
                startupManagerImpl = this;
                synchronized (startupManagerImpl) {
                    this.myStartupActivitiesRunning = false;
                    this.myStartupActivitiesPassed = true;
                }
            }
            finally {
                token.finish();
            }
        });
    }

    public void runPostStartupActivitiesFromExtensions() {
        StartupActivity[] extensions;
        for (StartupActivity extension : extensions = (StartupActivity[])Extensions.getExtensions((ExtensionPointName)StartupActivity.POST_STARTUP_ACTIVITY)) {
            Runnable runnable2 = () -> {
                if (!this.myProject.isDisposed()) {
                    long start2 = System.currentTimeMillis();
                    extension.runActivity(this.myProject);
                    long duration = System.currentTimeMillis() - start2;
                    if (duration > 200L) {
                        LOG.info(extension.getClass().getSimpleName() + " run in " + duration);
                    }
                }
            };
            if (extension instanceof DumbAware) {
                StartupManagerImpl.runActivity(runnable2);
                continue;
            }
            this.queueSmartModeActivity(runnable2);
        }
    }

    private void queueSmartModeActivity(Runnable activity) {
        DumbService.getInstance((Project)this.myProject).runWhenSmart(() -> StartupManagerImpl.runActivity(activity));
    }

    public void runPostStartupActivities() {
        if (this.postStartupActivityPassed()) {
            return;
        }
        final Application app = ApplicationManager.getApplication();
        if (!app.isHeadlessEnvironment()) {
            this.checkFsSanity();
            this.checkProjectRoots();
        }
        StartupManagerImpl.runActivities(this.myDumbAwarePostStartupActivities);
        final DumbService dumbService = DumbService.getInstance((Project)this.myProject);
        dumbService.runWhenSmart(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List dumbUnaware;
                app.assertIsDispatchThread();
                StartupManagerImpl.runActivities(StartupManagerImpl.this.myDumbAwarePostStartupActivities);
                while (!(dumbUnaware = StartupManagerImpl.this.takeDumbUnawareStartupActivities()).isEmpty()) {
                    dumbUnaware.forEach(x$0 -> StartupManagerImpl.this.queueSmartModeActivity(x$0));
                }
                if (dumbService.isDumb()) {
                    dumbService.runWhenSmart((Runnable)this);
                } else {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        StartupManagerImpl.this.myPostStartupActivitiesPassed = true;
                    }
                }
            }
        });
    }

    private synchronized List<Runnable> takeDumbUnawareStartupActivities() {
        ArrayList<Runnable> result2 = new ArrayList<Runnable>(this.myNotDumbAwarePostStartupActivities);
        this.myNotDumbAwarePostStartupActivities.clear();
        return result2;
    }

    public void scheduleInitialVfsRefresh() {
        GuiUtils.invokeLaterIfNeeded(() -> {
            if (this.myProject.isDisposed() || this.myInitialRefreshScheduled) {
                return;
            }
            this.myInitialRefreshScheduled = true;
            ((ProjectRootManagerImpl)ProjectRootManager.getInstance((Project)this.myProject)).markRootsForRefresh();
            Application app = ApplicationManager.getApplication();
            if (!app.isCommandLine()) {
                final long sessionId = VirtualFileManager.getInstance().asyncRefresh(null);
                final MessageBusConnection connection = app.getMessageBus().connect();
                connection.subscribe(ProjectLifecycleListener.TOPIC, (Object)new ProjectLifecycleListener(){

                    public void afterProjectClosed(@NotNull Project project2) {
                        if (project2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/startup/impl/StartupManagerImpl$2", "afterProjectClosed"));
                        }
                        if (project2 != StartupManagerImpl.this.myProject) {
                            return;
                        }
                        RefreshQueue.getInstance().cancelSession(sessionId);
                        connection.disconnect();
                    }
                });
            } else {
                VirtualFileManager.getInstance().syncRefresh();
            }
        }, (ModalityState)ModalityState.defaultModalityState());
    }

    private void checkFsSanity() {
        try {
            String path = this.myProject.getProjectFilePath();
            if (path == null || FileUtil.isAncestor((String)PathManager.getConfigPath(), (String)path, (boolean)true)) {
                return;
            }
            if (ProjectKt.isDirectoryBased(this.myProject)) {
                path = PathUtil.getParentPath((String)path);
            }
            boolean expected = SystemInfo.isFileSystemCaseSensitive;
            boolean actual = FileUtil.isFileSystemCaseSensitive((String)path);
            LOG.info(path + " case-sensitivity: expected=" + expected + " actual=" + actual);
            if (actual != expected) {
                int prefix = expected ? 1 : 0;
                String title = ApplicationBundle.message((String)"fs.case.sensitivity.mismatch.title", (Object[])new Object[0]);
                String text2 = ApplicationBundle.message((String)"fs.case.sensitivity.mismatch.message", (Object[])new Object[]{prefix});
                Notifications.Bus.notify((Notification)new Notification("System Messages", title, text2, NotificationType.WARNING, NotificationListener.URL_OPENING_LISTENER), (Project)this.myProject);
            }
        }
        catch (FileNotFoundException e2) {
            LOG.warn((Throwable)e2);
        }
    }

    private void checkProjectRoots() {
        VirtualFile[] roots = ProjectRootManager.getInstance((Project)this.myProject).getContentRoots();
        if (roots.length == 0) {
            return;
        }
        LocalFileSystem fs = LocalFileSystem.getInstance();
        if (!(fs instanceof LocalFileSystemImpl)) {
            return;
        }
        FileWatcher watcher = ((LocalFileSystemImpl)fs).getFileWatcher();
        if (!watcher.isOperational()) {
            return;
        }
        PooledThreadExecutor.INSTANCE.submit(() -> {
            LOG.debug("FW/roots waiting started");
            while (true) {
                if (this.myProject.isDisposed()) {
                    return;
                }
                if (!watcher.isSettingRoots()) break;
                TimeoutUtil.sleep((long)10L);
            }
            LOG.debug("FW/roots waiting finished");
            Collection<String> manualWatchRoots = watcher.getManualWatchRoots();
            if (!manualWatchRoots.isEmpty()) {
                SmartList nonWatched = new SmartList();
                for (VirtualFile root : roots) {
                    if (!(root.getFileSystem() instanceof LocalFileSystem)) continue;
                    String rootPath = root.getPath();
                    for (String manualWatchRoot : manualWatchRoots) {
                        if (!FileUtil.isAncestor((String)manualWatchRoot, (String)rootPath, (boolean)false)) continue;
                        nonWatched.add(rootPath);
                    }
                }
                if (!nonWatched.isEmpty()) {
                    String message2 = ApplicationBundle.message((String)"watcher.non.watchable.project", (Object[])new Object[0]);
                    watcher.notifyOnFailure(message2, null);
                    LOG.info("unwatched roots: " + nonWatched);
                    LOG.info("manual watches: " + manualWatchRoots);
                }
            }
        });
    }

    public void startCacheUpdate() {
        if (this.myProject.isDisposed()) {
            return;
        }
        try {
            DumbServiceImpl dumbService = DumbServiceImpl.getInstance(this.myProject);
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                dumbService.queueTask(new DumbModeTask(){

                    public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/startup/impl/StartupManagerImpl$3", "performInDumbMode"));
                        }
                        StartupManagerImpl.this.scheduleInitialVfsRefresh();
                    }

                    public String toString() {
                        return "initial refresh";
                    }
                });
            }
        }
        catch (ProcessCanceledException e2) {
            throw e2;
        }
        catch (Throwable e3) {
            LOG.error(e3);
        }
    }

    private static void runActivities(@NotNull List<Runnable> activities) {
        if (activities == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activities", "com/intellij/ide/startup/impl/StartupManagerImpl", "runActivities"));
        }
        while (!activities.isEmpty()) {
            StartupManagerImpl.runActivity(activities.remove(0));
        }
    }

    private static void runActivity(Runnable runnable2) {
        ProgressManager.checkCanceled();
        try {
            runnable2.run();
        }
        catch (ProcessCanceledException e2) {
            throw e2;
        }
        catch (Throwable ex) {
            LOG.error(ex);
        }
    }

    public void runWhenProjectIsInitialized(@NotNull Runnable action2) {
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/ide/startup/impl/StartupManagerImpl", "runWhenProjectIsInitialized"));
        }
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            return;
        }
        Runnable runnable2 = () -> {
            if (action2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/ide/startup/impl/StartupManagerImpl", "lambda$runWhenProjectIsInitialized$5"));
            }
            if (this.myProject.isDisposed()) {
                return;
            }
            StartupManagerImpl startupManagerImpl = this;
            synchronized (startupManagerImpl) {
                boolean initialized;
                boolean bl = initialized = this.myProject.isInitialized() || this.myProject.isDefault() || application.isUnitTestMode() && this.myPostStartupActivitiesPassed;
                if (!initialized) {
                    this.registerPostStartupActivity(action2);
                    return;
                }
            }
            action2.run();
        };
        GuiUtils.invokeLaterIfNeeded((Runnable)runnable2, (ModalityState)ModalityState.defaultModalityState());
    }

    public synchronized void prepareForNextTest() {
        this.myPreStartupActivities.clear();
        this.myStartupActivities.clear();
        this.myDumbAwarePostStartupActivities.clear();
        this.myNotDumbAwarePostStartupActivities.clear();
    }

    public synchronized void checkCleared() {
        try {
            assert (this.myStartupActivities.isEmpty()) : "Activities: " + this.myStartupActivities;
            assert (this.myDumbAwarePostStartupActivities.isEmpty()) : "DumbAware Post Activities: " + this.myDumbAwarePostStartupActivities;
            assert (this.myNotDumbAwarePostStartupActivities.isEmpty()) : "Post Activities: " + this.myNotDumbAwarePostStartupActivities;
            assert (this.myPreStartupActivities.isEmpty()) : "Pre Activities: " + this.myPreStartupActivities;
        }
        finally {
            this.prepareForNextTest();
        }
    }
}

