/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl;

import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.util.Disposer;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class StructureViewComposite
implements StructureView {
    @NotNull
    private final StructureViewDescriptor[] myStructureViews;
    @NotNull
    private final StructureViewDescriptor mySelectedViewDescriptor;

    public StructureViewComposite(StructureViewDescriptor ... views) {
        if (views == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "views", "com/intellij/ide/structureView/impl/StructureViewComposite", "<init>"));
        }
        this.myStructureViews = views;
        for (StructureViewDescriptor descriptor2 : views) {
            Disposer.register((Disposable)this, (Disposable)descriptor2.structureView);
        }
        this.mySelectedViewDescriptor = views[0];
    }

    public StructureView getSelectedStructureView() {
        return this.mySelectedViewDescriptor.structureView;
    }

    public void setStructureView(int index, StructureViewDescriptor view2) {
        this.myStructureViews[index] = view2;
        Disposer.register((Disposable)this, (Disposable)view2.structureView);
    }

    public FileEditor getFileEditor() {
        return this.getSelectedStructureView().getFileEditor();
    }

    public boolean navigateToSelectedElement(boolean requestFocus2) {
        return this.getSelectedStructureView().navigateToSelectedElement(requestFocus2);
    }

    public JComponent getComponent() {
        return this.mySelectedViewDescriptor.structureView.getComponent();
    }

    public void dispose() {
    }

    public void centerSelectedRow() {
        this.getSelectedStructureView().centerSelectedRow();
    }

    public void restoreState() {
        for (StructureViewDescriptor descriptor2 : this.myStructureViews) {
            descriptor2.structureView.restoreState();
        }
    }

    public void storeState() {
        for (StructureViewDescriptor descriptor2 : this.myStructureViews) {
            descriptor2.structureView.storeState();
        }
    }

    @NotNull
    public StructureViewDescriptor[] getStructureViews() {
        if (this.myStructureViews == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/StructureViewComposite", "getStructureViews"));
        }
        return this.myStructureViews;
    }

    @NotNull
    public StructureViewModel getTreeModel() {
        StructureViewModel structureViewModel = this.getSelectedStructureView().getTreeModel();
        if (structureViewModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/StructureViewComposite", "getTreeModel"));
        }
        return structureViewModel;
    }

    public static class StructureViewDescriptor {
        public final String title;
        public final StructureView structureView;
        public final Icon icon;

        public StructureViewDescriptor(String title, @NotNull StructureView structureView, Icon icon) {
            if (structureView == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structureView", "com/intellij/ide/structureView/impl/StructureViewComposite$StructureViewDescriptor", "<init>"));
            }
            this.title = title;
            this.structureView = structureView;
            this.icon = icon;
        }
    }
}

