/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureViewElementWrapper<V extends PsiElement>
implements StructureViewTreeElement {
    private final StructureViewTreeElement myTreeElement;
    private final PsiFile myMainFile;

    public StructureViewElementWrapper(@NotNull StructureViewTreeElement treeElement, @NotNull PsiFile mainFile) {
        if (treeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeElement", "com/intellij/ide/structureView/impl/StructureViewElementWrapper", "<init>"));
        }
        if (mainFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainFile", "com/intellij/ide/structureView/impl/StructureViewElementWrapper", "<init>"));
        }
        this.myTreeElement = treeElement;
        this.myMainFile = mainFile;
    }

    public StructureViewTreeElement getWrappedElement() {
        return this.myTreeElement;
    }

    public V getValue() {
        return (V)((PsiElement)this.myTreeElement.getValue());
    }

    @NotNull
    public StructureViewTreeElement[] getChildren() {
        TreeElement[] baseChildren = this.myTreeElement.getChildren();
        ArrayList<StructureViewElementWrapper<V>> result2 = new ArrayList<StructureViewElementWrapper<V>>();
        for (TreeElement element : baseChildren) {
            StructureViewElementWrapper<V> wrapper = new StructureViewElementWrapper<V>((StructureViewTreeElement)element, this.myMainFile);
            result2.add(wrapper);
        }
        StructureViewTreeElement[] structureViewTreeElementArray = result2.toArray(new StructureViewTreeElement[result2.size()]);
        if (structureViewTreeElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/StructureViewElementWrapper", "getChildren"));
        }
        return structureViewTreeElementArray;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        ItemPresentation itemPresentation = this.myTreeElement.getPresentation();
        if (itemPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/StructureViewElementWrapper", "getPresentation"));
        }
        return itemPresentation;
    }

    public void navigate(boolean requestFocus2) {
        Navigatable navigatable = this.getNavigatableInTemplateLanguageFile();
        if (navigatable != null) {
            navigatable.navigate(requestFocus2);
        }
    }

    @Nullable
    private Navigatable getNavigatableInTemplateLanguageFile() {
        PsiElement element = (PsiElement)this.myTreeElement.getValue();
        if (element == null) {
            return null;
        }
        int offset = element.getTextRange().getStartOffset();
        Language dataLanguage = ((TemplateLanguageFileViewProvider)this.myMainFile.getViewProvider()).getTemplateDataLanguage();
        PsiFile dataFile = this.myMainFile.getViewProvider().getPsi(dataLanguage);
        if (dataFile == null) {
            return null;
        }
        for (PsiElement tlElement = dataFile.findElementAt(offset); tlElement != null && tlElement.getTextRange().getStartOffset() == offset; tlElement = tlElement.getParent()) {
            if (!(tlElement instanceof Navigatable)) continue;
            return (Navigatable)tlElement;
        }
        return null;
    }

    public boolean canNavigate() {
        return this.getNavigatableInTemplateLanguageFile() != null;
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }
}

