/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.xml;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.xml.XmlAttlistDecl;
import com.intellij.psi.xml.XmlAttributeDecl;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementDecl;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.PlatformIcons;
import com.intellij.xml.impl.dtd.XmlElementDescriptorImpl;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DtdFileTreeElement
extends PsiTreeElementBase<XmlFile> {
    public DtdFileTreeElement(XmlFile file2) {
        super(file2);
    }

    @Override
    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        List<StructureViewTreeElement> list2 = DtdFileTreeElement.collectElements((XmlElement)((XmlFile)this.getElement()).getDocument());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/xml/DtdFileTreeElement", "getChildrenBase"));
        }
        return list2;
    }

    static List<StructureViewTreeElement> collectElements(XmlElement element) {
        final ArrayList<StructureViewTreeElement> elements = new ArrayList<StructureViewTreeElement>();
        XmlUtil.processXmlElements(element, new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/structureView/impl/xml/DtdFileTreeElement$1", "execute"));
                }
                if (element instanceof XmlElementDecl || element instanceof XmlEntityDecl) {
                    elements.add(new DtdTreeElement((PsiNamedElement)element));
                }
                return true;
            }
        }, false);
        return elements;
    }

    public String getPresentableText() {
        return ((XmlFile)this.getElement()).getName();
    }

    private static class DtdTreeElement
    extends PsiTreeElementBase<PsiNamedElement> {
        @NonNls
        private static final String IMPLIED = "implied";
        @NonNls
        private static final String REQUIRED = "required";
        @NonNls
        private static final String FIXED = "fixed";
        @NonNls
        private static final String ID = "id";
        @NonNls
        private static final String IDREF = "idref";
        @NonNls
        private static final String ENUM = "enum";

        public DtdTreeElement(PsiNamedElement element) {
            super(element);
        }

        @Override
        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            List<StructureViewTreeElement> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/xml/DtdFileTreeElement$DtdTreeElement", "getChildrenBase"));
            }
            return list2;
        }

        public String getPresentableText() {
            PsiNamedElement namedElement = (PsiNamedElement)this.getElement();
            return namedElement != null ? namedElement.getName() : "";
        }

        @Override
        public Icon getIcon(boolean open2) {
            return PlatformIcons.XML_TAG_ICON;
        }

        @Override
        public String getLocationString() {
            XmlAttlistDecl[] attLists;
            XmlElement owner = (XmlElement)this.getElement();
            XmlAttlistDecl[] xmlAttlistDeclArray = attLists = owner instanceof XmlElementDecl ? XmlElementDescriptorImpl.getCachedAttributeDeclarations(owner) : XmlAttlistDecl.EMPTY_ARRAY;
            if (attLists.length > 0) {
                LinkedHashMap<String, XmlAttributeDecl> attrMap = null;
                String name = ((PsiNamedElement)this.getElement()).getName();
                for (XmlAttlistDecl a : attLists) {
                    String aname = a.getName();
                    if (!Comparing.equal((String)aname, (String)name)) continue;
                    if (attrMap == null) {
                        attrMap = new LinkedHashMap<String, XmlAttributeDecl>();
                    }
                    for (XmlAttributeDecl d2 : a.getAttributeDecls()) {
                        attrMap.put(d2.getName(), d2);
                    }
                }
                StringBuilder b2 = null;
                if (attrMap != null) {
                    for (Map.Entry e2 : attrMap.entrySet()) {
                        XmlAttributeValue value2;
                        if (b2 == null) {
                            b2 = new StringBuilder();
                        } else {
                            b2.append(", ");
                        }
                        b2.append((String)e2.getKey());
                        XmlAttributeDecl attributeDecl = (XmlAttributeDecl)e2.getValue();
                        String type = null;
                        if (attributeDecl.isIdAttribute()) {
                            type = ID;
                        } else if (attributeDecl.isIdRefAttribute()) {
                            type = IDREF;
                        } else if (attributeDecl.isEnumerated()) {
                            type = ENUM;
                        }
                        if (attributeDecl.isAttributeFixed()) {
                            type = type == null ? FIXED : type + " fixed";
                        } else if (attributeDecl.isAttributeRequired()) {
                            type = type == null ? REQUIRED : type + " required";
                        } else if (attributeDecl.isAttributeImplied()) {
                            type = type == null ? IMPLIED : type + " implied";
                        }
                        if (type != null) {
                            b2.append(':').append(type);
                        }
                        if ((value2 = attributeDecl.getDefaultValue()) == null) continue;
                        b2.append("=").append(value2);
                    }
                }
                if (b2 != null) {
                    return b2.toString();
                }
            }
            return super.getLocationString();
        }

        @Override
        public String toString() {
            String s2 = this.getLocationString();
            String name = ((PsiNamedElement)this.getElement()).getName();
            if (s2 == null || s2.length() == 0) {
                return name;
            }
            return name + " (" + s2 + ")";
        }
    }
}

