/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.todo.CustomChangelistTodoTreeStructure;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.TodoTreeStructure;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.checkin.TodoCheckinHandlerWorker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.search.TodoPattern;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;

public class CustomChangelistTodosTreeBuilder
extends TodoTreeBuilder {
    public static final TodoItem[] EMPTY_ITEMS = new TodoItem[0];
    private final Project myProject;
    private final String myTitle;
    private final MultiMap<PsiFile, TodoItem> myMap;
    private final Set<PsiFile> myIncludedFiles;
    private PsiTodoSearchHelper myPsiTodoSearchHelper;
    private final ChangeListManager myChangeListManager;

    public CustomChangelistTodosTreeBuilder(JTree tree2, DefaultTreeModel treeModel, Project project2, String title, List<TodoItem> list2) {
        super(tree2, treeModel, project2);
        this.myProject = project2;
        this.myTitle = title;
        this.myMap = new MultiMap();
        this.myIncludedFiles = new HashSet<PsiFile>();
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
        this.initMap(list2);
        this.initHelper();
    }

    private void initMap(List<TodoItem> list2) {
        this.buildMap(list2);
        this.myIncludedFiles.addAll(this.myMap.keySet());
    }

    private void buildMap(List<TodoItem> list2) {
        for (TodoItem todoItem : list2) {
            this.myMap.putValue((Object)todoItem.getFile(), (Object)todoItem);
        }
    }

    private void initHelper() {
        this.myPsiTodoSearchHelper = new PsiTodoSearchHelper(){

            @NotNull
            public PsiFile[] findFilesWithTodoItems() {
                ArrayList<Change> changes = new ArrayList<Change>();
                List changeLists = CustomChangelistTodosTreeBuilder.this.myChangeListManager.getChangeLists();
                HashMap<VirtualFile, Change> allChanges = new HashMap<VirtualFile, Change>();
                for (LocalChangeList changeList : changeLists) {
                    Collection currChanges = changeList.getChanges();
                    for (Change currChange : currChanges) {
                        if (currChange.getAfterRevision() == null || currChange.getAfterRevision().getFile().getVirtualFile() == null) continue;
                        allChanges.put(currChange.getAfterRevision().getFile().getVirtualFile(), currChange);
                    }
                }
                for (PsiFile next : CustomChangelistTodosTreeBuilder.this.myIncludedFiles) {
                    Change change = (Change)allChanges.get(next.getVirtualFile());
                    if (change == null) continue;
                    changes.add(change);
                }
                TodoCheckinHandlerWorker worker = new TodoCheckinHandlerWorker(CustomChangelistTodosTreeBuilder.this.myProject, changes, CustomChangelistTodosTreeBuilder.this.getTodoTreeStructure().getTodoFilter(), true);
                worker.execute();
                CustomChangelistTodosTreeBuilder.this.buildMap(worker.inOneList());
                Set files2 = CustomChangelistTodosTreeBuilder.this.myMap.keySet();
                PsiFile[] psiFileArray = files2.toArray(new PsiFile[files2.size()]);
                if (psiFileArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/todo/CustomChangelistTodosTreeBuilder$1", "findFilesWithTodoItems"));
                }
                return psiFileArray;
            }

            @NotNull
            public TodoItem[] findTodoItems(@NotNull PsiFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/todo/CustomChangelistTodosTreeBuilder$1", "findTodoItems"));
                }
                TodoItem[] todoItemArray = CustomChangelistTodosTreeBuilder.this.findPatternedTodoItems(file2, CustomChangelistTodosTreeBuilder.this.getTodoTreeStructure().getTodoFilter());
                if (todoItemArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/todo/CustomChangelistTodosTreeBuilder$1", "findTodoItems"));
                }
                return todoItemArray;
            }

            @NotNull
            public TodoItem[] findTodoItemsLight(@NotNull PsiFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/todo/CustomChangelistTodosTreeBuilder$1", "findTodoItemsLight"));
                }
                TodoItem[] todoItemArray = this.findTodoItems(file2);
                if (todoItemArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/todo/CustomChangelistTodosTreeBuilder$1", "findTodoItemsLight"));
                }
                return todoItemArray;
            }

            @NotNull
            public TodoItem[] findTodoItemsLight(@NotNull PsiFile file2, int startOffset, int endOffset) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/todo/CustomChangelistTodosTreeBuilder$1", "findTodoItemsLight"));
                }
                TodoItem[] todoItemArray = this.findTodoItems(file2, startOffset, endOffset);
                if (todoItemArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/todo/CustomChangelistTodosTreeBuilder$1", "findTodoItemsLight"));
                }
                return todoItemArray;
            }

            @NotNull
            public TodoItem[] findTodoItems(@NotNull PsiFile file2, int startOffset, int endOffset) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/todo/CustomChangelistTodosTreeBuilder$1", "findTodoItems"));
                }
                TodoItem[] todoItems = this.findTodoItems(file2);
                if (todoItems.length == 0) {
                    if (todoItems == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/todo/CustomChangelistTodosTreeBuilder$1", "findTodoItems"));
                    }
                    return todoItems;
                }
                TextRange textRange = new TextRange(startOffset, endOffset);
                ArrayList<TodoItem> result2 = new ArrayList<TodoItem>();
                for (TodoItem todoItem : todoItems) {
                    if (!todoItem.getTextRange().contains(textRange)) continue;
                    result2.add(todoItem);
                }
                TodoItem[] todoItemArray = result2.isEmpty() ? EMPTY_ITEMS : result2.toArray(new TodoItem[result2.size()]);
                if (todoItemArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/todo/CustomChangelistTodosTreeBuilder$1", "findTodoItems"));
                }
                return todoItemArray;
            }

            public int getTodoItemsCount(@NotNull PsiFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/todo/CustomChangelistTodosTreeBuilder$1", "getTodoItemsCount"));
                }
                return this.findTodoItems(file2).length;
            }

            public int getTodoItemsCount(@NotNull PsiFile file2, @NotNull TodoPattern pattern) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/todo/CustomChangelistTodosTreeBuilder$1", "getTodoItemsCount"));
                }
                if (pattern == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/todo/CustomChangelistTodosTreeBuilder$1", "getTodoItemsCount"));
                }
                TodoFilter filter2 = new TodoFilter();
                filter2.addTodoPattern(pattern);
                return CustomChangelistTodosTreeBuilder.this.findPatternedTodoItems(file2, filter2).length;
            }
        };
    }

    private TodoItem[] findPatternedTodoItems(PsiFile file2, TodoFilter todoFilter) {
        Collection todoItems;
        if (!this.myIncludedFiles.contains(file2)) {
            return EMPTY_ITEMS;
        }
        if (this.myDirtyFileSet.contains(file2.getVirtualFile())) {
            this.myMap.remove((Object)file2);
            Change change = this.myChangeListManager.getChange(file2.getVirtualFile());
            if (change != null) {
                TodoCheckinHandlerWorker worker = new TodoCheckinHandlerWorker(this.myProject, Collections.singletonList(change), todoFilter, true);
                worker.execute();
                List<TodoItem> todoItems2 = worker.inOneList();
                if (todoItems2 != null && !todoItems2.isEmpty()) {
                    for (TodoItem todoItem : todoItems2) {
                        this.myMap.putValue((Object)file2, (Object)todoItem);
                    }
                }
            }
        }
        return (todoItems = this.myMap.get((Object)file2)) == null || todoItems.isEmpty() ? EMPTY_ITEMS : todoItems.toArray(new TodoItem[todoItems.size()]);
    }

    @Override
    @NotNull
    protected TodoTreeStructure createTreeStructure() {
        CustomChangelistTodoTreeStructure customChangelistTodoTreeStructure = new CustomChangelistTodoTreeStructure(this.myProject, this.myPsiTodoSearchHelper);
        if (customChangelistTodoTreeStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/todo/CustomChangelistTodosTreeBuilder", "createTreeStructure"));
        }
        return customChangelistTodoTreeStructure;
    }

    @Override
    void rebuildCache() {
        this.myMap.clear();
        this.myFileTree.clear();
        this.myDirtyFileSet.clear();
        this.myFile2Highlighter.clear();
        TodoTreeStructure treeStructure = this.getTodoTreeStructure();
        PsiFile[] psiFiles = this.myPsiTodoSearchHelper.findFilesWithTodoItems();
        for (int i2 = 0; i2 < psiFiles.length; ++i2) {
            PsiFile psiFile = psiFiles[i2];
            if (this.myPsiTodoSearchHelper.getTodoItemsCount(psiFile) <= 0 || !treeStructure.accept(psiFile)) continue;
            this.myFileTree.add(psiFile.getVirtualFile());
        }
        treeStructure.validateCache();
    }
}

