/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.QuickChangeLookAndFeel;
import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ide.ui.ColorBlindness;
import com.intellij.ide.ui.ColorBlindnessPanel;
import com.intellij.ide.ui.LCDRenderingScope;
import com.intellij.ide.ui.LafComboBoxRenderer;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.FontComboBox;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import sun.swing.SwingUtilities2;

public class AppearanceConfigurable
extends BaseConfigurable
implements SearchableConfigurable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.ui.AppearanceConfigurable");
    private MyComponent myComponent = new MyComponent();

    private void initComponent() {
        if (this.myComponent == null) {
            this.myComponent = new MyComponent();
        }
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"title.appearance", (Object[])new Object[0]);
    }

    @NotNull
    public String getId() {
        String string2 = this.getHelpTopic();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/AppearanceConfigurable", "getId"));
        }
        return string2;
    }

    public JComponent createComponent() {
        UISettings settings = UISettings.getInstance();
        this.initComponent();
        this.myComponent.myFontSizeCombo.setModel(new DefaultComboBoxModel<String>(UIUtil.getStandardFontSizes()));
        this.myComponent.myPresentationModeFontSize.setModel(new DefaultComboBoxModel<String>(UIUtil.getStandardFontSizes()));
        this.myComponent.myFontSizeCombo.setEditable(true);
        this.myComponent.myPresentationModeFontSize.setEditable(true);
        this.myComponent.myLafComboBox.setModel(new DefaultComboBoxModel<UIManager.LookAndFeelInfo>(LafManager.getInstance().getInstalledLookAndFeels()));
        this.myComponent.myLafComboBox.setRenderer(new LafComboBoxRenderer());
        this.myComponent.myAntialiasingInIDE.setModel(new DefaultComboBoxModel<AntialiasingType>(AntialiasingType.values()));
        this.myComponent.myAntialiasingInEditor.setModel(new DefaultComboBoxModel<AntialiasingType>(AntialiasingType.values()));
        this.myComponent.myAntialiasingInIDE.setSelectedItem(settings.getIdeAAType());
        this.myComponent.myAntialiasingInEditor.setSelectedItem(settings.getEditorAAType());
        this.myComponent.myAntialiasingInIDE.setRenderer(new AAListCellRenderer(false));
        this.myComponent.myAntialiasingInEditor.setRenderer(new AAListCellRenderer(true));
        Hashtable<Integer, JLabel> delayDictionary = new Hashtable<Integer, JLabel>();
        ((Dictionary)delayDictionary).put(new Integer(0), new JLabel("0"));
        ((Dictionary)delayDictionary).put(new Integer(1200), new JLabel("1200"));
        this.myComponent.myInitialTooltipDelaySlider.setLabelTable(delayDictionary);
        UIUtil.setSliderIsFilled((JSlider)this.myComponent.myInitialTooltipDelaySlider, (boolean)Boolean.TRUE);
        this.myComponent.myInitialTooltipDelaySlider.setMinimum(0);
        this.myComponent.myInitialTooltipDelaySlider.setMaximum(1200);
        this.myComponent.myInitialTooltipDelaySlider.setPaintLabels(true);
        this.myComponent.myInitialTooltipDelaySlider.setPaintTicks(true);
        this.myComponent.myInitialTooltipDelaySlider.setPaintTrack(true);
        this.myComponent.myInitialTooltipDelaySlider.setMajorTickSpacing(1200);
        this.myComponent.myInitialTooltipDelaySlider.setMinorTickSpacing(100);
        this.myComponent.myEnableAlphaModeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                boolean state = AppearanceConfigurable.this.myComponent.myEnableAlphaModeCheckBox.isSelected();
                AppearanceConfigurable.this.myComponent.myAlphaModeDelayTextField.setEnabled(state);
                AppearanceConfigurable.this.myComponent.myAlphaModeRatioSlider.setEnabled(state);
            }
        });
        this.myComponent.myAlphaModeRatioSlider.setSize(100, 50);
        Hashtable<Integer, JLabel> dictionary = new Hashtable<Integer, JLabel>();
        ((Dictionary)dictionary).put(new Integer(0), new JLabel("0%"));
        ((Dictionary)dictionary).put(new Integer(50), new JLabel("50%"));
        ((Dictionary)dictionary).put(new Integer(100), new JLabel("100%"));
        this.myComponent.myAlphaModeRatioSlider.setLabelTable(dictionary);
        UIUtil.setSliderIsFilled((JSlider)this.myComponent.myAlphaModeRatioSlider, (boolean)Boolean.TRUE);
        this.myComponent.myAlphaModeRatioSlider.setPaintLabels(true);
        this.myComponent.myAlphaModeRatioSlider.setPaintTicks(true);
        this.myComponent.myAlphaModeRatioSlider.setPaintTrack(true);
        this.myComponent.myAlphaModeRatioSlider.setMajorTickSpacing(50);
        this.myComponent.myAlphaModeRatioSlider.setMinorTickSpacing(10);
        this.myComponent.myAlphaModeRatioSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
                AppearanceConfigurable.this.myComponent.myAlphaModeRatioSlider.setToolTipText(AppearanceConfigurable.this.myComponent.myAlphaModeRatioSlider.getValue() + "%");
            }
        });
        this.myComponent.myTransparencyPanel.setVisible(WindowManagerEx.getInstanceEx().isAlphaModeSupported());
        return this.myComponent.myPanel;
    }

    public void apply() {
        int tooltipDelay;
        UIManager.LookAndFeelInfo lafInfo;
        this.initComponent();
        UISettings settings = UISettings.getInstance();
        int _fontSize = AppearanceConfigurable.getIntValue(this.myComponent.myFontSizeCombo, settings.getFontSize());
        int _presentationFontSize = AppearanceConfigurable.getIntValue((JComboBox)this.myComponent.myPresentationModeFontSize, settings.getPresentationModeFontSize());
        boolean update2 = false;
        boolean shouldUpdateUI = false;
        String _fontFace = this.myComponent.myFontCombo.getFontName();
        LafManager lafManager = LafManager.getInstance();
        if (_fontSize != settings.getFontSize() || !Comparing.equal((String)settings.getFontFace(), (String)_fontFace)) {
            settings.setFontSize(_fontSize);
            settings.setFontFace(_fontFace);
            shouldUpdateUI = true;
            update2 = true;
        }
        if (_presentationFontSize != settings.getPresentationModeFontSize()) {
            settings.setPresentationModeFontSize(_presentationFontSize);
            shouldUpdateUI = true;
        }
        if (this.myComponent.myAntialiasingInIDE.getSelectedItem() != settings.getIdeAAType()) {
            settings.setIdeAAType((AntialiasingType)this.myComponent.myAntialiasingInIDE.getSelectedItem());
            for (Window w2 : Window.getWindows()) {
                for (JComponent c2 : UIUtil.uiTraverser((Component)w2).filter(JComponent.class)) {
                    c2.putClientProperty(SwingUtilities2.AA_TEXT_PROPERTY_KEY, AntialiasingType.getAAHintForSwingComponent());
                }
            }
            shouldUpdateUI = true;
        }
        if (this.myComponent.myAntialiasingInEditor.getSelectedItem() != settings.getEditorAAType()) {
            settings.setEditorAAType((AntialiasingType)this.myComponent.myAntialiasingInEditor.getSelectedItem());
            shouldUpdateUI = true;
        }
        settings.setAnimateWindows(this.myComponent.myAnimateWindowsCheckBox.isSelected());
        update2 |= settings.getShowToolWindowsNumbers() != this.myComponent.myWindowShortcutsCheckBox.isSelected();
        settings.setShowToolWindowsNumbers(this.myComponent.myWindowShortcutsCheckBox.isSelected());
        update2 |= settings.getHideToolStripes() != !this.myComponent.myShowToolStripesCheckBox.isSelected();
        settings.setHideToolStripes(!this.myComponent.myShowToolStripesCheckBox.isSelected());
        update2 |= settings.getShowIconsInMenus() != this.myComponent.myCbDisplayIconsInMenu.isSelected();
        settings.setShowIconsInMenus(this.myComponent.myCbDisplayIconsInMenu.isSelected());
        update2 |= settings.getShowMemoryIndicator() != this.myComponent.myShowMemoryIndicatorCheckBox.isSelected();
        settings.setShowMemoryIndicator(this.myComponent.myShowMemoryIndicatorCheckBox.isSelected());
        update2 |= settings.getAllowMergeButtons() != this.myComponent.myAllowMergeButtons.isSelected();
        settings.setAllowMergeButtons(this.myComponent.myAllowMergeButtons.isSelected());
        update2 |= settings.getCycleScrolling() != this.myComponent.myCycleScrollingCheckBox.isSelected();
        settings.setCycleScrolling(this.myComponent.myCycleScrollingCheckBox.isSelected());
        if (settings.getOverrideLafFonts() != this.myComponent.myOverrideLAFFonts.isSelected()) {
            shouldUpdateUI = true;
            update2 = true;
        }
        settings.setOverrideLafFonts(this.myComponent.myOverrideLAFFonts.isSelected());
        settings.setMoveMouseOnDefaultButton(this.myComponent.myMoveMouseOnDefaultButtonCheckBox.isSelected());
        settings.setHideNavigationOnFocusLoss(this.myComponent.myHideNavigationPopupsCheckBox.isSelected());
        settings.setDndWithPressedAltOnly(this.myComponent.myAltDNDCheckBox.isSelected());
        update2 |= settings.getDisableMnemonics() != this.myComponent.myDisableMnemonics.isSelected();
        settings.setDisableMnemonics(this.myComponent.myDisableMnemonics.isSelected());
        update2 |= settings.getUseSmallLabelsOnTabs() != this.myComponent.myUseSmallLabelsOnTabs.isSelected();
        settings.setUseSmallLabelsOnTabs(this.myComponent.myUseSmallLabelsOnTabs.isSelected());
        update2 |= settings.getWideScreenSupport() != this.myComponent.myWidescreenLayoutCheckBox.isSelected();
        settings.setWideScreenSupport(this.myComponent.myWidescreenLayoutCheckBox.isSelected());
        update2 |= settings.getLeftHorizontalSplit() != this.myComponent.myLeftLayoutCheckBox.isSelected();
        settings.setLeftHorizontalSplit(this.myComponent.myLeftLayoutCheckBox.isSelected());
        update2 |= settings.getRightHorizontalSplit() != this.myComponent.myRightLayoutCheckBox.isSelected();
        settings.setRightHorizontalSplit(this.myComponent.myRightLayoutCheckBox.isSelected());
        update2 |= settings.getNavigateToPreview() != (this.myComponent.myNavigateToPreviewCheckBox.isVisible() && this.myComponent.myNavigateToPreviewCheckBox.isSelected());
        settings.setNavigateToPreview(this.myComponent.myNavigateToPreviewCheckBox.isSelected());
        ColorBlindness blindness = this.myComponent.myColorBlindnessPanel.getColorBlindness();
        boolean updateEditorScheme = false;
        if (settings.getColorBlindness() != blindness) {
            settings.setColorBlindness(blindness);
            update2 = true;
            ServiceKt.getStateStore((ComponentManager)ApplicationManager.getApplication()).reloadState(DefaultColorSchemesManager.class);
            updateEditorScheme = true;
        }
        update2 |= settings.getDisableMnemonicsInControls() != this.myComponent.myDisableMnemonicInControlsCheckBox.isSelected();
        settings.setDisableMnemonicsInControls(this.myComponent.myDisableMnemonicInControlsCheckBox.isSelected());
        update2 |= settings.getShowIconInQuickNavigation() != this.myComponent.myHideIconsInQuickNavigation.isSelected();
        settings.setShowIconInQuickNavigation(this.myComponent.myHideIconsInQuickNavigation.isSelected());
        if (!Comparing.equal((Object)this.myComponent.myLafComboBox.getSelectedItem(), (Object)lafManager.getCurrentLookAndFeel()) && lafManager.checkLookAndFeel(lafInfo = (UIManager.LookAndFeelInfo)this.myComponent.myLafComboBox.getSelectedItem())) {
            update2 = true;
            shouldUpdateUI = false;
            SwingUtilities.invokeLater(() -> QuickChangeLookAndFeel.switchLafAndUpdateUI(lafManager, lafInfo));
        }
        if (shouldUpdateUI) {
            lafManager.updateUI();
            shouldUpdateUI = false;
        }
        if (!this.myComponent.myOverrideLAFFonts.isSelected()) {
            assert (!shouldUpdateUI);
            int defSize = JBUI.Fonts.label().getSize();
            settings.setFontSize(defSize);
            this.myComponent.myFontSizeCombo.getModel().setSelectedItem(String.valueOf(defSize));
            String defName = JBUI.Fonts.label().getFontName();
            settings.setFontFace(defName);
            this.myComponent.myFontCombo.setFontName(defName);
        }
        if (WindowManagerEx.getInstanceEx().isAlphaModeSupported()) {
            int delay = -1;
            try {
                delay = Integer.parseInt(this.myComponent.myAlphaModeDelayTextField.getText());
            }
            catch (NumberFormatException defName) {
                // empty catch block
            }
            float ratio = (float)this.myComponent.myAlphaModeRatioSlider.getValue() / 100.0f;
            if (this.myComponent.myEnableAlphaModeCheckBox.isSelected() != settings.getEnableAlphaMode() || delay != -1 && delay != settings.getAlphaModeDelay() || ratio != settings.getAlphaModeRatio()) {
                update2 = true;
                settings.setEnableAlphaMode(this.myComponent.myEnableAlphaModeCheckBox.isSelected());
                settings.setAlphaModeDelay(delay);
                settings.setAlphaModeRatio(ratio);
            }
        }
        if ((tooltipDelay = Math.min(this.myComponent.myInitialTooltipDelaySlider.getValue(), 5000)) != Registry.intValue((String)"ide.tooltip.initialDelay")) {
            update2 = true;
            Registry.get((String)"ide.tooltip.initialDelay").setValue(tooltipDelay);
        }
        if (update2) {
            settings.fireUISettingsChanged();
        }
        this.myComponent.updateCombo();
        if (updateEditorScheme) {
            ((EditorColorsManagerImpl)EditorColorsManager.getInstance()).schemeChangedOrSwitched(null);
        } else {
            EditorFactory.getInstance().refreshAllEditors();
        }
    }

    private static int getIntValue(JComboBox combo, int defaultValue) {
        String temp = (String)combo.getEditor().getItem();
        int value2 = -1;
        if (temp != null && temp.trim().length() > 0) {
            try {
                value2 = Integer.parseInt(temp);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (value2 <= 0) {
                value2 = defaultValue;
            }
        } else {
            value2 = defaultValue;
        }
        return value2;
    }

    public void reset() {
        this.initComponent();
        UISettings settings = UISettings.getInstance();
        if (settings.getOverrideLafFonts()) {
            this.myComponent.myFontCombo.setFontName(settings.getFontFace());
        } else {
            this.myComponent.myFontCombo.setFontName(UIUtil.getLabelFont().getFamily());
        }
        this.myComponent.myAntialiasingInIDE.setSelectedItem(settings.getIdeAAType());
        this.myComponent.myAntialiasingInEditor.setSelectedItem(settings.getEditorAAType());
        this.myComponent.myFontSizeCombo.setSelectedItem(Integer.toString(settings.getFontSize()));
        this.myComponent.myPresentationModeFontSize.setSelectedItem((Object)Integer.toString(settings.getPresentationModeFontSize()));
        this.myComponent.myAnimateWindowsCheckBox.setSelected(settings.getAnimateWindows());
        this.myComponent.myWindowShortcutsCheckBox.setSelected(settings.getShowToolWindowsNumbers());
        this.myComponent.myShowToolStripesCheckBox.setSelected(!settings.getHideToolStripes());
        this.myComponent.myCbDisplayIconsInMenu.setSelected(settings.getShowIconsInMenus());
        this.myComponent.myShowMemoryIndicatorCheckBox.setSelected(settings.getShowMemoryIndicator());
        this.myComponent.myAllowMergeButtons.setSelected(settings.getAllowMergeButtons());
        this.myComponent.myCycleScrollingCheckBox.setSelected(settings.getCycleScrolling());
        this.myComponent.myHideIconsInQuickNavigation.setSelected(settings.getShowIconInQuickNavigation());
        this.myComponent.myMoveMouseOnDefaultButtonCheckBox.setSelected(settings.getMoveMouseOnDefaultButton());
        this.myComponent.myHideNavigationPopupsCheckBox.setSelected(settings.getHideNavigationOnFocusLoss());
        this.myComponent.myAltDNDCheckBox.setSelected(settings.getDndWithPressedAltOnly());
        this.myComponent.myLafComboBox.setSelectedItem(LafManager.getInstance().getCurrentLookAndFeel());
        this.myComponent.myOverrideLAFFonts.setSelected(settings.getOverrideLafFonts());
        this.myComponent.myDisableMnemonics.setSelected(settings.getDisableMnemonics());
        this.myComponent.myUseSmallLabelsOnTabs.setSelected(settings.getUseSmallLabelsOnTabs());
        this.myComponent.myWidescreenLayoutCheckBox.setSelected(settings.getWideScreenSupport());
        this.myComponent.myLeftLayoutCheckBox.setSelected(settings.getLeftHorizontalSplit());
        this.myComponent.myRightLayoutCheckBox.setSelected(settings.getRightHorizontalSplit());
        this.myComponent.myNavigateToPreviewCheckBox.setSelected(settings.getNavigateToPreview());
        this.myComponent.myNavigateToPreviewCheckBox.setVisible(false);
        this.myComponent.myColorBlindnessPanel.setColorBlindness(settings.getColorBlindness());
        this.myComponent.myDisableMnemonicInControlsCheckBox.setSelected(settings.getDisableMnemonicsInControls());
        boolean alphaModeEnabled = WindowManagerEx.getInstanceEx().isAlphaModeSupported();
        if (alphaModeEnabled) {
            this.myComponent.myEnableAlphaModeCheckBox.setSelected(settings.getEnableAlphaMode());
        } else {
            this.myComponent.myEnableAlphaModeCheckBox.setSelected(false);
        }
        this.myComponent.myEnableAlphaModeCheckBox.setEnabled(alphaModeEnabled);
        this.myComponent.myAlphaModeDelayTextField.setText(Integer.toString(settings.getAlphaModeDelay()));
        this.myComponent.myAlphaModeDelayTextField.setEnabled(alphaModeEnabled && settings.getEnableAlphaMode());
        int ratio = (int)(settings.getAlphaModeRatio() * 100.0f);
        this.myComponent.myAlphaModeRatioSlider.setValue(ratio);
        this.myComponent.myAlphaModeRatioSlider.setToolTipText(ratio + "%");
        this.myComponent.myAlphaModeRatioSlider.setEnabled(alphaModeEnabled && settings.getEnableAlphaMode());
        this.myComponent.myInitialTooltipDelaySlider.setValue(Registry.intValue((String)"ide.tooltip.initialDelay"));
        this.myComponent.updateCombo();
    }

    public static String antialiasingTypeInEditorAsString(boolean antialiased, LCDRenderingScope scope) {
        if (!antialiased) {
            return "No antialiasing";
        }
        switch (scope) {
            case IDE: {
                return "Subpixel";
            }
            case OFF: 
            case EXCLUDING_EDITOR: {
                return "Greyscale";
            }
        }
        LOG.info("Wrong antialiasing state");
        return "No antialiasing";
    }

    public boolean isModified() {
        int tooltipDelay;
        this.initComponent();
        UISettings settings = UISettings.getInstance();
        boolean isModified = false;
        isModified |= !Comparing.equal((String)this.myComponent.myFontCombo.getFontName(), (String)settings.getFontFace()) && this.myComponent.myOverrideLAFFonts.isSelected();
        isModified |= !Comparing.equal((Object)this.myComponent.myFontSizeCombo.getEditor().getItem(), (Object)Integer.toString(settings.getFontSize()));
        isModified |= this.myComponent.myAntialiasingInIDE.getSelectedItem() != settings.getIdeAAType();
        isModified |= this.myComponent.myAntialiasingInEditor.getSelectedItem() != settings.getEditorAAType();
        isModified |= this.myComponent.myAnimateWindowsCheckBox.isSelected() != settings.getAnimateWindows();
        isModified |= this.myComponent.myWindowShortcutsCheckBox.isSelected() != settings.getShowToolWindowsNumbers();
        isModified |= this.myComponent.myShowToolStripesCheckBox.isSelected() == settings.getHideToolStripes();
        isModified |= this.myComponent.myCbDisplayIconsInMenu.isSelected() != settings.getShowIconsInMenus();
        isModified |= this.myComponent.myShowMemoryIndicatorCheckBox.isSelected() != settings.getShowMemoryIndicator();
        isModified |= this.myComponent.myAllowMergeButtons.isSelected() != settings.getAllowMergeButtons();
        isModified |= this.myComponent.myCycleScrollingCheckBox.isSelected() != settings.getCycleScrolling();
        isModified |= this.myComponent.myOverrideLAFFonts.isSelected() != settings.getOverrideLafFonts();
        isModified |= this.myComponent.myDisableMnemonics.isSelected() != settings.getDisableMnemonics();
        isModified |= this.myComponent.myDisableMnemonicInControlsCheckBox.isSelected() != settings.getDisableMnemonicsInControls();
        isModified |= this.myComponent.myUseSmallLabelsOnTabs.isSelected() != settings.getUseSmallLabelsOnTabs();
        isModified |= this.myComponent.myWidescreenLayoutCheckBox.isSelected() != settings.getWideScreenSupport();
        isModified |= this.myComponent.myLeftLayoutCheckBox.isSelected() != settings.getLeftHorizontalSplit();
        isModified |= this.myComponent.myRightLayoutCheckBox.isSelected() != settings.getRightHorizontalSplit();
        isModified |= this.myComponent.myNavigateToPreviewCheckBox.isSelected() != settings.getNavigateToPreview();
        isModified |= this.myComponent.myColorBlindnessPanel.getColorBlindness() != settings.getColorBlindness();
        isModified |= this.myComponent.myHideIconsInQuickNavigation.isSelected() != settings.getShowIconInQuickNavigation();
        isModified |= !Comparing.equal((Object)this.myComponent.myPresentationModeFontSize.getEditor().getItem(), (Object)Integer.toString(settings.getPresentationModeFontSize()));
        isModified |= this.myComponent.myMoveMouseOnDefaultButtonCheckBox.isSelected() != settings.getMoveMouseOnDefaultButton();
        isModified |= this.myComponent.myHideNavigationPopupsCheckBox.isSelected() != settings.getHideNavigationOnFocusLoss();
        isModified |= this.myComponent.myAltDNDCheckBox.isSelected() != settings.getDndWithPressedAltOnly();
        isModified |= !Comparing.equal((Object)this.myComponent.myLafComboBox.getSelectedItem(), (Object)LafManager.getInstance().getCurrentLookAndFeel());
        if (WindowManagerEx.getInstanceEx().isAlphaModeSupported()) {
            float ratio;
            isModified |= this.myComponent.myEnableAlphaModeCheckBox.isSelected() != settings.getEnableAlphaMode();
            int delay = -1;
            try {
                delay = Integer.parseInt(this.myComponent.myAlphaModeDelayTextField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (delay != -1) {
                isModified |= delay != settings.getAlphaModeDelay();
            }
            isModified |= (ratio = (float)this.myComponent.myAlphaModeRatioSlider.getValue() / 100.0f) != settings.getAlphaModeRatio();
        }
        return isModified |= (tooltipDelay = this.myComponent.myInitialTooltipDelaySlider.getValue()) != Registry.intValue((String)"ide.tooltip.initialDelay");
    }

    public void disposeUIResources() {
        this.myComponent = null;
    }

    public String getHelpTopic() {
        return "preferences.lookFeel";
    }

    private static class AAListCellRenderer
    extends ListCellRendererWrapper<AntialiasingType> {
        private static final SwingUtilities2.AATextInfo SUBPIXEL_HINT = new SwingUtilities2.AATextInfo(RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB, Integer.valueOf(UIUtil.getLcdContrastValue()));
        private static final SwingUtilities2.AATextInfo GREYSCALE_HINT = new SwingUtilities2.AATextInfo(RenderingHints.VALUE_TEXT_ANTIALIAS_ON, Integer.valueOf(UIUtil.getLcdContrastValue()));
        private final boolean useEditorAASettings;

        public AAListCellRenderer(boolean useEditorAASettings) {
            this.useEditorAASettings = useEditorAASettings;
        }

        public void customize(JList list2, AntialiasingType value2, int index, boolean selected, boolean hasFocus) {
            if (value2 == AntialiasingType.SUBPIXEL) {
                this.setClientProperty(SwingUtilities2.AA_TEXT_PROPERTY_KEY, SUBPIXEL_HINT);
            } else if (value2 == AntialiasingType.GREYSCALE) {
                this.setClientProperty(SwingUtilities2.AA_TEXT_PROPERTY_KEY, GREYSCALE_HINT);
            } else if (value2 == AntialiasingType.OFF) {
                this.setClientProperty(SwingUtilities2.AA_TEXT_PROPERTY_KEY, null);
            }
            if (this.useEditorAASettings) {
                EditorColorsScheme scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
                this.setFont(new Font(scheme2.getEditorFontName(), 0, scheme2.getEditorFontSize()));
            }
            this.setText(String.valueOf(value2));
        }
    }

    private static class MyComponent {
        private JPanel myPanel;
        private FontComboBox myFontCombo;
        private JComboBox myFontSizeCombo;
        private JCheckBox myAnimateWindowsCheckBox;
        private JCheckBox myWindowShortcutsCheckBox;
        private JCheckBox myShowToolStripesCheckBox;
        private JCheckBox myShowMemoryIndicatorCheckBox;
        private JComboBox myLafComboBox;
        private JCheckBox myCycleScrollingCheckBox;
        private JCheckBox myMoveMouseOnDefaultButtonCheckBox;
        private JCheckBox myEnableAlphaModeCheckBox;
        private JTextField myAlphaModeDelayTextField;
        private JSlider myAlphaModeRatioSlider;
        private JLabel myFontSizeLabel;
        private JLabel myFontNameLabel;
        private JPanel myTransparencyPanel;
        private JCheckBox myOverrideLAFFonts;
        private JCheckBox myHideIconsInQuickNavigation;
        private JCheckBox myCbDisplayIconsInMenu;
        private JCheckBox myDisableMnemonics;
        private JCheckBox myDisableMnemonicInControlsCheckBox;
        private JCheckBox myHideNavigationPopupsCheckBox;
        private JCheckBox myAltDNDCheckBox;
        private JCheckBox myAllowMergeButtons;
        private JBCheckBox myUseSmallLabelsOnTabs;
        private JBCheckBox myWidescreenLayoutCheckBox;
        private JCheckBox myLeftLayoutCheckBox;
        private JCheckBox myRightLayoutCheckBox;
        private JSlider myInitialTooltipDelaySlider;
        private ComboBox myPresentationModeFontSize;
        private JCheckBox myNavigateToPreviewCheckBox;
        private ColorBlindnessPanel myColorBlindnessPanel;
        private JComboBox myAntialiasingInIDE;
        private JComboBox myAntialiasingInEditor;

        public MyComponent() {
            this.$$$setupUI$$$();
            this.myOverrideLAFFonts.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    this.updateCombo();
                }
            });
            if (!Registry.is((String)"ide.transparency.mode.for.windows")) {
                this.myTransparencyPanel.getParent().remove(this.myTransparencyPanel);
            }
        }

        public void updateCombo() {
            boolean enableChooser = this.myOverrideLAFFonts.isSelected();
            this.myFontCombo.setEnabled(enableChooser);
            this.myFontSizeCombo.setEnabled(enableChooser);
            this.myFontNameLabel.setEnabled(enableChooser);
            this.myFontSizeLabel.setEnabled(enableChooser);
        }

        private void createUIComponents() {
            this.myFontSizeCombo = new ComboBox();
            this.myPresentationModeFontSize = new ComboBox();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JComboBox jComboBox;
            JComboBox jComboBox2;
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JCheckBox jCheckBox3;
            JBCheckBox jBCheckBox;
            JBCheckBox jBCheckBox2;
            JCheckBox jCheckBox4;
            JCheckBox jCheckBox5;
            JCheckBox jCheckBox6;
            JCheckBox jCheckBox7;
            JCheckBox jCheckBox8;
            JCheckBox jCheckBox9;
            JCheckBox jCheckBox10;
            JCheckBox jCheckBox11;
            JTextField jTextField;
            JSlider jSlider;
            JCheckBox jCheckBox12;
            JPanel jPanel;
            ColorBlindnessPanel colorBlindnessPanel;
            JCheckBox jCheckBox13;
            JSlider jSlider2;
            JCheckBox jCheckBox14;
            JCheckBox jCheckBox15;
            JCheckBox jCheckBox16;
            JLabel jLabel;
            JLabel jLabel2;
            FontComboBox fontComboBox;
            JComboBox jComboBox3;
            JCheckBox jCheckBox17;
            JCheckBox jCheckBox18;
            JPanel jPanel2;
            this.createUIComponents();
            this.myPanel = jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 3, null, null, null));
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout((LayoutManager)new GridLayoutManager(10, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 1, 3, 3, 3, null, null, null));
            jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/IdeBundle").getString("group.ui.options"), (int)0, (int)0, null, null));
            this.myMoveMouseOnDefaultButtonCheckBox = jCheckBox18 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox18, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.position.cursor.on.default.button"));
            jCheckBox18.setMargin(new Insets(2, 0, 2, 2));
            jPanel4.add((Component)jCheckBox18, new GridConstraints(6, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myCycleScrollingCheckBox = jCheckBox17 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox17, ResourceBundle.getBundle("messages/IdeBundle").getString("checkboox.cyclic.scrolling.in.lists"));
            jCheckBox17.setSelected(true);
            jCheckBox17.setMargin(new Insets(2, 0, 2, 2));
            jPanel4.add((Component)jCheckBox17, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 8, 2, 3, 3, null, null, null));
            JLabel jLabel3 = new JLabel();
            this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/IdeBundle").getString("combobox.look.and.feel"));
            jLabel3.setHorizontalAlignment(2);
            jLabel3.setHorizontalTextPosition(2);
            jLabel3.setVerifyInputWhenFocusTarget(false);
            jPanel5.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myLafComboBox = jComboBox3 = new JComboBox();
            jPanel5.add(jComboBox3, new GridConstraints(0, 1, 1, 1, 8, 1, 7, 0, null, null, null));
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel4.add((Component)jPanel6, new GridConstraints(3, 0, 1, 1, 8, 2, 3, 3, null, null, null));
            this.myFontCombo = fontComboBox = new FontComboBox();
            ((Component)((Object)fontComboBox)).setName("");
            ((Component)((Object)fontComboBox)).setEnabled(true);
            ((JComboBox)((Object)fontComboBox)).setPopupVisible(false);
            ((JComponent)((Object)fontComboBox)).setAutoscrolls(true);
            ((JComboBox)((Object)fontComboBox)).setEditable(false);
            ((JComponent)((Object)fontComboBox)).setDoubleBuffered(false);
            ((JComponent)((Object)fontComboBox)).setRequestFocusEnabled(true);
            jPanel6.add((Component)((Object)fontComboBox), new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
            this.myFontNameLabel = jLabel2 = new JLabel();
            this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/IdeBundle").getString("label.font.name"));
            jLabel2.setHorizontalAlignment(10);
            jPanel6.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 1, 0, 0, null, null, null, 3));
            this.myFontSizeLabel = jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/IdeBundle").getString("label.font.size"));
            jLabel.setHorizontalAlignment(10);
            jPanel6.add((Component)jLabel, new GridConstraints(0, 2, 1, 1, 8, 1, 0, 0, null, null, null));
            JComboBox jComboBox4 = this.myFontSizeCombo;
            jComboBox4.setEditable(true);
            jPanel6.add((Component)jComboBox4, new GridConstraints(0, 3, 1, 1, 8, 1, 2, 0, null, new Dimension(40, -1), null));
            JPanel jPanel7 = new JPanel();
            jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel4.add((Component)jPanel7, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myOverrideLAFFonts = jCheckBox16 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox16, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.override.default.laf.fonts"));
            jCheckBox16.setMargin(new Insets(2, 0, 2, 2));
            jPanel7.add((Component)jCheckBox16, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myHideIconsInQuickNavigation = jCheckBox15 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox15, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.show.icons.in.quick.navigation"));
            jCheckBox15.setMargin(new Insets(2, 0, 2, 2));
            jPanel4.add((Component)jCheckBox15, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myHideNavigationPopupsCheckBox = jCheckBox14 = new JCheckBox();
            jCheckBox14.setText("Hide navigation popups on focus loss");
            jCheckBox14.setMargin(new Insets(2, 0, 2, 2));
            jPanel4.add((Component)jCheckBox14, new GridConstraints(7, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(271, 29), null));
            JPanel jPanel8 = new JPanel();
            jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel4.add((Component)jPanel8, new GridConstraints(9, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            JLabel jLabel4 = new JLabel();
            jLabel4.setText("Tooltip initial delay (ms):");
            jPanel8.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myInitialTooltipDelaySlider = jSlider2 = new JSlider();
            jSlider2.setPaintTrack(true);
            jSlider2.setValue(100);
            jPanel8.add((Component)jSlider2, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
            this.myAltDNDCheckBox = jCheckBox13 = new JCheckBox();
            jCheckBox13.setText("Drag-n-Drop with ALT pressed only");
            jPanel4.add((Component)jCheckBox13, new GridConstraints(8, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myColorBlindnessPanel = colorBlindnessPanel = new ColorBlindnessPanel();
            jPanel4.add((Component)colorBlindnessPanel, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 3, null, null, null));
            this.myTransparencyPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 1, 3, 3, 3, null, null, null));
            jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/IdeBundle").getString("group.transparency"), (int)0, (int)0, null, null));
            JLabel jLabel5 = new JLabel();
            this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/IdeBundle").getString("label.transparency.delay.ms"));
            jPanel.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            JLabel jLabel6 = new JLabel();
            this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("messages/IdeBundle").getString("label.transparency.ratio"));
            jPanel.add((Component)jLabel6, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myEnableAlphaModeCheckBox = jCheckBox12 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox12, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.use.transparent.mode.for.floating.windows"));
            jCheckBox12.setMargin(new Insets(0, 0, 0, 0));
            jPanel.add((Component)jCheckBox12, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
            this.myAlphaModeRatioSlider = jSlider = new JSlider();
            jPanel.add((Component)jSlider, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
            this.myAlphaModeDelayTextField = jTextField = new JTextField();
            jTextField.setHorizontalAlignment(2);
            jTextField.setText("1500");
            jTextField.setMargin(new Insets(0, 0, 0, 0));
            jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 0, 6, 0, null, new Dimension(50, -1), null));
            JPanel jPanel9 = new JPanel();
            jPanel9.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel9.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel3.add((Component)jPanel9, new GridConstraints(3, 0, 1, 1, 1, 3, 0, 0, null, null, null));
            jPanel9.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/IdeBundle").getString("group.window.options"), (int)0, (int)0, null, null));
            this.myShowToolStripesCheckBox = jCheckBox11 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox11, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.show.tool.window.bars"));
            jCheckBox11.setSelected(true);
            jCheckBox11.setMargin(new Insets(2, 2, 2, 2));
            jPanel9.add((Component)jCheckBox11, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myCbDisplayIconsInMenu = jCheckBox10 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox10, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.show.icons.in.menu.items"));
            jCheckBox10.setSelected(true);
            jCheckBox10.setMargin(new Insets(2, 2, 2, 2));
            jPanel9.add((Component)jCheckBox10, new GridConstraints(4, 0, 1, 1, 9, 0, 3, 0, null, new Dimension(153, 20), null));
            this.myDisableMnemonics = jCheckBox9 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox9, ResourceBundle.getBundle("messages/KeyMapBundle").getString("disable.mnemonic.in.menu.check.box"));
            jCheckBox9.setMargin(new Insets(2, 2, 2, 2));
            jPanel9.add((Component)jCheckBox9, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myDisableMnemonicInControlsCheckBox = jCheckBox8 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox8, ResourceBundle.getBundle("messages/KeyMapBundle").getString("disable.mnemonic.in.controls.check.box"));
            jCheckBox8.setMargin(new Insets(2, 2, 2, 2));
            jPanel9.add((Component)jCheckBox8, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myWindowShortcutsCheckBox = jCheckBox7 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.show.tool.window.numbers"));
            jCheckBox7.setSelected(true);
            jCheckBox7.setMargin(new Insets(2, 2, 2, 2));
            jPanel9.add((Component)jCheckBox7, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myShowMemoryIndicatorCheckBox = jCheckBox6 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.show.memory.indicator"));
            jCheckBox6.setSelected(true);
            jCheckBox6.setMargin(new Insets(2, 2, 2, 2));
            jPanel9.add((Component)jCheckBox6, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myAnimateWindowsCheckBox = jCheckBox5 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.animate.windows"));
            jCheckBox5.setSelected(true);
            jCheckBox5.setMargin(new Insets(2, 2, 2, 2));
            jPanel9.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myAllowMergeButtons = jCheckBox4 = new JCheckBox();
            jCheckBox4.setText("Allow merging buttons on dialogs");
            jCheckBox4.setSelected(true);
            jPanel9.add((Component)jCheckBox4, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myUseSmallLabelsOnTabs = jBCheckBox2 = new JBCheckBox();
            jBCheckBox2.setText("Small labels in editor tabs");
            jPanel9.add((Component)jBCheckBox2, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myWidescreenLayoutCheckBox = jBCheckBox = new JBCheckBox();
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.widescreen.tool.window.layout"));
            jPanel9.add((Component)jBCheckBox, new GridConstraints(4, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(175, 20), null));
            this.myLeftLayoutCheckBox = jCheckBox3 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.left.toolwindow.layout"));
            jPanel9.add((Component)jCheckBox3, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(171, 20), null));
            this.myRightLayoutCheckBox = jCheckBox2 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.right.toolwindow.layout"));
            jPanel9.add((Component)jCheckBox2, new GridConstraints(5, 1, 1, 1, 8, 0, 3, 0, null, new Dimension(177, 20), null));
            this.myNavigateToPreviewCheckBox = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.use.preview.window"));
            jPanel9.add((Component)jCheckBox, new GridConstraints(6, 1, 1, 1, 8, 0, 3, 0, null, null, null));
            JPanel jPanel10 = new JPanel();
            jPanel10.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel10.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel3.add((Component)jPanel10, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel10.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/IdeBundle").getString("group.presentation.mode"), (int)0, (int)0, null, null));
            Spacer spacer = new Spacer();
            jPanel10.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel10.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            JBLabel jBLabel = new JBLabel();
            this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/IdeBundle").getString("presentation.mode.fon.size"));
            jPanel10.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
            ComboBox comboBox = this.myPresentationModeFontSize;
            jPanel10.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 0, 2, 0, null, null, null));
            JPanel jPanel11 = new JPanel();
            jPanel11.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel11.putClientProperty("html.disable", Boolean.FALSE);
            jPanel11.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel3.add((Component)jPanel11, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel11.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/IdeBundle").getString("group.antialiasing.mode"), (int)0, (int)0, null, null));
            this.myAntialiasingInIDE = jComboBox2 = new JComboBox();
            jPanel11.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
            this.myAntialiasingInEditor = jComboBox = new JComboBox();
            jPanel11.add(jComboBox, new GridConstraints(0, 3, 1, 1, 8, 1, 2, 0, null, null, null));
            JLabel jLabel7 = new JLabel();
            this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("messages/IdeBundle").getString("label.text.antialiasing.scope.ide"));
            jPanel11.add((Component)jLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            JLabel jLabel8 = new JLabel();
            this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("messages/IdeBundle").getString("label.text.antialiasing.scope.editor"));
            jPanel11.add((Component)jLabel8, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
            jLabel3.setLabelFor(jComboBox3);
            jLabel7.setLabelFor(jComboBox2);
            jLabel8.setLabelFor(jComboBox);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string2) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c2 = '\u0000';
            int n2 = -1;
            for (int i2 = 0; i2 < string2.length(); ++i2) {
                if (string2.charAt(i2) == '&') {
                    if (++i2 == string2.length()) break;
                    if (!bl && string2.charAt(i2) != '&') {
                        bl = true;
                        c2 = string2.charAt(i2);
                        n2 = stringBuffer.length();
                    }
                }
                stringBuffer.append(string2.charAt(i2));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c2);
                jLabel.setDisplayedMnemonicIndex(n2);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string2) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c2 = '\u0000';
            int n2 = -1;
            for (int i2 = 0; i2 < string2.length(); ++i2) {
                if (string2.charAt(i2) == '&') {
                    if (++i2 == string2.length()) break;
                    if (!bl && string2.charAt(i2) != '&') {
                        bl = true;
                        c2 = string2.charAt(i2);
                        n2 = stringBuffer.length();
                    }
                }
                stringBuffer.append(string2.charAt(i2));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c2);
                abstractButton.setDisplayedMnemonicIndex(n2);
            }
        }
    }
}

