/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.customization;

import com.intellij.ide.ui.customization.ActionUrl;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.ui.customization.CustomisedActionGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomizationUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.ui.customization.CustomizationUtil");

    private CustomizationUtil() {
    }

    public static ActionGroup correctActionGroup(ActionGroup group, CustomActionsSchema schema, String defaultGroupName, String rootGroupName) {
        if (!schema.isCorrectActionGroup(group, defaultGroupName)) {
            return group;
        }
        String text2 = group.getTemplatePresentation().getText();
        int mnemonic = group.getTemplatePresentation().getMnemonic();
        if (text2 != null) {
            for (int i2 = 0; i2 < text2.length(); ++i2) {
                if (Character.toUpperCase(text2.charAt(i2)) != mnemonic) continue;
                text2 = text2.replaceFirst(String.valueOf(text2.charAt(i2)), "_" + text2.charAt(i2));
                break;
            }
        }
        return new CustomisedActionGroup(text2, group.isPopup(), group, schema, defaultGroupName, rootGroupName);
    }

    static AnAction[] getReordableChildren(ActionGroup group, CustomActionsSchema schema, String defaultGroupName, String rootGroupName, AnActionEvent e2) {
        String text2 = group.getTemplatePresentation().getText();
        ActionManager actionManager = ActionManager.getInstance();
        ArrayList<Object> reorderedChildren = new ArrayList<Object>();
        ContainerUtil.addAll(reorderedChildren, (Object[])group.getChildren(e2));
        List<ActionUrl> actions2 = schema.getActions();
        for (ActionUrl actionUrl : actions2) {
            AnAction anAction;
            AnAction componentAction;
            if (!actionUrl.getParentGroup().equals(text2) && !actionUrl.getParentGroup().equals(defaultGroupName) && (!actionUrl.getParentGroup().equals(actionManager.getId((AnAction)group)) || !actionUrl.getRootGroup().equals(rootGroupName)) || (componentAction = actionUrl.getComponentAction()) == null) continue;
            if (actionUrl.getActionType() == 1) {
                if (componentAction == group) {
                    LOG.error("Attempt to add group to itself; group ID=" + actionManager.getId((AnAction)group));
                    continue;
                }
                if (reorderedChildren.size() > actionUrl.getAbsolutePosition()) {
                    reorderedChildren.add(actionUrl.getAbsolutePosition(), componentAction);
                    continue;
                }
                reorderedChildren.add(componentAction);
                continue;
            }
            if (actionUrl.getActionType() != -1 || reorderedChildren.size() <= actionUrl.getAbsolutePosition() || ((anAction = (AnAction)reorderedChildren.get(actionUrl.getAbsolutePosition())).getTemplatePresentation().getText() == null ? componentAction.getTemplatePresentation().getText() != null && componentAction.getTemplatePresentation().getText().length() > 0 : !anAction.getTemplatePresentation().getText().equals(componentAction.getTemplatePresentation().getText()))) continue;
            reorderedChildren.remove(actionUrl.getAbsolutePosition());
        }
        for (int i2 = 0; i2 < reorderedChildren.size(); ++i2) {
            if (!(reorderedChildren.get(i2) instanceof ActionGroup)) continue;
            ActionGroup groupToCorrect = (ActionGroup)reorderedChildren.get(i2);
            ActionGroup correctedAction = CustomizationUtil.correctActionGroup(groupToCorrect, schema, "", rootGroupName);
            reorderedChildren.set(i2, correctedAction);
        }
        return reorderedChildren.toArray(new AnAction[reorderedChildren.size()]);
    }

    public static void optimizeSchema(JTree tree2, CustomActionsSchema schema) {
        Group rootGroup = new Group("root", null, null);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(rootGroup);
        root.removeAllChildren();
        schema.fillActionGroups(root);
        Tree defaultTree = new Tree((TreeModel)new DefaultTreeModel(root));
        ArrayList<ActionUrl> actions2 = new ArrayList<ActionUrl>();
        TreeUtil.traverseDepth((TreeNode)((TreeNode)tree2.getModel().getRoot()), arg_0 -> CustomizationUtil.lambda$optimizeSchema$0((JTree)defaultTree, actions2, schema, arg_0));
        schema.setActions(actions2);
    }

    private static void computeDiff(ActionUrl[] defaultUserObjects, ActionUrl[] currentUserObjects, @NotNull List<ActionUrl> actions2) {
        if (actions2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/ide/ui/customization/CustomizationUtil", "computeDiff"));
        }
        Diff.Change change = null;
        try {
            change = Diff.buildChanges((Object[])defaultUserObjects, (Object[])currentUserObjects);
        }
        catch (FilesTooBigForDiffException e2) {
            LOG.info((Throwable)e2);
        }
        while (change != null) {
            ActionUrl currentUserObject;
            int idx;
            int i2;
            for (i2 = 0; i2 < change.deleted; ++i2) {
                idx = change.line0 + i2;
                currentUserObject = defaultUserObjects[idx];
                currentUserObject.setActionType(-1);
                currentUserObject.setAbsolutePosition(idx);
                actions2.add(currentUserObject);
            }
            for (i2 = 0; i2 < change.inserted; ++i2) {
                idx = change.line1 + i2;
                currentUserObject = currentUserObjects[idx];
                currentUserObject.setActionType(1);
                currentUserObject.setAbsolutePosition(idx);
                actions2.add(currentUserObject);
            }
            change = change.link;
        }
    }

    public static TreePath getPathByUserObjects(JTree tree2, TreePath treePath) {
        ArrayList<String> path = new ArrayList<String>();
        for (int i2 = 0; i2 < treePath.getPath().length; ++i2) {
            Object o2 = ((DefaultMutableTreeNode)treePath.getPath()[i2]).getUserObject();
            if (!(o2 instanceof Group)) continue;
            path.add(((Group)o2).getName());
        }
        return CustomizationUtil.getTreePath(0, path, tree2.getModel().getRoot());
    }

    public static ActionUrl getActionUrl(TreePath treePath, int actionType) {
        ActionUrl url = new ActionUrl();
        for (int i2 = 0; i2 < treePath.getPath().length - 1; ++i2) {
            Object o2 = ((DefaultMutableTreeNode)treePath.getPath()[i2]).getUserObject();
            if (!(o2 instanceof Group)) continue;
            url.getGroupPath().add(((Group)o2).getName());
        }
        DefaultMutableTreeNode component = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        url.setComponent(component.getUserObject());
        TreeNode parent = component.getParent();
        url.setAbsolutePosition(parent != null ? parent.getIndex(component) : 0);
        url.setActionType(actionType);
        return url;
    }

    public static TreePath getTreePath(JTree tree2, ActionUrl url) {
        return CustomizationUtil.getTreePath(0, url.getGroupPath(), tree2.getModel().getRoot());
    }

    @Nullable
    private static TreePath getTreePath(int positionInPath, List<String> path, Object root) {
        TreeNode child;
        if (!(root instanceof DefaultMutableTreeNode)) {
            return null;
        }
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)root;
        Object userObject = treeNode.getUserObject();
        if (path.size() <= positionInPath) {
            return null;
        }
        String pathElement = path.get(positionInPath);
        if (pathElement == null) {
            return null;
        }
        if (!(userObject instanceof Group)) {
            return null;
        }
        if (!pathElement.equals(((Group)userObject).getName())) {
            return null;
        }
        TreePath currentPath = new TreePath(treeNode.getPath());
        if (positionInPath == path.size() - 1) {
            return currentPath;
        }
        for (int j2 = 0; j2 < treeNode.getChildCount() && (currentPath = CustomizationUtil.getTreePath(positionInPath + 1, path, child = treeNode.getChildAt(j2))) == null; ++j2) {
        }
        return currentPath;
    }

    private static ActionUrl[] getChildUserObjects(DefaultMutableTreeNode node, ActionUrl parent) {
        ArrayList<ActionUrl> result2 = new ArrayList<ActionUrl>();
        ArrayList<String> groupPath = new ArrayList<String>();
        groupPath.addAll(parent.getGroupPath());
        for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i2);
            ActionUrl url = new ActionUrl();
            url.setGroupPath(groupPath);
            Object userObject = child.getUserObject();
            url.setComponent(userObject instanceof Pair ? ((Pair)userObject).first : userObject);
            result2.add(url);
        }
        return result2.toArray(new ActionUrl[result2.size()]);
    }

    public static MouseListener installPopupHandler(JComponent component, final @NotNull String groupId, final String place) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/intellij/ide/ui/customization/CustomizationUtil", "installPopupHandler"));
        }
        if (ApplicationManager.getApplication() == null) {
            return new MouseAdapter(){};
        }
        PopupHandler popupHandler = new PopupHandler(){

            public void invokePopup(Component comp, int x2, int y2) {
                ActionGroup group = (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction(groupId);
                ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu(place, group);
                popupMenu.getComponent().show(comp, x2, y2);
            }
        };
        component.addMouseListener((MouseListener)popupHandler);
        return popupHandler;
    }

    private static /* synthetic */ boolean lambda$optimizeSchema$0(JTree defaultTree, List actions2, CustomActionsSchema schema, Object node) {
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
        Object userObject = treeNode.getUserObject();
        if (treeNode.isLeaf() && !(userObject instanceof Group)) {
            return true;
        }
        ActionUrl url = CustomizationUtil.getActionUrl(new TreePath(treeNode.getPath()), 0);
        String groupName = ((Group)userObject).getName();
        url.getGroupPath().add(groupName);
        TreePath treePath = CustomizationUtil.getTreePath(defaultTree, url);
        if (treePath != null) {
            DefaultMutableTreeNode visited = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            ActionUrl[] defaultUserObjects = CustomizationUtil.getChildUserObjects(visited, url);
            ActionUrl[] currentUserObjects = CustomizationUtil.getChildUserObjects(treeNode, url);
            CustomizationUtil.computeDiff(defaultUserObjects, currentUserObjects, actions2);
        } else {
            url.getGroupPath().remove(url.getParentGroup());
            if (actions2.contains(url)) {
                url.getGroupPath().add(groupName);
                actions2.addAll(schema.getChildActions(url));
            }
        }
        return true;
    }
}

