/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf;

import com.intellij.ide.ui.laf.IdeaBlueMetalTheme;
import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.foundation.MacUtil;
import java.awt.Color;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.metal.DefaultMetalTheme;

public class IntelliJLaf
extends DarculaLaf {
    @Override
    public String getName() {
        return "IntelliJ";
    }

    @Override
    protected String getPrefix() {
        return IntelliJLaf.isWindowsNativeLook() ? "intellijlaf_native" : "intellijlaf";
    }

    @Override
    protected BasicLookAndFeel createBaseLookAndFeel() {
        if (IntelliJLaf.isWindowsNativeLook()) {
            try {
                String name = UIManager.getSystemLookAndFeelClassName();
                return (BasicLookAndFeel)Class.forName(name).newInstance();
            }
            catch (Exception e2) {
                IntelliJLaf.log(e2);
            }
        }
        return super.createBaseLookAndFeel();
    }

    @Override
    protected DefaultMetalTheme createMetalTheme() {
        return new IdeaBlueMetalTheme();
    }

    public static boolean isGraphite() {
        if (!SystemInfo.isMac) {
            return false;
        }
        try {
            return Foundation.invoke((String)"NSColor", (String)"currentControlTint", (Object[])new Object[0]).intValue() == 6;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public static Color getSelectedControlColor() {
        return MacUtil.colorFromNative((ID)Foundation.invoke((String)"NSColor", (String)"alternateSelectedControlColor", (Object[])new Object[0]));
    }

    public static boolean isWindowsNativeLook() {
        return SystemInfo.isWindows && Registry.is((String)"ide.intellij.laf.win10.ui");
    }
}

