/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class DarculaTableHeaderUI
extends BasicTableHeaderUI {
    public static ComponentUI createUI(JComponent c2) {
        return new DarculaTableHeaderUI();
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        Graphics2D g3 = (Graphics2D)g2;
        GraphicsConfig config = new GraphicsConfig((Graphics)g3);
        Color bg = c2.getBackground();
        g3.setPaint(new GradientPaint(0.0f, 0.0f, ColorUtil.shift((Color)bg, (double)1.4), 0.0f, c2.getHeight(), ColorUtil.shift((Color)bg, (double)0.9)));
        int h2 = c2.getHeight();
        int w2 = c2.getWidth();
        g3.fillRect(0, 0, w2, h2);
        g3.setPaint(ColorUtil.shift((Color)bg, (double)0.75));
        g3.drawLine(0, h2 - 1, w2, h2 - 1);
        g3.drawLine(w2 - 1, 0, w2 - 1, h2 - 1);
        Enumeration<TableColumn> columns = ((JTableHeader)c2).getColumnModel().getColumns();
        Color lineColor = ColorUtil.shift((Color)bg, (double)0.7);
        Color shadow = Gray._255.withAlpha(30);
        int offset = 0;
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            if (!columns.hasMoreElements() || column.getWidth() <= 0) continue;
            g3.setColor(lineColor);
            g3.drawLine((offset += column.getWidth()) - 1, 1, offset - 1, h2 - 3);
            g3.setColor(shadow);
            g3.drawLine(offset, 1, offset, h2 - 3);
        }
        config.restore();
        super.paint(g3, c2);
    }
}

