/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.Gray;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class DarculaButtonPainter
implements Border,
UIResource {
    private static final int myOffset = 4;

    @Override
    public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        Graphics2D g2d = (Graphics2D)g2;
        Insets ins = this.getBorderInsets(c2);
        int yOff = (ins.top + ins.bottom) / 4;
        boolean square = DarculaButtonUI.isSquare(c2);
        int offset = JBUI.scale((int)(square ? 1 : this.getOffset()));
        int w2 = c2.getWidth();
        int h2 = c2.getHeight();
        int diam = JBUI.scale((int)22);
        if (c2.hasFocus()) {
            if (DarculaButtonUI.isHelpButton((JComponent)c2)) {
                DarculaUIUtil.paintFocusOval(g2d, (w2 - diam) / 2, (h2 - diam) / 2, diam, diam);
            } else {
                DarculaUIUtil.paintFocusRing(g2d, new Rectangle(offset, yOff, width - 2 * offset, height - 2 * yOff));
            }
        } else {
            GraphicsConfig config = new GraphicsConfig(g2);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
            g2d.setPaint(UIUtil.getGradientPaint((float)(width / 2), (float)(y2 + yOff + JBUI.scale((int)1)), (Color)Gray._80.withAlpha(90), (float)(width / 2), (float)(height - 2 * yOff), (Color)Gray._90.withAlpha(90)));
            ((Graphics2D)g2).setPaint(this.getBorderColor());
            if (DarculaButtonUI.isHelpButton((JComponent)c2)) {
                g2.drawOval((w2 - diam) / 2, (h2 - diam) / 2, diam, diam);
            } else {
                g2.translate(x2, y2);
                int r2 = JBUI.scale((int)(square ? 3 : 5));
                g2.drawRoundRect(offset, yOff, width - 2 * offset, height - 2 * yOff, r2, r2);
                g2.translate(-x2, -y2);
            }
            config.restore();
        }
    }

    protected Color getBorderColor() {
        return Gray._100.withAlpha(180);
    }

    @Override
    public Insets getBorderInsets(Component c2) {
        if (c2.getParent() instanceof ActionToolbar) {
            return JBUI.insets((int)4, (int)16, (int)4, (int)16);
        }
        if (DarculaButtonUI.isSquare(c2)) {
            return JBUI.insets((int)2, (int)0, (int)2, (int)0).asUIResource();
        }
        return JBUI.insets((int)8, (int)16, (int)8, (int)14).asUIResource();
    }

    protected int getOffset() {
        return 4;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

