/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonUI;
import sun.swing.SwingUtilities2;

public class DarculaButtonUI
extends BasicButtonUI {
    public static ComponentUI createUI(JComponent c2) {
        return new DarculaButtonUI();
    }

    public static boolean isSquare(Component c2) {
        return c2 instanceof JButton && "square".equals(((JButton)c2).getClientProperty("JButton.buttonType"));
    }

    public static boolean isDefaultButton(JComponent c2) {
        return c2 instanceof JButton && ((JButton)c2).isDefaultButton();
    }

    protected boolean paintDecorations(Graphics2D g2, JComponent c2) {
        int w2 = c2.getWidth();
        int h2 = c2.getHeight();
        if (DarculaButtonUI.isHelpButton(c2)) {
            g2.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.getButtonColor1(), (float)0.0f, (float)h2, (Color)this.getButtonColor2()));
            int off = JBUI.scale((int)22);
            int x2 = (w2 - off) / 2;
            int y2 = (h2 - off) / 2;
            g2.fillOval(x2, y2, off, off);
            AllIcons.Actions.Help.paintIcon(c2, g2, x2 + JBUI.scale((int)3), y2 + JBUI.scale((int)3));
            return false;
        }
        Border border = c2.getBorder();
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g2);
        boolean square = DarculaButtonUI.isSquare(c2);
        if (c2.isEnabled() && border != null) {
            Insets ins = border.getBorderInsets(c2);
            int yOff = (ins.top + ins.bottom) / 4;
            if (!square) {
                if (DarculaButtonUI.isDefaultButton(c2)) {
                    g2.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.getSelectedButtonColor1(), (float)0.0f, (float)h2, (Color)this.getSelectedButtonColor2()));
                } else {
                    g2.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.getButtonColor1(), (float)0.0f, (float)h2, (Color)this.getButtonColor2()));
                }
            }
            int rad = JBUI.scale((int)(square ? 3 : 5));
            g2.fillRoundRect(JBUI.scale((int)(square ? 2 : 4)), yOff, w2 - 2 * JBUI.scale((int)4), h2 - 2 * yOff, rad, rad);
        }
        config.restore();
        return true;
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        if (this.paintDecorations((Graphics2D)g2, c2)) {
            super.paint(g2, c2);
        }
    }

    @Override
    protected void paintText(Graphics g2, JComponent c2, Rectangle textRect, String text2) {
        int mnemonicIndex;
        Color selectedFg;
        if (DarculaButtonUI.isHelpButton(c2)) {
            return;
        }
        AbstractButton button = (AbstractButton)c2;
        ButtonModel model2 = button.getModel();
        Color fg = button.getForeground();
        if (fg instanceof UIResource && DarculaButtonUI.isDefaultButton(button) && (selectedFg = UIManager.getColor("Button.darcula.selectedButtonForeground")) != null) {
            fg = selectedFg;
        }
        g2.setColor(fg);
        FontMetrics metrics = SwingUtilities2.getFontMetrics(c2, g2);
        int n2 = mnemonicIndex = DarculaLaf.isAltPressed() ? button.getDisplayedMnemonicIndex() : -1;
        if (model2.isEnabled()) {
            SwingUtilities2.drawStringUnderlineCharAt(c2, g2, text2, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + metrics.getAscent() + this.getTextShiftOffset());
        } else {
            this.paintDisabledText(g2, text2, c2, textRect, metrics);
        }
    }

    protected void paintDisabledText(Graphics g2, String text2, JComponent c2, Rectangle textRect, FontMetrics metrics) {
        g2.setColor(UIManager.getColor("Button.darcula.disabledText.shadow"));
        SwingUtilities2.drawStringUnderlineCharAt(c2, g2, text2, -1, textRect.x + this.getTextShiftOffset() + 1, textRect.y + metrics.getAscent() + this.getTextShiftOffset() + 1);
        g2.setColor(UIManager.getColor("Button.disabledText"));
        SwingUtilities2.drawStringUnderlineCharAt(c2, g2, text2, -1, textRect.x + this.getTextShiftOffset(), textRect.y + metrics.getAscent() + this.getTextShiftOffset());
    }

    @Override
    protected void paintIcon(Graphics g2, JComponent c2, Rectangle iconRect) {
        Border border = c2.getBorder();
        if (border != null && DarculaButtonUI.isSquare(c2)) {
            int xOff = 1;
            Insets ins = border.getBorderInsets(c2);
            int yOff = (ins.top + ins.bottom) / 4;
            Rectangle iconRect2 = new Rectangle(iconRect);
            iconRect2.x += xOff;
            iconRect2.y += yOff;
            super.paintIcon(g2, c2, iconRect2);
        } else {
            super.paintIcon(g2, c2, iconRect);
        }
    }

    @Override
    public void update(Graphics g2, JComponent c2) {
        super.update(g2, c2);
        if (DarculaButtonUI.isDefaultButton(c2)) {
            this.setupDefaultButton((JButton)c2);
        }
    }

    protected void setupDefaultButton(JButton button) {
        if (!SystemInfo.isMac && !button.getFont().isBold()) {
            button.setFont(new FontUIResource(button.getFont().deriveFont(1)));
        }
    }

    public static boolean isHelpButton(JComponent button) {
        return (SystemInfo.isMac || UIUtil.isUnderDarcula() || UIUtil.isUnderWin10LookAndFeel()) && button instanceof JButton && "help".equals(button.getClientProperty("JButton.buttonType"));
    }

    protected Color getButtonColor1() {
        return (Color)ObjectUtils.notNull((Object)UIManager.getColor("Button.darcula.color1"), (Object)new ColorUIResource(0x555A5C));
    }

    protected Color getButtonColor2() {
        return (Color)ObjectUtils.notNull((Object)UIManager.getColor("Button.darcula.color2"), (Object)new ColorUIResource(4277832));
    }

    protected Color getSelectedButtonColor1() {
        return (Color)ObjectUtils.notNull((Object)UIManager.getColor("Button.darcula.selection.color1"), (Object)new ColorUIResource(3690347));
    }

    protected Color getSelectedButtonColor2() {
        return (Color)ObjectUtils.notNull((Object)UIManager.getColor("Button.darcula.selection.color2"), (Object)new ColorUIResource(2306371));
    }
}

