/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.Gray;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalCheckBoxUI;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class DarculaCheckBoxUI
extends MetalCheckBoxUI {
    public static ComponentUI createUI(JComponent c2) {
        if (UIUtil.getParentOfType(CellRendererPane.class, (Component)c2) != null) {
            c2.setBorder(null);
        }
        return new DarculaCheckBoxUI();
    }

    @Override
    public synchronized void paint(Graphics g2d, JComponent c2) {
        Graphics2D g2 = (Graphics2D)g2d;
        JCheckBox b2 = (JCheckBox)c2;
        Dimension size = c2.getSize();
        Font font = c2.getFont();
        g2.setFont(font);
        FontMetrics fm = SwingUtilities2.getFontMetrics(c2, g2, font);
        Rectangle viewRect = new Rectangle(size);
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        JBInsets.removeFrom((Rectangle)viewRect, (Insets)c2.getInsets());
        String text2 = SwingUtilities.layoutCompoundLabel(c2, fm, b2.getText(), this.getDefaultIcon(), b2.getVerticalAlignment(), b2.getHorizontalAlignment(), b2.getVerticalTextPosition(), b2.getHorizontalTextPosition(), viewRect, iconRect, textRect, b2.getIconTextGap());
        if (c2.isOpaque()) {
            g2.setColor(b2.getBackground());
            g2.fillRect(0, 0, size.width, size.height);
        }
        boolean selected = b2.isSelected();
        boolean enabled = b2.isEnabled();
        this.drawCheckIcon(c2, g2, b2, iconRect, selected, enabled);
        this.drawText(c2, g2, b2, fm, textRect, text2);
    }

    protected void drawCheckIcon(JComponent c2, Graphics2D g2, JCheckBox b2, Rectangle iconRect, boolean selected, boolean enabled) {
        if (selected && b2.getSelectedIcon() != null) {
            b2.getSelectedIcon().paintIcon(b2, g2, iconRect.x + JBUI.scale((int)4), iconRect.y + JBUI.scale((int)2));
        } else if (!selected && b2.getIcon() != null) {
            b2.getIcon().paintIcon(b2, g2, iconRect.x + JBUI.scale((int)4), iconRect.y + JBUI.scale((int)2));
        } else {
            int off = JBUI.scale((int)3);
            int x2 = iconRect.x + off;
            int y2 = iconRect.y + off;
            int w2 = iconRect.width - 2 * off;
            int h2 = iconRect.height - 2 * off;
            g2.translate(x2, y2);
            Paint paint = UIUtil.getGradientPaint((float)(w2 / 2), (float)0.0f, (Color)b2.getBackground().brighter(), (float)(w2 / 2), (float)h2, (Color)b2.getBackground());
            g2.setPaint(paint);
            int fillOffset = JBUI.scale((int)1);
            g2.fillRect(fillOffset, fillOffset, w2 - 2 * fillOffset, h2 - 2 * fillOffset);
            GraphicsConfig config = new GraphicsConfig((Graphics)g2);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
            boolean armed = b2.getModel().isArmed();
            int R = JBUI.scale((int)4);
            if (c2.hasFocus()) {
                g2.setPaint(UIUtil.getGradientPaint((float)(w2 / 2), (float)1.0f, (Color)this.getFocusedBackgroundColor1(armed, selected), (float)(w2 / 2), (float)h2, (Color)this.getFocusedBackgroundColor2(armed, selected)));
                g2.fillRoundRect(0, 0, w2, h2, R, R);
                DarculaUIUtil.paintFocusRing(g2, new Rectangle(1, 1, w2 - 2, h2 - 2));
            } else {
                g2.setPaint(UIUtil.getGradientPaint((float)(w2 / 2), (float)1.0f, (Color)this.getBackgroundColor1(enabled, selected), (float)(w2 / 2), (float)h2, (Color)this.getBackgroundColor2(enabled, selected)));
                g2.fillRoundRect(0, 0, w2, h2, R, R);
                Color borderColor1 = this.getBorderColor1(enabled, selected);
                Color borderColor2 = this.getBorderColor2(enabled, selected);
                g2.setPaint(UIUtil.getGradientPaint((float)(w2 / 2), (float)1.0f, (Color)borderColor1, (float)(w2 / 2), (float)h2, (Color)borderColor2));
                g2.drawRoundRect(0, UIUtil.isUnderDarcula() ? 1 : 0, w2, h2 - 1, R, R);
                g2.setPaint(this.getInactiveFillColor());
                g2.drawRoundRect(0, 0, w2, h2 - 1, R, R);
            }
            if (b2.getModel().isSelected()) {
                this.paintCheckSign(g2, enabled, w2, h2);
            }
            g2.translate(-x2, -y2);
            config.restore();
        }
    }

    protected void drawText(JComponent c2, Graphics2D g2, JCheckBox b2, FontMetrics fm, Rectangle textRect, String text2) {
        if (text2 != null) {
            View view2 = (View)c2.getClientProperty("html");
            if (view2 != null) {
                view2.paint(g2, textRect);
            } else {
                g2.setColor(b2.isEnabled() ? b2.getForeground() : this.getDisabledTextColor());
                SwingUtilities2.drawStringUnderlineCharAt(c2, g2, text2, b2.getDisplayedMnemonicIndex(), textRect.x, textRect.y + fm.getAscent());
            }
        }
    }

    protected void paintCheckSign(Graphics2D g2, boolean enabled, int w2, int h2) {
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setStroke(new BasicStroke(1.0f * JBUI.scale((float)2.0f), 1, 1));
        g2.setPaint(this.getShadowColor(enabled, true));
        int x1 = JBUI.scale((int)4);
        int y1 = JBUI.scale((int)7);
        int x2 = JBUI.scale((int)7);
        int y2 = JBUI.scale((int)11);
        int x3 = w2;
        int y3 = JBUI.scale((int)2);
        g2.drawLine(x1, y1, x2, y2);
        g2.drawLine(x2, y2, x3, y3);
        g2.setPaint(this.getCheckSignColor(enabled, true));
        g2.translate(0, -2);
        g2.drawLine(x1, y1, x2, y2);
        g2.drawLine(x2, y2, x3, y3);
        g2.translate(0, 2);
    }

    protected Color getInactiveFillColor() {
        return DarculaCheckBoxUI.getColor("inactiveFillColor", Gray._40.withAlpha(180));
    }

    protected Color getBorderColor1(boolean enabled, boolean selected) {
        return enabled ? DarculaCheckBoxUI.getColor("borderColor1", Gray._120.withAlpha(90), selected) : DarculaCheckBoxUI.getColor("disabledBorderColor1", Gray._120.withAlpha(90), selected);
    }

    protected Color getBorderColor2(boolean enabled, boolean selected) {
        return enabled ? DarculaCheckBoxUI.getColor("borderColor2", Gray._105.withAlpha(90), selected) : DarculaCheckBoxUI.getColor("disabledBorderColor2", Gray._105.withAlpha(90), selected);
    }

    protected Color getBackgroundColor1(boolean enabled, boolean selected) {
        return DarculaCheckBoxUI.getColor("backgroundColor1", (Color)Gray._110, selected);
    }

    protected Color getBackgroundColor2(boolean enabled, boolean selected) {
        return DarculaCheckBoxUI.getColor("backgroundColor2", (Color)Gray._95, selected);
    }

    protected Color getCheckSignColor(boolean enabled, boolean selected) {
        return enabled ? DarculaCheckBoxUI.getColor("checkSignColor", (Color)Gray._170, selected) : DarculaCheckBoxUI.getColor("checkSignColorDisabled", (Color)Gray._120, selected);
    }

    protected Color getShadowColor(boolean enabled, boolean selected) {
        return enabled ? DarculaCheckBoxUI.getColor("shadowColor", (Color)Gray._30, selected) : DarculaCheckBoxUI.getColor("shadowColorDisabled", (Color)Gray._60, selected);
    }

    protected Color getFocusedBackgroundColor1(boolean armed, boolean selected) {
        return armed ? DarculaCheckBoxUI.getColor("focusedArmed.backgroundColor1", (Color)Gray._100, selected) : DarculaCheckBoxUI.getColor("focused.backgroundColor1", (Color)Gray._120, selected);
    }

    protected Color getFocusedBackgroundColor2(boolean armed, boolean selected) {
        return armed ? DarculaCheckBoxUI.getColor("focusedArmed.backgroundColor2", (Color)Gray._55, selected) : DarculaCheckBoxUI.getColor("focused.backgroundColor2", (Color)Gray._75, selected);
    }

    protected static Color getColor(String shortPropertyName, Color defaultValue) {
        Color color = UIManager.getColor("CheckBox.darcula." + shortPropertyName);
        return color == null ? defaultValue : color;
    }

    protected static Color getColor(String shortPropertyName, Color defaultValue, boolean selected) {
        Color color;
        if (selected && (color = DarculaCheckBoxUI.getColor(shortPropertyName + ".selected", null)) != null) {
            return color;
        }
        return DarculaCheckBoxUI.getColor(shortPropertyName, defaultValue);
    }

    @Override
    public Icon getDefaultIcon() {
        return EmptyIcon.create((int)JBUI.scale((int)20)).asUIResource();
    }
}

