/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Path2D;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxUI;
import sun.swing.DefaultLookup;

public class DarculaComboBoxUI
extends BasicComboBoxUI
implements Border {
    private final JComboBox myComboBox;
    private Dimension myDisplaySizeCache = JBUI.emptySize();
    private Insets myPadding;

    public DarculaComboBoxUI(JComboBox comboBox) {
        this.myComboBox = comboBox;
        this.myComboBox.setBorder(this);
    }

    public static ComponentUI createUI(JComponent c2) {
        return new DarculaComboBoxUI((JComboBox)c2);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.myPadding = UIManager.getInsets("ComboBox.padding");
    }

    @Override
    protected JButton createArrowButton() {
        Color bg = this.myComboBox.getBackground();
        Color fg = this.myComboBox.getForeground();
        BasicArrowButton button = new BasicArrowButton(5, bg, fg, fg, fg){

            @Override
            public void paint(Graphics g2) {
                Graphics2D g3 = (Graphics2D)g2;
                GraphicsConfig config = new GraphicsConfig((Graphics)g3);
                int w2 = this.getWidth();
                int h2 = this.getHeight();
                if (!DarculaComboBoxUI.isTableCellEditor(DarculaComboBoxUI.this.myComboBox)) {
                    g3.setColor(DarculaComboBoxUI.this.getArrowButtonFillColor(UIUtil.getControlColor()));
                    g3.fillRect(0, 0, w2, h2);
                }
                g3.setColor((Color)(DarculaComboBoxUI.this.comboBox.isEnabled() ? new JBColor((Color)Gray._255, this.getForeground()) : new JBColor((Color)Gray._255, DarculaComboBoxUI.this.getBorderColor())));
                config.setupRoundedBorderAntialiasing();
                int tW = JBUI.scale((int)8);
                int tH = JBUI.scale((int)6);
                int xU = (w2 - tW) / 2;
                int yU = (h2 - tH) / 2;
                g3.translate(JBUI.scale((int)2), JBUI.scale((int)1));
                Path2D.Double path = new Path2D.Double();
                path.moveTo(xU, yU);
                path.lineTo(xU + tW, yU);
                path.lineTo(xU + tW / 2, yU + tH);
                path.lineTo(xU, yU);
                path.closePath();
                g3.fill(path);
                g3.translate(-JBUI.scale((int)2), -JBUI.scale((int)1));
                if (!DarculaComboBoxUI.isTableCellEditor(DarculaComboBoxUI.this.myComboBox)) {
                    g3.setColor(DarculaComboBoxUI.this.getArrowButtonFillColor(DarculaComboBoxUI.this.getBorderColor()));
                    g3.drawLine(0, -1, 0, h2);
                }
                config.restore();
            }

            @Override
            public Dimension getPreferredSize() {
                int size = this.getFont().getSize() + 4;
                if (size % 2 == 1) {
                    ++size;
                }
                return new DimensionUIResource(size, size);
            }
        };
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setOpaque(false);
        return button;
    }

    protected Color getArrowButtonFillColor(Color defaultColor) {
        Color color;
        Color color2 = color = this.myComboBox.hasFocus() ? UIManager.getColor("ComboBox.darcula.arrowFocusedFillColor") : UIManager.getColor("ComboBox.darcula.arrowFillColor");
        return color == null ? defaultColor : (this.comboBox != null && !this.comboBox.isEnabled() ? new JBColor(this.getBorderColor(), UIUtil.getControlColor()) : color);
    }

    @Override
    protected Insets getInsets() {
        return JBUI.insets((int)4, (int)7, (int)4, (int)5).asUIResource();
    }

    @Override
    protected Dimension getDisplaySize() {
        Dimension display = new Dimension();
        DefaultListCellRenderer renderer = this.comboBox.getRenderer();
        if (renderer == null) {
            renderer = new DefaultListCellRenderer();
        }
        boolean sameBaseline = true;
        Object prototypeValue = this.comboBox.getPrototypeDisplayValue();
        if (prototypeValue != null) {
            display = this.getSizeForComponent(renderer.getListCellRendererComponent(this.listBox, prototypeValue, -1, false, false));
        } else {
            ComboBoxModel model2 = this.comboBox.getModel();
            int baseline = -1;
            if (model2.getSize() > 0) {
                for (int i2 = 0; i2 < model2.getSize(); ++i2) {
                    Object value2 = model2.getElementAt(i2);
                    Component rendererComponent = renderer.getListCellRendererComponent(this.listBox, value2, -1, false, false);
                    Dimension d2 = this.getSizeForComponent(rendererComponent);
                    if (!(!sameBaseline || value2 == null || value2 instanceof String && "".equals(value2))) {
                        int newBaseline = rendererComponent.getBaseline(d2.width, d2.height);
                        if (newBaseline == -1) {
                            sameBaseline = false;
                        } else if (baseline == -1) {
                            baseline = newBaseline;
                        } else if (baseline != newBaseline) {
                            sameBaseline = false;
                        }
                    }
                    display.width = Math.max(display.width, d2.width);
                    display.height = Math.max(display.height, d2.height);
                }
            } else {
                display = this.getDefaultSize();
                if (this.comboBox.isEditable()) {
                    display.width = JBUI.scale((int)100);
                }
            }
        }
        JBInsets.addTo((Dimension)display, (Insets)this.myPadding);
        this.myDisplaySizeCache.setSize(display.width, display.height);
        return display;
    }

    @Override
    protected Dimension getSizeForComponent(Component comp) {
        this.currentValuePane.add(comp);
        comp.setFont(this.comboBox.getFont());
        Dimension d2 = comp.getPreferredSize();
        this.currentValuePane.remove(comp);
        return d2;
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        Container parent = c2.getParent();
        if (parent != null) {
            g2.setColor(DarculaComboBoxUI.isTableCellEditor(c2) && this.editor != null ? this.editor.getBackground() : parent.getBackground());
            g2.fillRect(0, 0, c2.getWidth(), c2.getHeight());
        }
        Rectangle r2 = this.rectangleForCurrentValue();
        if (!DarculaComboBoxUI.isTableCellEditor(c2)) {
            this.paintBorder(c2, g2, 0, 0, c2.getWidth(), c2.getHeight());
            this.hasFocus = this.comboBox.hasFocus();
            this.paintCurrentValueBackground(g2, r2, this.hasFocus);
        }
        this.paintCurrentValue(g2, r2, this.hasFocus);
    }

    protected static boolean isTableCellEditor(JComponent c2) {
        return Boolean.TRUE.equals(c2.getClientProperty("JComboBox.isTableCellEditor")) || c2.getParent() instanceof JTable;
    }

    @Override
    protected Rectangle rectangleForCurrentValue() {
        Rectangle r2 = super.rectangleForCurrentValue();
        r2.x -= JBUI.scale((int)2);
        return r2;
    }

    @Override
    public void paintCurrentValue(Graphics g2, Rectangle bounds, boolean hasFocus) {
        boolean changeOpaque;
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        Component c2 = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
        if (!hasFocus || this.isPopupVisible(this.comboBox)) {
            c2.setBackground(UIManager.getColor("ComboBox.background"));
        }
        c2.setFont(this.comboBox.getFont());
        if (hasFocus && !this.isPopupVisible(this.comboBox)) {
            c2.setForeground(this.listBox.getForeground());
            c2.setBackground(this.listBox.getBackground());
        } else if (this.comboBox.isEnabled()) {
            c2.setForeground(this.comboBox.getForeground());
            c2.setBackground(this.comboBox.getBackground());
        } else {
            c2.setForeground(DefaultLookup.getColor(this.comboBox, this, "ComboBox.disabledForeground", null));
            c2.setBackground(DefaultLookup.getColor(this.comboBox, this, "ComboBox.disabledBackground", null));
        }
        boolean bl = changeOpaque = c2 instanceof JComponent && DarculaComboBoxUI.isTableCellEditor(this.comboBox) && c2.isOpaque();
        if (changeOpaque) {
            ((JComponent)c2).setOpaque(false);
        }
        boolean shouldValidate = false;
        if (c2 instanceof JPanel) {
            shouldValidate = true;
        }
        Rectangle r2 = new Rectangle(bounds);
        JBInsets.removeFrom((Rectangle)r2, (Insets)this.myPadding);
        this.currentValuePane.paintComponent(g2, c2, this.comboBox, r2.x, r2.y, r2.width, r2.height, shouldValidate);
        if (changeOpaque) {
            ((JComponent)c2).setOpaque(true);
        }
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
    }

    @Override
    protected ComboBoxEditor createEditor() {
        Component editor;
        ComboBoxEditor comboBoxEditor = super.createEditor();
        Component component = editor = comboBoxEditor == null ? null : comboBoxEditor.getEditorComponent();
        if (editor instanceof JComponent) {
            ((JComponent)editor).setBorder((Border)JBUI.Borders.empty());
        }
        if (editor != null) {
            editor.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e2) {
                    this.process(e2);
                }

                private void process(KeyEvent e2) {
                    int code2 = e2.getKeyCode();
                    if ((code2 == 38 || code2 == 40) && e2.getModifiers() == 0) {
                        DarculaComboBoxUI.this.comboBox.dispatchEvent(e2);
                    }
                }

                @Override
                public void keyReleased(KeyEvent e2) {
                    this.process(e2);
                }
            });
            editor.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e2) {
                    this.update();
                }

                void update() {
                    if (DarculaComboBoxUI.this.comboBox != null) {
                        DarculaComboBoxUI.this.comboBox.revalidate();
                        DarculaComboBoxUI.this.comboBox.repaint();
                    }
                }

                @Override
                public void focusLost(FocusEvent e2) {
                    this.update();
                }
            });
        }
        return comboBoxEditor;
    }

    @Override
    public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        if (this.comboBox == null || this.arrowButton == null) {
            return;
        }
        this.hasFocus = false;
        this.checkFocus();
        Graphics2D g3 = (Graphics2D)g2.create();
        Rectangle arrowButtonBounds = this.arrowButton.getBounds();
        int xxx = arrowButtonBounds.x - JBUI.scale((int)5);
        int H = height - JBUI.scale((int)2);
        int W = width - JBUI.scale((int)2);
        Shape clip = g3.getClip();
        g3.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g3.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int R = JBUI.scale((int)5);
        if (this.hasFocus) {
            g3.clipRect(JBUI.scale((int)2), JBUI.scale((int)2), this.comboBox.getWidth() - JBUI.scale((int)4), this.comboBox.getHeight() - JBUI.scale((int)4));
        }
        Color background = this.editor != null && this.comboBox.isEditable() ? this.editor.getBackground() : UIUtil.getPanelBackground();
        g3.setColor(background);
        g3.fillRoundRect(x2 + JBUI.scale((int)1), y2 + JBUI.scale((int)1), W, H, R, R);
        g3.setColor(this.getArrowButtonFillColor(this.arrowButton.getBackground()));
        g3.fillRoundRect(xxx, y2 + JBUI.scale((int)1), width - xxx, H, R, R);
        g3.setColor(background);
        g3.fillRect(xxx, y2 + JBUI.scale((int)1), JBUI.scale((int)5), H);
        Color borderColor = this.getBorderColor();
        g3.setColor(this.getArrowButtonFillColor(borderColor));
        int off = this.hasFocus ? 1 : 0;
        g3.drawLine(xxx + JBUI.scale((int)5), y2 + JBUI.scale((int)1) + off, xxx + JBUI.scale((int)5), height - JBUI.scale((int)2));
        Rectangle r2 = this.rectangleForCurrentValue();
        this.paintCurrentValueBackground(g3, r2, this.hasFocus);
        this.paintCurrentValue(g3, r2, false);
        if (this.hasFocus) {
            g3.setClip(clip);
            DarculaUIUtil.paintFocusRing(g3, new Rectangle(JBUI.scale((int)2), JBUI.scale((int)2), width - JBUI.scale((int)4), height - JBUI.scale((int)4)));
        } else {
            g3.setColor(borderColor);
            g3.drawRoundRect(JBUI.scale((int)1), JBUI.scale((int)1), width - JBUI.scale((int)2), height - JBUI.scale((int)2), R, R);
            if (!UIUtil.isUnderDarcula() && this.comboBox.isEnabled()) {
                g3.setColor(this.getArrowButtonFillColor(this.getBorderColor()));
                int offX = xxx + JBUI.scale((int)5);
                g3.clipRect(offX, y2, width - offX, height);
                g3.drawRoundRect(JBUI.scale((int)1), JBUI.scale((int)1), width - JBUI.scale((int)2), height - JBUI.scale((int)2), R, R);
            }
        }
        g3.dispose();
    }

    protected void checkFocus() {
        if (!this.comboBox.isEnabled()) {
            this.hasFocus = false;
            return;
        }
        this.hasFocus = DarculaComboBoxUI.hasFocus(this.comboBox);
        if (this.hasFocus) {
            return;
        }
        ComboBoxEditor ed = this.comboBox.getEditor();
        Component component = this.editor = ed == null ? null : ed.getEditorComponent();
        if (this.editor != null) {
            this.hasFocus = DarculaComboBoxUI.hasFocus(this.editor);
        }
    }

    protected static boolean hasFocus(Component c2) {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return owner != null && SwingUtilities.isDescendingFrom(owner, c2);
    }

    private Color getBorderColor() {
        if (this.comboBox != null && this.myComboBox.isEnabled()) {
            return new JBColor((Color)Gray._150, (Color)Gray._100);
        }
        return new JBColor((Color)Gray._150, (Color)Gray._88);
    }

    @Override
    public Insets getBorderInsets(Component c2) {
        return new InsetsUIResource(4, 7, 4, 5);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    protected void configureEditor() {
        super.configureEditor();
        if (Registry.is((String)"ide.ui.composite.editor.for.combobox") && this.editor instanceof JPanel) {
            this.editor.setFocusable(false);
        }
    }
}

