/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.plaf.InsetsUIResource;

public class DarculaEditorTextFieldBorder
implements Border {
    @Override
    public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        if (DarculaEditorTextFieldBorder.isComboBoxEditor(c2)) {
            g2.setColor(c2.getBackground());
            g2.fillRect(x2, y2, width, height);
            return;
        }
        EditorTextField textField = (EditorTextField)UIUtil.getParentOfType(EditorTextField.class, (Component)c2);
        if (textField == null) {
            return;
        }
        Rectangle r2 = new Rectangle(x2 + 1, y2 + 1, width - 2, height - 2);
        if (c2.isOpaque()) {
            g2.setColor(UIUtil.getPanelBackground());
            g2.fillRect(x2, y2, width, height);
        }
        g2.setColor(c2.getBackground());
        g2.fillRect(r2.x, r2.y, r2.width, r2.height);
        if (!textField.isEnabled()) {
            ((Graphics2D)g2).setComposite(AlphaComposite.getInstance(3, 0.4f));
        }
        if (textField.isEnabled() && textField.isVisible() && textField.getFocusTarget().hasFocus()) {
            DarculaUIUtil.paintFocusRing(g2, new Rectangle(r2.x + 1, r2.y + 1, r2.width - 2, r2.height - 2));
        } else {
            g2.setColor((Color)new JBColor((Color)Gray._150, (Color)Gray._100));
            g2.drawRect(r2.x, r2.y, r2.width, r2.height);
        }
    }

    @Override
    public Insets getBorderInsets(Component c2) {
        if (DarculaEditorTextFieldBorder.isComboBoxEditor(c2)) {
            return new InsetsUIResource(2, 3, 2, 3);
        }
        return new InsetsUIResource(4, 7, 4, 7);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    public static boolean isComboBoxEditor(Component c2) {
        return UIUtil.getParentOfType(JComboBox.class, (Component)c2) != null;
    }

    public static boolean isCellEditor(Component c2) {
        return UIUtil.getParentOfType(JTable.class, (Component)c2) != null;
    }
}

