/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.util.ui.JBInsets;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;
import sun.swing.MenuItemLayoutHelper;
import sun.swing.SwingUtilities2;

public class DarculaMenuItemUIBase
extends BasicMenuItemUI {
    public static ComponentUI createUI(JComponent c2) {
        return new DarculaMenuItemUIBase();
    }

    public void processMouseEvent(JMenuItem item, MouseEvent e2, MenuElement[] path, MenuSelectionManager manager) {
        Point p2 = e2.getPoint();
        if (p2.x >= 0 && p2.x < item.getWidth() && p2.y >= 0 && p2.y < item.getHeight()) {
            if (e2.getID() == 502) {
                manager.clearSelectedPath();
                item.doClick(0);
                item.setArmed(false);
            } else {
                manager.setSelectedPath(path);
            }
        } else if (item.getModel().isArmed()) {
            MenuElement[] newPath = new MenuElement[path.length - 1];
            int c2 = path.length - 1;
            for (int i2 = 0; i2 < c2; ++i2) {
                newPath[i2] = path[i2];
            }
            manager.setSelectedPath(newPath);
        }
    }

    @Override
    protected void paintMenuItem(Graphics g2, JComponent c2, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        Font holdf = g2.getFont();
        Color holdc = g2.getColor();
        JMenuItem mi = (JMenuItem)c2;
        g2.setFont(mi.getFont());
        Rectangle viewRect = new Rectangle(0, 0, mi.getWidth(), mi.getHeight());
        JBInsets.removeFrom((Rectangle)viewRect, (Insets)mi.getInsets());
        MenuItemLayoutHelper lh = new MenuItemLayoutHelper(mi, checkIcon, arrowIcon, viewRect, defaultTextIconGap, "-", mi.getComponentOrientation().isLeftToRight(), mi.getFont(), this.acceleratorFont, MenuItemLayoutHelper.useCheckAndArrow(this.menuItem), this.getPropertyPrefix());
        MenuItemLayoutHelper.LayoutResult lr = lh.layoutMenuItem();
        this.paintBackground(g2, mi, background);
        this.paintCheckIcon(g2, lh, lr, holdc, foreground);
        this.paintIcon(g2, lh, lr, holdc);
        g2.setColor(foreground);
        UISettings.setupAntialiasing((Graphics)g2);
        this.paintText(g2, lh, lr);
        this.paintAccText(g2, lh, lr);
        this.paintArrowIcon(g2, lh, lr, foreground);
        g2.setColor(holdc);
        g2.setFont(holdf);
    }

    protected void paintIcon(Graphics g2, MenuItemLayoutHelper lh, MenuItemLayoutHelper.LayoutResult lr, Color holdc) {
        if (lh.getIcon() != null) {
            Icon icon;
            ButtonModel model2 = lh.getMenuItem().getModel();
            if (!model2.isEnabled()) {
                icon = lh.getMenuItem().getDisabledIcon();
            } else if (model2.isPressed() && model2.isArmed()) {
                icon = lh.getMenuItem().getPressedIcon();
                if (icon == null) {
                    icon = lh.getMenuItem().getIcon();
                }
            } else {
                icon = lh.getMenuItem().getIcon();
            }
            if (icon != null) {
                icon.paintIcon(lh.getMenuItem(), g2, lr.getIconRect().x, lr.getIconRect().y);
                g2.setColor(holdc);
            }
        }
    }

    protected void paintCheckIcon(Graphics g2, MenuItemLayoutHelper lh, MenuItemLayoutHelper.LayoutResult lr, Color holdc, Color foreground) {
        if (lh.getCheckIcon() != null) {
            ButtonModel model2 = lh.getMenuItem().getModel();
            if (model2.isArmed() || lh.getMenuItem() instanceof JMenu && model2.isSelected()) {
                g2.setColor(foreground);
            } else {
                g2.setColor(holdc);
            }
            if (lh.useCheckAndArrow()) {
                lh.getCheckIcon().paintIcon(lh.getMenuItem(), g2, lr.getCheckRect().x, lr.getCheckRect().y);
            }
            g2.setColor(holdc);
        }
    }

    protected void paintAccText(Graphics g2, MenuItemLayoutHelper lh, MenuItemLayoutHelper.LayoutResult lr) {
        if (!lh.getAccText().equals("")) {
            ButtonModel model2 = lh.getMenuItem().getModel();
            g2.setFont(lh.getAccFontMetrics().getFont());
            if (!model2.isEnabled()) {
                if (this.disabledForeground != null) {
                    g2.setColor(this.disabledForeground);
                    SwingUtilities2.drawString((JComponent)lh.getMenuItem(), g2, lh.getAccText(), lr.getAccRect().x, lr.getAccRect().y + lh.getAccFontMetrics().getAscent());
                } else {
                    g2.setColor(lh.getMenuItem().getBackground().brighter());
                    SwingUtilities2.drawString((JComponent)lh.getMenuItem(), g2, lh.getAccText(), lr.getAccRect().x, lr.getAccRect().y + lh.getAccFontMetrics().getAscent());
                    g2.setColor(lh.getMenuItem().getBackground().darker());
                    SwingUtilities2.drawString((JComponent)lh.getMenuItem(), g2, lh.getAccText(), lr.getAccRect().x - 1, lr.getAccRect().y + lh.getFontMetrics().getAscent() - 1);
                }
            } else {
                if (model2.isArmed() || lh.getMenuItem() instanceof JMenu && model2.isSelected()) {
                    g2.setColor(this.acceleratorSelectionForeground);
                } else {
                    g2.setColor(this.acceleratorForeground);
                }
                SwingUtilities2.drawString((JComponent)lh.getMenuItem(), g2, lh.getAccText(), lr.getAccRect().x, lr.getAccRect().y + lh.getAccFontMetrics().getAscent());
            }
        }
    }

    protected void paintText(Graphics g2, MenuItemLayoutHelper lh, MenuItemLayoutHelper.LayoutResult lr) {
        if (!lh.getText().equals("")) {
            if (lh.getHtmlView() != null) {
                lh.getHtmlView().paint(g2, lr.getTextRect());
            } else {
                UISettings.setupAntialiasing((Graphics)g2);
                this.paintText(g2, lh.getMenuItem(), lr.getTextRect(), lh.getText());
            }
        }
    }

    protected void paintArrowIcon(Graphics g2, MenuItemLayoutHelper lh, MenuItemLayoutHelper.LayoutResult lr, Color foreground) {
        if (lh.getArrowIcon() != null) {
            ButtonModel model2 = lh.getMenuItem().getModel();
            if (model2.isArmed() || lh.getMenuItem() instanceof JMenu && model2.isSelected()) {
                g2.setColor(foreground);
            }
            if (lh.useCheckAndArrow()) {
                lh.getArrowIcon().paintIcon(lh.getMenuItem(), g2, lr.getArrowRect().x, lr.getArrowRect().y);
            }
        }
    }
}

