/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.ui.DarculaTextBorder;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.util.ui.JBUI;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPasswordFieldUI;
import javax.swing.text.JTextComponent;

public class DarculaPasswordFieldUI
extends BasicPasswordFieldUI {
    public DarculaPasswordFieldUI(final JPasswordField passwordField) {
        passwordField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e2) {
                passwordField.repaint();
            }

            @Override
            public void focusLost(FocusEvent e2) {
                passwordField.repaint();
            }
        });
    }

    public static ComponentUI createUI(JComponent c2) {
        return new DarculaPasswordFieldUI((JPasswordField)c2);
    }

    @Override
    protected void paintBackground(Graphics graphics) {
        Border border;
        Graphics2D g2 = (Graphics2D)graphics;
        JTextComponent c2 = this.getComponent();
        Container parent = c2.getParent();
        if (c2.isOpaque() && parent != null) {
            g2.setColor(parent.getBackground());
            g2.fillRect(0, 0, c2.getWidth(), c2.getHeight());
        }
        if ((border = c2.getBorder()) instanceof DarculaTextBorder) {
            if (c2.isEnabled() && c2.isEditable()) {
                g2.setColor(c2.getBackground());
            }
            int width = c2.getWidth();
            int height = c2.getHeight();
            Insets i2 = border.getBorderInsets(c2);
            if (c2.hasFocus()) {
                GraphicsConfig config = new GraphicsConfig((Graphics)g2);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                g2.fillRoundRect(i2.left - JBUI.scale((int)5), i2.top - JBUI.scale((int)2), width - i2.left - i2.right + JBUI.scale((int)10), height - i2.top - i2.bottom + JBUI.scale((int)6), JBUI.scale((int)5), JBUI.scale((int)5));
                config.restore();
            } else {
                g2.fillRect(i2.left - JBUI.scale((int)5), i2.top - JBUI.scale((int)2), width - i2.left - i2.right + JBUI.scale((int)12), height - i2.top - i2.bottom + JBUI.scale((int)6));
            }
        } else {
            super.paintBackground(g2);
        }
    }
}

