/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;
import sun.swing.SwingUtilities2;

public class DarculaProgressBarUI
extends BasicProgressBarUI {
    protected volatile int offset = 0;

    public static ComponentUI createUI(JComponent c2) {
        c2.setBorder((Border)JBUI.Borders.empty().asUIResource());
        return new DarculaProgressBarUI();
    }

    @Override
    protected void paintIndeterminate(Graphics g2d, JComponent c2) {
        if (!(g2d instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g2d;
        Insets b2 = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b2.right + b2.left);
        int barRectHeight = this.progressBar.getHeight() - (b2.top + b2.bottom);
        if (barRectWidth <= 0 || barRectHeight <= 0) {
            return;
        }
        g2.setColor((Color)new JBColor((Color)Gray._240, (Color)Gray._128));
        int w2 = c2.getWidth();
        int h2 = c2.getPreferredSize().height;
        if (!DarculaProgressBarUI.isEven(c2.getHeight() - h2)) {
            ++h2;
        }
        if (c2.isOpaque()) {
            g2.fillRect(0, (c2.getHeight() - h2) / 2, w2, h2);
        }
        g2.setColor((Color)new JBColor((Color)Gray._165, (Color)Gray._88));
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g2);
        g2.translate(0, (c2.getHeight() - h2) / 2);
        float R = JBUI.scale((float)8.0f);
        float R2 = JBUI.scale((float)9.0f);
        float off = JBUI.scale((float)1.0f);
        Area innerBorderRoundRect = new Area(new RoundRectangle2D.Float(off, off, (float)w2 - 2.0f * off, (float)h2 - 2.0f * off, R, R));
        Area containingRoundRect = new Area(new RoundRectangle2D.Float(2.0f * off, 2.0f * off, (float)w2 - 4.0f * off, (float)h2 - 4.0f * off, R, R));
        for (int x2 = -this.offset; x2 < Math.max(c2.getWidth(), c2.getHeight()); x2 += this.getPeriodLength()) {
            Path2D.Double path = new Path2D.Double();
            float ww = (float)this.getPeriodLength() / 2.0f;
            path.moveTo(x2, 0.0);
            path.lineTo((float)x2 + ww, 0.0);
            path.lineTo((float)x2 + ww - (float)(h2 / 2), h2);
            path.lineTo(x2 - h2 / 2, h2);
            path.lineTo(x2, 0.0);
            path.closePath();
            Area area = new Area(path);
            area.intersect(containingRoundRect);
            g2.fill(area);
        }
        this.offset = (this.offset + 1) % this.getPeriodLength();
        Area area = new Area(new Rectangle2D.Float(0.0f, 0.0f, w2, h2));
        area.subtract(innerBorderRoundRect);
        g2.setColor((Color)Gray._128);
        if (c2.isOpaque()) {
            g2.fill(area);
        }
        area.subtract(new Area(new RoundRectangle2D.Float(0.0f, 0.0f, w2, h2, R2, R2)));
        g2.setColor(c2.getParent().getBackground());
        if (c2.isOpaque()) {
            g2.fill(area);
        }
        Area insetArea = new Area(innerBorderRoundRect);
        insetArea.subtract(containingRoundRect);
        g2.fill(insetArea);
        g2.translate(0, -(c2.getHeight() - h2) / 2);
        if (this.progressBar.isStringPainted()) {
            if (this.progressBar.getOrientation() == 0) {
                this.paintString((Graphics)g2, b2.left, b2.top, barRectWidth, barRectHeight, this.boxRect.x, this.boxRect.width);
            } else {
                this.paintString((Graphics)g2, b2.left, b2.top, barRectWidth, barRectHeight, this.boxRect.y, this.boxRect.height);
            }
        }
        config.restore();
    }

    @Override
    protected void paintDeterminate(Graphics g2, JComponent c2) {
        if (!(g2 instanceof Graphics2D)) {
            return;
        }
        if (this.progressBar.getOrientation() != 0 || !c2.getComponentOrientation().isLeftToRight()) {
            super.paintDeterminate(g2, c2);
            return;
        }
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g2);
        Insets b2 = this.progressBar.getInsets();
        int w2 = this.progressBar.getWidth();
        int h2 = this.progressBar.getPreferredSize().height;
        if (!DarculaProgressBarUI.isEven(c2.getHeight() - h2)) {
            ++h2;
        }
        int barRectWidth = w2 - (b2.right + b2.left);
        int barRectHeight = h2 - (b2.top + b2.bottom);
        if (barRectWidth <= 0 || barRectHeight <= 0) {
            return;
        }
        int amountFull = this.getAmountFull(b2, barRectWidth, barRectHeight);
        g2.setColor(c2.getParent().getBackground());
        Graphics2D g22 = (Graphics2D)g2;
        if (c2.isOpaque()) {
            g2.fillRect(0, 0, w2, h2);
        }
        float R = JBUI.scale((float)8.0f);
        float R2 = JBUI.scale((float)9.0f);
        float off = JBUI.scale((float)1.0f);
        g22.translate(0, (c2.getHeight() - h2) / 2);
        g22.setColor(this.progressBar.getForeground());
        g22.fill(new RoundRectangle2D.Float(0.0f, 0.0f, (float)w2 - off, (float)h2 - off, R2, R2));
        g22.setColor(c2.getParent().getBackground());
        g22.fill(new RoundRectangle2D.Float(off, off, (float)w2 - 2.0f * off - off, (float)h2 - 2.0f * off - off, R, R));
        g22.setColor(this.progressBar.getForeground());
        g22.fill(new RoundRectangle2D.Float(2.0f * off, 2.0f * off, (float)amountFull - JBUI.scale((float)5.0f), (float)h2 - JBUI.scale((float)5.0f), JBUI.scale((float)7.0f), JBUI.scale((float)7.0f)));
        g22.translate(0, -(c2.getHeight() - h2) / 2);
        if (this.progressBar.isStringPainted()) {
            this.paintString(g2, b2.left, b2.top, barRectWidth, barRectHeight, amountFull, b2);
        }
        config.restore();
    }

    private void paintString(Graphics g2, int x2, int y2, int w2, int h2, int fillStart, int amountFull) {
        if (!(g2 instanceof Graphics2D)) {
            return;
        }
        Graphics2D g22 = (Graphics2D)g2;
        String progressString = this.progressBar.getString();
        g22.setFont(this.progressBar.getFont());
        Point renderLocation = this.getStringPlacement(g22, progressString, x2, y2, w2, h2);
        Rectangle oldClip = g22.getClipBounds();
        if (this.progressBar.getOrientation() == 0) {
            g22.setColor(this.getSelectionBackground());
            SwingUtilities2.drawString((JComponent)this.progressBar, (Graphics)g22, progressString, renderLocation.x, renderLocation.y);
            g22.setColor(this.getSelectionForeground());
            g22.clipRect(fillStart, y2, amountFull, h2);
            SwingUtilities2.drawString((JComponent)this.progressBar, (Graphics)g22, progressString, renderLocation.x, renderLocation.y);
        } else {
            g22.setColor(this.getSelectionBackground());
            AffineTransform rotate = AffineTransform.getRotateInstance(1.5707963267948966);
            g22.setFont(this.progressBar.getFont().deriveFont(rotate));
            renderLocation = this.getStringPlacement(g22, progressString, x2, y2, w2, h2);
            SwingUtilities2.drawString((JComponent)this.progressBar, (Graphics)g22, progressString, renderLocation.x, renderLocation.y);
            g22.setColor(this.getSelectionForeground());
            g22.clipRect(x2, fillStart, w2, amountFull);
            SwingUtilities2.drawString((JComponent)this.progressBar, (Graphics)g22, progressString, renderLocation.x, renderLocation.y);
        }
        g22.setClip(oldClip);
    }

    @Override
    protected int getBoxLength(int availableLength, int otherDimension) {
        return availableLength;
    }

    protected int getPeriodLength() {
        return JBUI.scale((int)16);
    }

    private static boolean isEven(int value2) {
        return value2 % 2 == 0;
    }
}

