/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBGradientPaint;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalRadioButtonUI;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class DarculaRadioButtonUI
extends MetalRadioButtonUI {
    public static ComponentUI createUI(JComponent c2) {
        return new DarculaRadioButtonUI();
    }

    @Override
    public synchronized void paint(Graphics g2d, JComponent c2) {
        Graphics2D g2 = (Graphics2D)g2d;
        Dimension size = c2.getSize();
        Rectangle viewRect = new Rectangle(size);
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        AbstractButton b2 = (AbstractButton)c2;
        Font f2 = c2.getFont();
        g2.setFont(f2);
        FontMetrics fm = SwingUtilities2.getFontMetrics(c2, g2, f2);
        String text2 = SwingUtilities.layoutCompoundLabel(c2, fm, b2.getText(), this.getDefaultIcon(), b2.getVerticalAlignment(), b2.getHorizontalAlignment(), b2.getVerticalTextPosition(), b2.getHorizontalTextPosition(), viewRect, iconRect, textRect, b2.getIconTextGap());
        if (c2.isOpaque()) {
            g2.setColor(c2.getBackground());
            g2.fillRect(0, 0, size.width, size.height);
        }
        this.paintIcon(c2, g2, viewRect, iconRect);
        this.drawText(b2, g2, text2, textRect, fm);
    }

    protected void paintIcon(JComponent c2, Graphics2D g2, Rectangle viewRect, Rectangle iconRect) {
        Insets i2 = c2.getInsets();
        viewRect.x += i2.left;
        viewRect.y += i2.top;
        viewRect.width -= i2.right + viewRect.x;
        viewRect.height -= i2.bottom + viewRect.y;
        int rad = JBUI.scale((int)5);
        int x2 = iconRect.x + (rad - (rad % 2 == 1 ? 1 : 0)) / 2;
        int y2 = iconRect.y + (rad - (rad % 2 == 1 ? 1 : 0)) / 2;
        int w2 = iconRect.width - rad;
        int h2 = iconRect.height - rad;
        g2.translate(x2, y2);
        JBGradientPaint ijGradient = new JBGradientPaint(c2, new Color(4818404), new Color(4224201));
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g2);
        boolean focus = c2.hasFocus();
        boolean selected = ((AbstractButton)c2).isSelected();
        if (UIUtil.isUnderDarcula() || !selected) {
            g2.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)ColorUtil.shift((Color)c2.getBackground(), (double)1.5), (float)0.0f, (float)c2.getHeight(), (Color)ColorUtil.shift((Color)c2.getBackground(), (double)1.2)));
        } else {
            g2.setPaint((Paint)ijGradient);
        }
        if (!UIUtil.isUnderDarcula() && selected) {
            GraphicsConfig fillOvalConf = new GraphicsConfig((Graphics)g2);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g2.fillOval(0, JBUI.scale((int)1), w2, h2);
            fillOvalConf.restore();
        } else if (focus) {
            g2.fillOval(0, JBUI.scale((int)1), w2, h2);
        } else {
            g2.fillOval(0, JBUI.scale((int)1), w2 - JBUI.scale((int)1), h2 - JBUI.scale((int)1));
        }
        if (focus) {
            if (JBUI.isPixHiDPI((Component)c2)) {
                DarculaUIUtil.paintFocusOval(g2, JBUI.scale((int)1), JBUI.scale((int)1) + 1, w2 - JBUI.scale((int)2), h2 - JBUI.scale((int)2));
            } else {
                DarculaUIUtil.paintFocusOval(g2, 0, JBUI.scale((int)1), w2, h2);
            }
        } else if (UIUtil.isUnderDarcula()) {
            g2.setPaint(UIUtil.getGradientPaint((float)(w2 / 2), (float)1.0f, (Color)Gray._160.withAlpha(90), (float)(w2 / 2), (float)h2, (Color)Gray._100.withAlpha(90)));
            g2.drawOval(0, JBUI.scale((int)1) + 1, w2 - 1, h2 - 1);
            g2.setPaint(Gray._40.withAlpha(200));
            g2.drawOval(0, JBUI.scale((int)1), w2 - 1, h2 - 1);
        } else {
            g2.setPaint((Paint)(selected ? ijGradient : (c2.isEnabled() ? Gray._30 : Gray._130)));
            if (!selected) {
                g2.drawOval(0, JBUI.scale((int)1), w2 - 1, h2 - 1);
            }
        }
        if (selected) {
            boolean enabled = c2.isEnabled();
            g2.setColor(UIManager.getColor(enabled ? "RadioButton.darcula.selectionEnabledShadowColor" : "RadioButton.darcula.selectionDisabledShadowColor"));
            int yOff = 1 + JBUI.scale((int)1);
            g2.fillOval(w2 / 2 - rad / 2, h2 / 2 - rad / 2 + yOff, rad, rad);
            g2.setColor(UIManager.getColor(enabled ? "RadioButton.darcula.selectionEnabledColor" : "RadioButton.darcula.selectionDisabledColor"));
            g2.fillOval(w2 / 2 - rad / 2, h2 / 2 - rad / 2 - 1 + yOff, rad, rad);
        }
        config.restore();
        g2.translate(-x2, -y2);
    }

    protected void drawText(AbstractButton b2, Graphics2D g2, String text2, Rectangle textRect, FontMetrics fm) {
        if (text2 != null) {
            View v2 = (View)b2.getClientProperty("html");
            if (v2 != null) {
                v2.paint(g2, textRect);
            } else {
                int mnemIndex = b2.getDisplayedMnemonicIndex();
                if (b2.isEnabled()) {
                    g2.setColor(b2.getForeground());
                } else {
                    g2.setColor(this.getDisabledTextColor());
                }
                SwingUtilities2.drawStringUnderlineCharAt(b2, g2, text2, mnemIndex, textRect.x, textRect.y + fm.getAscent());
            }
        }
        if (b2.hasFocus() && b2.isFocusPainted() && textRect.width > 0 && textRect.height > 0) {
            this.paintFocus(g2, textRect, b2.getSize());
        }
    }

    @Override
    protected void paintFocus(Graphics g2, Rectangle t2, Dimension d2) {
    }

    @Override
    public Icon getDefaultIcon() {
        return ((EmptyIcon)JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)20))).asUIResource();
    }
}

