/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;

public class DarculaSpinnerBorder
implements Border,
UIResource {
    @Override
    public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        JSpinner spinner = (JSpinner)c2;
        JFormattedTextField editor = (JFormattedTextField)UIUtil.findComponentOfType((JComponent)spinner, JFormattedTextField.class);
        int x1 = x2 + 1;
        int y1 = y2 + 3;
        int width1 = width - 2;
        int height1 = height - 6;
        boolean focused = c2.isEnabled() && c2.isVisible() && editor != null && editor.hasFocus();
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g2);
        if (c2.isOpaque()) {
            g2.setColor(UIUtil.getPanelBackground());
            g2.fillRect(x2, y2, width, height);
        }
        g2.setColor(UIUtil.getTextFieldBackground());
        g2.fillRoundRect(x1, y1, width1, height1, 5, 5);
        g2.setColor(UIManager.getColor(spinner.isEnabled() ? "Spinner.darcula.enabledButtonColor" : "Spinner.darcula.disabledButtonColor"));
        if (editor != null) {
            int off = editor.getBounds().x + editor.getWidth() + ((JSpinner)c2).getInsets().left + 1;
            Area rect = new Area(new RoundRectangle2D.Double(x1, y1, width1, height1, 5.0, 5.0));
            Area blueRect = new Area(new Rectangle(off, y1, 22, height1));
            rect.intersect(blueRect);
            ((Graphics2D)g2).fill(rect);
            if (UIUtil.isUnderDarcula()) {
                g2.setColor((Color)Gray._100);
                g2.drawLine(off, y1, off, height1 + 2);
            }
        }
        if (!c2.isEnabled()) {
            ((Graphics2D)g2).setComposite(AlphaComposite.getInstance(3, 0.4f));
        }
        if (focused) {
            DarculaUIUtil.paintFocusRing(g2, new Rectangle(x1 + 2, y1, width1 - 3, height1));
        } else {
            g2.setColor((Color)new JBColor((Color)Gray._149, (Color)Gray._100));
            g2.drawRoundRect(x1, y1, width1, height1, 5, 5);
        }
        config.restore();
    }

    @Override
    public Insets getBorderInsets(Component c2) {
        return new InsetsUIResource(5, 7, 5, 7);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

