/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextFieldUI;
import com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.Gray;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

public class DarculaTextBorder
implements Border,
UIResource {
    @Override
    public Insets getBorderInsets(Component c2) {
        int vOffset;
        int n2 = vOffset = TextFieldWithPopupHandlerUI.isSearchField(c2) ? 6 : 4;
        if (TextFieldWithPopupHandlerUI.isSearchFieldWithHistoryPopup(c2)) {
            return JBUI.insets((int)vOffset, (int)26, (int)vOffset, (int)23).asUIResource();
        }
        if (TextFieldWithPopupHandlerUI.isSearchField(c2)) {
            return JBUI.insets((int)vOffset, (int)23, (int)vOffset, (int)23).asUIResource();
        }
        if (c2 instanceof JTextField && c2.getParent() instanceof ColorPanel) {
            return JBUI.insets((int)3, (int)3, (int)2, (int)2).asUIResource();
        }
        return JBUI.insets((int)vOffset, (int)7, (int)vOffset, (int)7).asUIResource();
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        if (DarculaTextFieldUI.isSearchField(c2)) {
            return;
        }
        Graphics2D g22 = (Graphics2D)g2.create();
        try {
            g22.translate(x2, y2);
            Object eop = ((JComponent)c2).getClientProperty("JComponent.error.outline");
            if (Registry.is((String)"ide.inplace.errors.outline") && Boolean.parseBoolean(String.valueOf(eop))) {
                DarculaUIUtil.paintErrorBorder(g22, width, height, c2.hasFocus());
                if (Registry.is((String)"ide.inplace.errors.balloon") && c2.hasFocus()) {
                    DarculaUIUtil.showErrorTip((JComponent)c2);
                }
            } else if (c2.hasFocus()) {
                DarculaUIUtil.paintFocusRing(g22, new Rectangle(JBUI.scale((int)1), JBUI.scale((int)1), width - JBUI.scale((int)2), height - JBUI.scale((int)2)));
            } else {
                boolean editable = !(c2 instanceof JTextComponent) || ((JTextComponent)c2).isEditable();
                g22.setColor(DarculaTextBorder.getBorderColor(c2.isEnabled() && editable));
                g22.drawRect(JBUI.scale((int)1), JBUI.scale((int)1), width - JBUI.scale((int)2), height - JBUI.scale((int)2));
            }
        }
        finally {
            g22.dispose();
        }
    }

    private static Color getBorderColor(boolean enabled) {
        if (UIUtil.isUnderDarcula()) {
            return enabled ? Gray._100 : Gray._83;
        }
        return Gray._150;
    }
}

