/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextBorder;
import com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.Gray;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class DarculaTextFieldUI
extends TextFieldWithPopupHandlerUI {
    public DarculaTextFieldUI(JTextField textField) {
        super(textField);
    }

    public static ComponentUI createUI(JComponent c2) {
        return new DarculaTextFieldUI((JTextField)c2);
    }

    @Override
    public void showSearchPopup() {
        Object value2 = this.myTextField.getClientProperty("JTextField.Search.FindPopup");
        JTextComponent editor = this.getComponent();
        if (editor != null && value2 instanceof JPopupMenu) {
            JPopupMenu popup2 = (JPopupMenu)value2;
            popup2.show(editor, this.getSearchIconCoord().x, editor.getHeight());
        }
    }

    @Override
    public TextFieldWithPopupHandlerUI.SearchAction getActionUnder(@NotNull Point p2) {
        if (p2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/ide/ui/laf/darcula/ui/DarculaTextFieldUI", "getActionUnder"));
        }
        int off = JBUI.scale((int)8);
        Point point = new Point(p2.x - off, p2.y - off);
        return point.distance(this.getSearchIconCoord()) <= (double)off ? TextFieldWithPopupHandlerUI.SearchAction.POPUP : (this.hasText() && point.distance(this.getClearIconCoord()) <= (double)off ? TextFieldWithPopupHandlerUI.SearchAction.CLEAR : null);
    }

    protected Rectangle getDrawingRect() {
        JTextField c2 = this.myTextField;
        JBInsets i2 = JBInsets.create((Insets)c2.getInsets());
        int x2 = i2.right - JBUI.scale((int)4) - JBUI.scale((int)16);
        int y2 = i2.top - JBUI.scale((int)3);
        int w2 = c2.getWidth() - i2.width() + JBUI.scale((int)41);
        int h2 = c2.getBounds().height - i2.height() + JBUI.scale((int)5);
        if (h2 % 2 == 1) {
            ++h2;
        }
        return new Rectangle(x2, y2, w2, h2);
    }

    protected Point getSearchIconCoord() {
        Rectangle r2 = this.getDrawingRect();
        return new Point(r2.x + JBUI.scale((int)3), r2.y + (r2.height - JBUI.scale((int)16)) / 2 + JBUI.scale((int)1));
    }

    protected Point getClearIconCoord() {
        Rectangle r2 = this.getDrawingRect();
        return new Point(r2.x + r2.width - JBUI.scale((int)16) - JBUI.scale((int)2), r2.y + (r2.height - JBUI.scale((int)16)) / 2);
    }

    @Override
    protected void paintBackground(Graphics graphics) {
        Graphics2D g2 = (Graphics2D)graphics;
        JTextComponent c2 = this.getComponent();
        Container parent = c2.getParent();
        Rectangle r2 = this.getDrawingRect();
        if (c2.isOpaque() && parent != null) {
            g2.setColor(parent.getBackground());
            g2.fillRect(0, 0, c2.getWidth(), c2.getHeight());
        }
        GraphicsConfig config = new GraphicsConfig((Graphics)g2);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        Border border = c2.getBorder();
        if (DarculaTextFieldUI.isSearchField(c2)) {
            this.paintSearchField(g2, c2, r2);
        } else if (border instanceof DarculaTextBorder) {
            this.paintDarculaBackground(g2, c2, border);
        } else {
            super.paintBackground(g2);
        }
        config.restore();
    }

    protected void paintDarculaBackground(Graphics2D g2, JTextComponent c2, Border border) {
        if (c2.isEnabled() && c2.isEditable()) {
            g2.setColor(c2.getBackground());
        }
        int width = c2.getWidth();
        int height = c2.getHeight();
        Insets i2 = border.getBorderInsets(c2);
        if (c2.hasFocus()) {
            g2.fillRoundRect(i2.left - JBUI.scale((int)5), i2.top - JBUI.scale((int)2), width - i2.right - i2.left + JBUI.scale((int)10), height - i2.top - i2.bottom + JBUI.scale((int)6), JBUI.scale((int)5), JBUI.scale((int)5));
        } else {
            g2.fillRect(i2.left - JBUI.scale((int)5), i2.top - JBUI.scale((int)2), width - i2.right - i2.left + JBUI.scale((int)10), height - i2.top - i2.bottom + JBUI.scale((int)6));
        }
    }

    protected void paintSearchField(Graphics2D g2, JTextComponent c2, Rectangle r2) {
        Icon searchIcon;
        boolean noBorder = c2.getClientProperty("JTextField.Search.noBorderRing") == Boolean.TRUE;
        int radius = r2.height - 1;
        if (noBorder) {
            g2.setColor(c2.getBackground());
            RectanglePainter.FILL.paint(g2, r2.x, r2.y, r2.width, r2.height, (Object)radius);
        } else if (c2.hasFocus()) {
            g2.setColor(c2.getBackground());
            RectanglePainter.FILL.paint(g2, r2.x, r2.y, r2.width, r2.height, (Object)radius);
            DarculaUIUtil.paintSearchFocusRing(g2, r2, c2);
        } else {
            RectanglePainter.paint((Graphics2D)g2, (int)r2.x, (int)r2.y, (int)r2.width, (int)r2.height, (int)radius, (Color)c2.getBackground(), (Color)(c2.isEnabled() ? Gray._100 : Gray._83));
        }
        Point p2 = this.getSearchIconCoord();
        Icon icon = searchIcon = this.myTextField.getClientProperty("JTextField.Search.FindPopup") instanceof JPopupMenu ? UIManager.getIcon("TextField.darcula.searchWithHistory.icon") : UIManager.getIcon("TextField.darcula.search.icon");
        if (searchIcon == null) {
            searchIcon = IconLoader.findIcon((String)"/com/intellij/ide/ui/laf/icons/search.png", DarculaTextFieldUI.class, (boolean)true);
        }
        searchIcon.paintIcon(null, g2, p2.x, p2.y);
        if (this.hasText()) {
            p2 = this.getClearIconCoord();
            Icon clearIcon = UIManager.getIcon("TextField.darcula.clear.icon");
            if (clearIcon == null) {
                clearIcon = IconLoader.findIcon((String)"/com/intellij/ide/ui/laf/icons/clear.png", DarculaTextFieldUI.class, (boolean)true);
            }
            clearIcon.paintIcon(null, g2, p2.x, p2.y);
        }
    }

    @Override
    protected void paintSafely(Graphics g2) {
        this.paintBackground(g2);
        super.paintSafely(g2);
    }
}

