/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextFieldWithPopupHandlerUI
extends BasicTextFieldUI
implements Condition {
    protected final JTextField myTextField;
    private MyMouseMotionAdapter myMyMouseMotionAdapter;
    private MyMouseAdapter myMouseAdapter;
    private FocusAdapter myFocusAdapter;

    public TextFieldWithPopupHandlerUI(JTextField textField) {
        this.myTextField = textField;
        this.installListeners();
    }

    protected boolean hasText() {
        JTextComponent component = this.getComponent();
        return component != null && !StringUtil.isEmpty((String)component.getText());
    }

    protected abstract SearchAction getActionUnder(@NotNull Point var1);

    protected abstract void showSearchPopup();

    @Override
    protected void installListeners() {
        TextFieldWithPopupHandlerUI ui = this;
        this.myFocusAdapter = new MyFocusAdapter();
        this.myTextField.addFocusListener(this.myFocusAdapter);
        this.myMyMouseMotionAdapter = new MyMouseMotionAdapter(ui);
        this.myTextField.addMouseMotionListener(this.myMyMouseMotionAdapter);
        this.myMouseAdapter = new MyMouseAdapter(ui);
        this.myTextField.addMouseListener(this.myMouseAdapter);
    }

    @Override
    protected void uninstallListeners() {
        this.myTextField.removeFocusListener(this.myFocusAdapter);
        this.myTextField.removeMouseMotionListener(this.myMyMouseMotionAdapter);
        this.myTextField.removeMouseListener(this.myMouseAdapter);
    }

    @Override
    public int getNextVisualPositionFrom(JTextComponent t2, int pos, Position.Bias b2, int direction, Position.Bias[] biasRet) throws BadLocationException {
        int position = DarculaUIUtil.getPatchedNextVisualPositionFrom(t2, pos, direction);
        return position != -1 ? position : super.getNextVisualPositionFrom(t2, pos, b2, direction, biasRet);
    }

    public boolean value(Object o2) {
        MouseEvent me;
        if (o2 instanceof MouseEvent && this.getActionUnder((me = (MouseEvent)o2).getPoint()) != null) {
            if (me.getID() == 500) {
                SwingUtilities.invokeLater(() -> this.myMouseAdapter.mouseClicked(me));
            }
            return true;
        }
        return false;
    }

    public static boolean isSearchField(Component c2) {
        return c2 instanceof JTextField && "search".equals(((JTextField)c2).getClientProperty("JTextField.variant"));
    }

    public static boolean isSearchFieldWithHistoryPopup(Component c2) {
        return TextFieldWithPopupHandlerUI.isSearchField(c2) && ((JTextField)c2).getClientProperty("JTextField.Search.FindPopup") instanceof JPopupMenu;
    }

    @Nullable
    public static AbstractAction getNewLineAction(Component c2) {
        if (!TextFieldWithPopupHandlerUI.isSearchField(c2) || !Registry.is((String)"ide.find.show.add.newline.hint")) {
            return null;
        }
        Object action2 = ((JTextField)c2).getClientProperty("JTextField.Search.NewLineAction");
        return action2 instanceof AbstractAction ? (AbstractAction)action2 : null;
    }

    private class MyFocusAdapter
    extends FocusAdapter {
        private MyFocusAdapter() {
        }

        @Override
        public void focusGained(FocusEvent e2) {
            TextFieldWithPopupHandlerUI.this.myTextField.repaint();
        }

        @Override
        public void focusLost(FocusEvent e2) {
            TextFieldWithPopupHandlerUI.this.myTextField.repaint();
        }
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private final TextFieldWithPopupHandlerUI myUi;

        public MyMouseAdapter(TextFieldWithPopupHandlerUI ui) {
            this.myUi = ui;
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            SearchAction action2;
            if (TextFieldWithPopupHandlerUI.isSearchField(TextFieldWithPopupHandlerUI.this.myTextField) && (action2 = this.myUi.getActionUnder(e2.getPoint())) != null) {
                switch (action2) {
                    case POPUP: {
                        this.myUi.showSearchPopup();
                        break;
                    }
                    case CLEAR: {
                        Object listener2 = TextFieldWithPopupHandlerUI.this.myTextField.getClientProperty("JTextField.Search.CancelAction");
                        if (listener2 instanceof ActionListener) {
                            ((ActionListener)listener2).actionPerformed(new ActionEvent(this, 1001, "action"));
                        }
                        TextFieldWithPopupHandlerUI.this.myTextField.setText("");
                        break;
                    }
                    case NEWLINE: {
                        AbstractAction newLineAction = TextFieldWithPopupHandlerUI.getNewLineAction(TextFieldWithPopupHandlerUI.this.myTextField);
                        if (newLineAction == null) break;
                        newLineAction.actionPerformed(new ActionEvent(TextFieldWithPopupHandlerUI.this.myTextField, 1001, "action"));
                        break;
                    }
                }
                e2.consume();
            }
        }
    }

    private class MyMouseMotionAdapter
    extends MouseMotionAdapter {
        private final TextFieldWithPopupHandlerUI myUi;

        public MyMouseMotionAdapter(TextFieldWithPopupHandlerUI ui) {
            this.myUi = ui;
        }

        @Override
        public void mouseMoved(MouseEvent e2) {
            if (this.myUi.getComponent() != null && TextFieldWithPopupHandlerUI.isSearchField(TextFieldWithPopupHandlerUI.this.myTextField)) {
                SearchAction action2 = this.myUi.getActionUnder(e2.getPoint());
                if (action2 == SearchAction.POPUP && !TextFieldWithPopupHandlerUI.isSearchFieldWithHistoryPopup(TextFieldWithPopupHandlerUI.this.myTextField)) {
                    action2 = null;
                }
                if (action2 != null) {
                    TextFieldWithPopupHandlerUI.this.myTextField.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    TextFieldWithPopupHandlerUI.this.myTextField.setCursor(Cursor.getPredefinedCursor(2));
                }
            }
        }
    }

    public static enum SearchAction {
        POPUP,
        CLEAR,
        NEWLINE;

    }
}

